<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the controller to call when that URI is requested.
|
*/

// Model Injection via Route
Route::model('domain', 'App\Domain');
Route::model('order', 'App\Orders');

// Domains ( home, single and all )
Route::get('/', 'Main@home');
Route::get('info/{domain}', 'Main@domain_info');
Route::get('domains', 'Main@all_domains');

// Cart 
Route::get('checkout', 'Ajax@cart_contents');
Route::get('ajax/add-to-cart/{domain}', 'Ajax@add_to_cart');
Route::get('cart/remove/{rowId}', 'Ajax@remove_from_cart');

// Checkout
Route::get('checkout/credit-card', 'Checkout@credit_card');
Route::post('checkout/credit-card', 'Checkout@credit_card_processing');
Route::get('checkout/paypal', 'Checkout@paypal');
Route::get('checkout/success', 'Checkout@success');
Route::get('checkout/paypal-complete', 'Checkout@paypal_complete');

// Contact
Route::get('contact', 'Main@contact');
Route::post('contact', 'Main@process_contact');

// Admin log-in
Route::any('admin/login', 'Admin@login');

// Admin log-out
Route::any('admin/logout', 'Admin@logout');

// admin panel routes
Route::group(['middleware' => 'App\Http\Middleware\AdminMiddleware'], function () {
	
	Route::get('admin', 'Admin@dashboard');

	// Domain Related
	Route::get('admin/domains', 'Admin@domains_overview');
	Route::get('admin/add-domain', 'Admin@add_domain');
	Route::post('admin/add-domain', 'Admin@add_domain_process');
	Route::get('admin/manage-domain/{domain}', 'Admin@manage_domain');
	Route::post('admin/manage-domain/{domain}', 'Admin@manage_domain_update');


	// Order related
	Route::get('admin/view-order/{order}', 'Admin@view_order');
	
	// CMS 
	Route::get('admin/cms', ['uses' => 'Admin@pages', 'as' => 'admin-cms'] );
	Route::post('admin/cms', 'Admin@create_page');

	// CMS: update page
	Route::get('admin/cms-edit/{id}', function($id) {
		$page = App\Page::findOrFail($id);
		return view('admin.update-page')->with('p', $page)->with('active', 'pages');
	});


	// CMS : update a page
	Route::post('admin/cms-edit/{id}', function($id) {

		$page = App\Page::findOrFail($id);
		$page->page_title = Request::get('page_title');
		$page->page_content = Request::get('page_content');
		$page->save();

		return redirect('admin/cms-edit/' . $id)->with('msg', 'Page successfully created');

	});

	// pages CMS : delete page
	Route::delete('admin/cms-delete/{id}', function($id) {

		if( $id != 1 ) {
			App\Page::destroy($id);
			$msg = 'Page successfully removed';
		} else {
			$msg = 'You cannot remove homepage sorry.';
		}


		return redirect()->route('admin-cms')->with('msg', $msg);
	});


	// navigation manager : overview
	Route::get('admin/navigation', 'Admin@navigation');
	// navigation manager : save item to menu
	Route::post('admin/navigation', 'Admin@navigation_save');
	// navigation manager : edit item form
	Route::get('admin/navigation/edit/{id}', function($id) {
		$nav_item = App\Navi::findOrFail($id);
		return view('admin.navigation-edit')->with('n', $nav_item);
	});

	// navigation manager : update item
	Route::post('admin/navigation/edit/{id}', function($id) {
		$nav_item = App\Navi::findOrFail($id);
		$nav_item->title = request('title');
		$nav_item->url = request('url');
		$nav_item->target = request('target');
		$nav_item->save();

		return redirect('admin/navigation')->with('msg', 'Menu item successfully saved');

	});

	// navigation manager : delete item from menu
	Route::delete('admin/navigation/delete/{id}', function($id) {
		App\Navi::destroy($id);
		return redirect('admin/navigation')->with('msg', 'Menu item successfully removed');
	});
	// navigation manager : save order of menu items
	Route::get('admin/navigation-ajax-sort', function() {
		$navi_order = implode(',',request('navi_order'));
		App\Options::update_option('navi_order', $navi_order);
		return "Order successfully saved";
	});

	Route::get('admin/configuration', function() {
			return view('admin.configuration')->with('active', 'config');
		});

	Route::post('admin/configuration', function() {
		$options = request()->except('_token', 'sb_settings');

		// logo updated?
		if( request()->hasFile('homepage_header_image') ) {
			$ext = request()->file('homepage_header_image')->getClientOriginalExtension();
			$destinationPath = base_path() . '/resources/assets/images/';
			$fileName = 'photographer-items.jpg';
			request()->file('homepage_header_image')->move($destinationPath, $fileName);
		}

		// save options
		foreach( $options as $name => $value ) {
			App\Options::update_option( $name, $value );
		}

		return redirect('admin/configuration')->with('msg', 'Configuration settings successfully saved!');
	});


});

// The rest: CMS Pages routes
Route::get( '{any}', 'PageController@page' );
