<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Domain;

class Main extends Controller
{
    // home controller
    public function home() {

    	// get domain list from database
    	$domain_list = Domain::orderBy('id', 'DESC')
                                ->where('domain_status', '!=', 'SOLD')
                                ->take(6)
                                ->get();

    	// return homepage
    	return view('homepage')->with('domains', $domain_list);
    }

    // domain info controller
    public function domain_info( $domain ) {
		return view('domain-info')->with('domain', $domain);
    }

    // all domains
    public function all_domains() {

        /*
        $faker = \Faker\Factory::create();

        for( $i = 0; $i <= 50; $i++ ) {

            $reg_date = $faker->date('d-m-Y');
            $exp_date = $faker->date('d-m-Y');

            $insert = ['domain' => $faker->domainName, 
                        'pricing' => $faker->numberBetween(100, 100000), 
                        'registrar' => $faker->firstName, 
                        'reg_date' => date("d-m-Y", strtotime("-" . rand(1,5) . " Years")), 
                        'exp_date' => date("d-m-Y", strtotime("+" . rand(1, 25) . " Months")), 
                        'domain_age' =>  rand(1, 12), 
                        'short_description' => $faker->sentence(10), 
                        'description' => $faker->paragraphs(4,1) ];

            $new_domain = \App\Domain::create( $insert );
        }

        exit;
        */

        // get domain list from database
        $domain_list = Domain::orderBy('id', 'DESC')
                            ->where('domain_status', '!=', 'SOLD')
                            ->get();


        // get tlds
        $tlds  = Domain::getAvailableExtensions();

        // show view
        return view('all-domains')
                    ->with('domains', $domain_list)
                    ->with('tlds', $tlds);
        
    }

    // Contact page route
    public function contact() {
        return view('contact');
    }

    // Process contact form entry
    public function process_contact( Request $r ) {

        // validate contact form
        $validator = \Validator::make( $r->all(), [
            'name' => 'required',
            'subject' => 'required',
            'email' => 'required|email',
            'message' => 'required|min:10',
        ]);

        if ($validator->fails()) {
            return redirect('contact')
                        ->withErrors($validator)
                        ->withInput();
        }


        // send email to admin
        $from = \Input::get('email');

        try {

             \Mail::send('emails.contact-notification', [ 'input' => \Input::all() ], function ($m) use( $from ) {

                $m->to( \App\Options::get_option('contact_email') , 'Site Admin')
                  ->subject( 'New Contact Form Message' )
                  ->from( $from );
            });

            return redirect('contact')
                ->with('message', 'Thank you for contacting us, we will get back to you soon!');

        } catch( \Exception $e ) {

            return redirect('contact')
                ->with('message', $e->getMessage());

        }
        
    }

}
