<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;

class Ajax extends Controller
{
    // add to cart 
    public function add_to_cart ( $domain ) {

    	// add this domain to cart
    	try {
    		\Cart::add( $domain->id, $domain->domain, 1, $domain->pricing, 0.00 ); 
    	} catch( \Exception $e ){
    		return $e->getMessage();
    	}

    }

    // cart contents
    public function cart_contents() {

    	$cart = \Cart::content(true);

    	return view('cart')->with( 'cart', $cart );
    }

    // remove from cart
    public function remove_from_cart( $rowId ) {

    	// try removing 
    	try {

    		\Cart::remove( $rowId );

			$r = [ 'message' => 'Product successfully removed from cart.', 
				   'message_type' => 'success' ];

    	} catch ( \Exception $e ) {

			$r = [ 'message' => $e->getMessage(), 
				   'message_type' => 'warning' ];

    	}


    	// return with flash data
    	return redirect('checkout')
    					->with('message', $r['message'])
    					->with('message_type', $r['message_type']);
    	
    }
}
