<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;

use App\Http\Requests;
use App\Http\Controllers\Controller;
use App\Page;
use App\Navi;
use App\Options;
use App\Domain;
use App\Orders;
use Mail;

class Admin extends Controller
{

    // GET|POST /admin/login
    public function login() {

        $message = '';

        if( \Request::isMethod('post') ) {
            if( \Input::has('ausername') AND \Input::has('apassword') ) {
                if( \Input::get('ausername') == env('ADMIN_USER') AND 
                    \Input::get('apassword') == env('ADMIN_PASS') ) {
                    \Session::put('admin', 'true');
                    return redirect('admin');
                }else{
                    $message = '<div class="alert alert-danger">Invalid login.</div>';  
                }
            }else{
                $message = '<div class="alert alert-danger">User/password required</div>';
            }
        }

        return view('admin-login')->with('message', $message);
    }

    // GET /admin/logout
    public function logout() {
        \Session::forget('admin');
        return redirect('/admin/login');
    }

    public function dashboard() {

        // if remove
        if( $removeId = \Input::get('remove') ) {
            
            // remove from db
            $d = Orders::findOrFail($removeId);
            $d->delete();

            return redirect('admin')->with('msg', 'Successfully removed order "#'.$d->id.'"');
        }

        // orders ( list all )
        $orders = Orders::orderBy('id', 'DESC')->get();

        // earnings & sales MTD
        $mtd_count = Orders::where('order_date', '>=', \Carbon\Carbon::now()->startOfMonth())
                            ->where('order_status', '=', 'Paid')
                            ->count();
        $earnings_mtd = Orders::where('order_date', '>=', \Carbon\Carbon::now()->startOfMonth())
                            ->where('order_status', '=', 'Paid')
                            ->sum('total');


        // earnings & sales ALL TIME
        $all_time_earnings = Orders::where('order_status', '=', 'Paid')->sum('total');
        $all_time_sales = Orders::where('order_status', '=', 'Paid')->count();

        // earnings past 30 days
        $date = \Carbon\Carbon::parse( '31 days ago' );

        $days = Orders::select(array(
                \DB::raw('DATE(`order_date`) as `date`'),
                \DB::raw('SUM(`total`) as `total`')
            ))
            ->where('order_date', '>', $date)
            ->groupBy('date')
            ->orderBy('date', 'DESC')
            ->lists('total', 'date');

        // finally, return the view
        return view('admin.dashboard')
                    ->with('active', 'dashboard')
                    ->with('orders', $orders)
                    ->with('mtd_count', $mtd_count)
                    ->with('earnings_mtd', $earnings_mtd)
                    ->with('all_time_sales', $all_time_sales)
                    ->with('all_time_earnings', $all_time_earnings)
                    ->with('earnings_30_days', $days);

    }

    // view order info
    public function view_order( \App\Orders $order ) {

        // order contents unserialize
        $order_content = json_decode( $order->order_contents );

        // return view 
        return view('admin.view-order')
                    ->with( 'active', 'dashboard' )
                    ->with( 'order', $order )
                    ->with( 'order_content', $order_content );
        
    }

    // dashboard stats
    public function domains_overview() {

        // if remove
        if( $removeId = \Input::get('remove') ) {
            
            // remove from db
            $d = Domain::findOrFail($removeId);
            $d->delete();

            return redirect('admin/domains')->with('msg', 'Successfully removed domain "'.$d->domain.'"');
        }

        $domains = Domain::orderBy('id', 'DESC')->get();

        return view('admin.domains-overview')
                    ->with('active', 'domains')
                    ->with('domains', $domains);

    }

    // add domain name listing
    public function add_domain() {
       return view('admin.add-domain');
    }

    // add domain to database
    public function add_domain_process( Request $r ) {
        
        // validate min fields
        $this->validate( $r, [ 'domain' => 'required', 
                               'pricing' => 'required',
                               'reg_date' => 'required|date_format:d-m-Y',
                               'exp_date' => 'required|date_format:d-m-Y'
                             ]);

        // save this domain
        $d = Domain::create( $r->except([ 'sb', '_token', '_wysihtml5_mode' ]));

        // set domain age
        $d->domain_age = \App\Domain::computeAge( $r->exp_date, $r->reg_date );
        $d->save();

        // redirect with message
        return redirect( '/admin/manage-domain/' . $d->id )->with('msg', 'Domain successfully created.');

    }

    // manage domain name listing
    public function manage_domain( \App\Domain $domain ) {
       return view('admin.manage-domain')->with('d', $domain);
    }

    // update domain details
    public function manage_domain_update( \App\Domain $domain, Request $r ) {
            
        // validate min fields
        $this->validate( $r, [ 'domain' => 'required', 'pricing' => 'required' ]);

        // update domain age
        $domain->domain_age = \App\Domain::computeAge( $r->exp_date, $r->reg_date );
        $domain->save();

        // update db
        $domain->update( $r->except([ 'sb', '_token', '_wysihtml5_mode' ]));

        // redirect with message 
        return redirect( 'admin/manage-domain/' . $domain->id )
                    ->with('msg', 'Domain details successfully saved.');

    }

    // pages controller
    public function pages() {
    	
    	// get existent pages
    	$pages = Page::all();

    	return view('admin.pages')->with('pages', $pages)
                                  ->with('active', 'pages');
    }

    // create a page
    public function create_page( Request $r ) {
        
        // validate form entries
        $this->validate( $r, ['page_title' => 'unique:pages|required']);

        // save page
        $page = new Page;
        $page->page_title = $r->page_title;
        $page->page_slug  = str_slug( $r->page_title );
        $page->page_content = $r->page_content;
        $page->save();

        return redirect()->route('admin-cms')->with('msg', 'Page successfully created');

    }

    // navigation controller
    public function navigation() {

    	// get existent menu items
    	$navi_order = Options::get_option('navi_order');

        if( $navi_order && !empty( $navi_order) ) {
    	   $navi = Navi::orderByRaw("FIELD(id, $navi_order)")->get();
        }else{
            $navi = Navi::all();
        }

    	return view('admin.navigation')->with('navi', $navi)
                                       ->with('active', 'navi');

    }

    // create navigation item
    public function navigation_save( Request $r ) {
    	
    	// save and redirect
    	Navi::create( $r->except('sb_navi', '_token') );

    	return redirect('admin/navigation')->with('msg', 'Item successfully added to navigation');

    }


    // appearance setup
    public function appearance() {
        return view('admin.appearance')->with('active', 'appearance');
    }

}
