<?php

namespace App;

use Illuminate\Database\Eloquent\Model;

class Domain extends Model
{
    // no timestamps
    public $timestamps = false;

    // fillable
    protected $fillable = [ 'domain', 'pricing', 'registrar', 'reg_date', 'exp_date',
    						'domain_age', 'description', 'short_description' ];

    // get available extensions
    public static function getAvailableExtensions() {
    	
    	// get all domains from DB
    	$all_domains = self::select('domain')->get();

    	// setup extensions array
    	$extensions = [];

    	// loop
    	foreach( $all_domains as $domain ) {
    		array_push( $extensions, pathinfo($domain->domain, PATHINFO_EXTENSION ));
    	}

    	return array_unique( $extensions, SORT_STRING );

    }

    // get character count
    public static function getCharacterCount( $domainName ) {
        
        return strlen( strtok( $domainName, '.' ) );

    }


    // compute age
    public static function computeAge( $reg_date, $exp_date ) {

        // parse dates
        $reg_date = \Carbon\Carbon::parse( $reg_date );
        $exp_date = \Carbon\Carbon::parse( $exp_date );

        // years difference
        $years_diff = $exp_date->diffInYears( $reg_date );

        // return age difference
        return $years_diff;

    }

}
