<?php
$this->assign('title', __('Mass Shrinker'));
$this->assign('description', '');
$this->assign('content_title', __('Mass Shrinker'));

?>

<div class="box box-primary">
    <div class="box-body">
        <p><?= __('Enter up to {0} URLs (one per line) to be shrunk and added to your account', get_option('mass_shrinker_limit', 20)) ?></p>

        <p><?= __('Note: The \'Mass Shrinker\' can be disabled to your account if abused. Only create links that you will actually use.') ?></p>


        <?php if (isset($results) && is_array($results)) : ?>
        <div class="well">
                <?php foreach ($results as $result) : ?>
            <p><?= $result['url'] ?></p>
                    <?php if ($result['short'] != 'error'): ?>
            <p class="text-success" style="font-weight: bold;"><?= $this->Url->build('/' . $result['short'], 'true'); ?></p>
                    <?php else : ?>
            <p class="text-danger" style="font-weight: bold;"><?= __('It is not a valid URL.') ?></p>
                    <?php endif; ?>
                <?php endforeach; ?>
        </div>
        <a href="<?= $this->Url->build(['action' => 'mass-shrinker']); ?>" class="btn btn-info btn-s-xs"><i class="fa fa-chevron-circle-left"></i> <?= __('Shorten More Links') ?></a>
        <?php else : ?>
            <?= $this->Form->create($link); ?>

            <?=
            $this->Form->input('urls', [
                'label' => false,
                'class' => 'form-control',
                'type' => 'textarea'
            ]);

            ?>

            <?php
            $ads_options = [];

            if (get_option('enable_interstitial', 'yes') == 'yes') {
                $ads_options['1'] = __('Interstitial Advertisement');
            }

            if (get_option('enable_banner', 'yes') == 'yes') {
                $ads_options['2'] = __('Ad Banner');
            }

            if (get_option('enable_noadvert', 'yes') == 'yes') {
                $ads_options['0'] = __('No Advert');
            }
            
            echo $this->Form->input('ad_type', [
                'label' => __('Advertising Type'),
                'options' => $ads_options,
                'default' => get_option('mass_shrinker_default_advert', 1),
                //'empty'   => __( 'Choose' ),
                'class' => 'form-control'
            ]);

            ?>

            <?= $this->Form->button(__('Shorten'), ['class' => 'btn btn-primary']); ?>

            <?= $this->Form->end(); ?>
        <?php endif; ?>




    </div>
</div>
