<?php
$this->assign('title', get_option('site_name'));
$this->assign('description', get_option('description'));
$this->assign('content_title', get_option('site_name'));
$this->assign('og_title', $link->title);
$this->assign('og_description', $link->description);
$this->assign('og_image', $link->image);

?>

<script type="text/javascript">
    function reCaptchaVerify( response ) {
        if ( response === document.querySelector( '.g-recaptcha-response' ).value ) {
            document.getElementById('link-view').submit();
        }
    }
    
    var onloadCallback = function() {
        grecaptcha.render('g-recaptcha', {
            'sitekey' : '<?= get_option('reCAPTCHA_site_key'); ?>',
            'callback': reCaptchaVerify
        });
    };
</script>


<div class="row">
    <div class="col-md-10 col-md-offset-1">
        <div class="box box-success">
            <div class="box-body text-center">
                <?= $this->Form->create(null, ['id' => 'link-view']); ?>

                <?php if( !empty(get_option('ad_captcha')) ) : ?>
                    <div class="banner banner-captcha">
                        <div class="banner-inner">
                            <?= get_option('ad_captcha'); ?>
                        </div>
                    </div>
                <?php endif; ?>

                <p style="font-size: 17px"><?= __('Please check the captcha box to proceed to the destination page.') ?></p>

                <?= $this->Form->hidden('ref', ['value' => strtolower(env('HTTP_REFERER'))]); ?>

                <div class="form-group text-center">
                    <div id="g-recaptcha" style="display: inline-block;"></div>
                </div>
                <script src="https://www.google.com/recaptcha/api.js?onload=onloadCallback&render=explicit" async defer></script>


                <?= $this->Form->button(__('Submit'), [ 'class' => 'hidden']); ?>

                <?= $this->Form->end() ?>

                <hr>

                <div class="text-left">

                    <h3><?= __('What is {0}?', h(get_option('site_name'))) ?></h3>
                    <p><?= __('{0} is a completely free tool where you can create short links, which apart from being free, you get paid! So, now you can make money from home, when managing and protecting your links. Register now!', h(get_option('site_name'))) ?></p>

                    <h3><?= __('Shorten URLs and earn money') ?></h3>
                    <p><?= __("Signup for an account in just 2 minutes. Once you've completed your registration just start creating short URLs and sharing the links with your family and friends.") ?></p>

                </div>

            </div>
            <!-- /.box-body -->
        </div>
    </div>
</div>

<?php $this->start('scriptBottom'); ?>

<script>
    
</script>

<?php $this->end(); ?>
