<?php

namespace App\Controller;

use App\Controller\AppController;
use Cake\Event\Event;
use Cake\Network\Exception\NotFoundException;

class PagesController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        $this->Auth->allow(['home', 'view']);
    }

    public function home()
    {
        
    }

    public function view($slug = null)
    {
        if (!$slug) {
            throw new NotFoundException(__('Invalid Page.'));
        }

        $page = $this->Pages->find()->where(['slug' => $slug, 'published' => 1])->first();

        if (!$page) {
            throw new NotFoundException(__('Invalid Page.'));
        }

        $page->content = str_replace('[advertising_rates]', $this->advertisingRates(), $page->content);
        $page->content = str_replace('[payout_rates]', $this->payoutRates(), $page->content);

        $this->set('page', $page);
    }

    protected function advertisingRates()
    {
        ob_start();

        ?>
        <div>

            <!-- Nav tabs -->
            <ul class="nav nav-tabs" role="tablist">
                <?php if (get_option('enable_interstitial', 'yes') == 'yes') : ?>
                    <li role="presentation"  class="active"><a href="#interstitial" aria-controls="interstitial" role="tab" data-toggle="tab"><?= __('Interstitial Advertising') ?></a></li>
                <?php endif; ?>
                <?php if (get_option('enable_banner', 'yes') == 'yes') : ?>
                    <li role="presentation"><a href="#banner-ads" aria-controls="banner-ads" role="tab" data-toggle="tab"><?= __('Banner Advertising') ?></a></li>
                <?php endif; ?>
            </ul>

            <!-- Tab panes -->
            <div class="tab-content">
                <?php if (get_option('enable_interstitial', 'yes') == 'yes') : ?>
                <div role="tabpanel" class="tab-pane active" id="interstitial">
                    <table class="table table-hover table-striped">
                        <thead>
                            <tr>
                                <th><?= __('Package Description / Country') ?></th>
                                <th><?= __('Price 1,000') ?></th>
                            </tr>
                        </thead>
                        <?php
                        $interstitial_prices = get_option('interstitial_price');
                        $countries = get_countries(true);
                        $advertiser_prices = [];
                        foreach ($interstitial_prices as $key => $value) {
                            if (!empty($value['advertiser'])) {
                                $advertiser_prices[$key] = $value['advertiser'];
                            }
                        }
                        //arsort($advertiser_prices);

                        ?>
                        <?php foreach ($advertiser_prices as $key => $value) : ?>
                            <tr>
                                <td><?= $countries[$key] ?></td>
                                <td><?= display_price_currency($value); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
                <?php if (get_option('enable_banner', 'yes') == 'yes') : ?>
                <div role="tabpanel" class="tab-pane" id="banner-ads">
                    <table class="table table-hover table-striped">
                        <thead>
                            <tr>
                                <th><?= __('Package Description / Country') ?></th>
                                <th><?= __('Price 1,000') ?></th>
                            </tr>
                        </thead>
                        <?php
                        $banner_price = get_option('banner_price');
                        $countries = get_countries(true);
                        $banner_prices = [];
                        foreach ($banner_price as $key => $value) {
                            if (!empty($value['advertiser'])) {
                                $banner_prices[$key] = $value['advertiser'];
                            }
                        }
                        //arsort($advertiser_prices);

                        ?>
                        <?php foreach ($banner_prices as $key => $value) : ?>
                            <tr>
                                <td><?= $countries[$key] ?></td>
                                <td><?= display_price_currency($value); ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>

        </div>

        <?php
        $advertisingRates = ob_get_contents();
        ob_end_clean();
        return $advertisingRates;
    }

    protected function payoutRates()
    {
        ob_start();

        ?>

        <!-- Nav tabs -->
        <ul class="nav nav-tabs" role="tablist">
            <?php if (get_option('enable_interstitial', 'yes') == 'yes') : ?>
                <li role="presentation"  class="active"><a href="#interstitial" aria-controls="interstitial" role="tab" data-toggle="tab"><?= __('Interstitial Advertising') ?></a></li>
            <?php endif; ?>
            <?php if (get_option('enable_banner', 'yes') == 'yes') : ?>
                <li role="presentation"><a href="#banner-ads" aria-controls="banner-ads" role="tab" data-toggle="tab"><?= __('Banner Advertising') ?></a></li>
            <?php endif; ?>
        </ul>

        <!-- Tab panes -->
        <div class="tab-content">
            <?php if (get_option('enable_interstitial', 'yes') == 'yes') : ?>
            <div role="tabpanel" class="tab-pane active" id="interstitial">
                <table class="table table-hover table-striped">
                    <thead>
                        <tr>
                            <th><?= __('Package Description / Country') ?></th>
                            <th><?= __('Price 1,000') ?></th>
                        </tr>
                    </thead>
                    <?php
                    $interstitial_prices = get_option('interstitial_price');
                    $countries = get_countries(true);
                    $publisher_prices = [];
                    foreach ($interstitial_prices as $key => $value) {
                        if (!empty($value['advertiser'])) {
                            $publisher_prices[$key] = $value['publisher'];
                        }
                    }
                    arsort($publisher_prices);
                    ?>
                    <?php foreach ($publisher_prices as $key => $value) : ?>
                        <tr>
                            <td><?= $countries[$key] ?></td>
                            <td><?= display_price_currency($value); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </table>
            </div>
            <?php endif; ?>
            <?php if (get_option('enable_banner', 'yes') == 'yes') : ?>
            <div role="tabpanel" class="tab-pane" id="banner-ads">
                <table class="table table-hover table-striped">
                    <thead>
                        <tr>
                            <th><?= __('Package Description / Country') ?></th>
                            <th><?= __('Price 1,000') ?></th>
                        </tr>
                    </thead>
                    <?php
                    $banner_prices = get_option('banner_price');
                    $countries = get_countries(true);
                    $publisher_prices = [];
                    foreach ($banner_prices as $key => $value) {
                        if (!empty($value['advertiser'])) {
                            $publisher_prices[$key] = $value['publisher'];
                        }
                    }
                    arsort($publisher_prices);
                    ?>
                    <?php foreach ($publisher_prices as $key => $value) : ?>
                        <tr>
                            <td><?= $countries[$key] ?></td>
                            <td><?= display_price_currency($value); ?></td>
                        </tr>
                    <?php endforeach; ?>
                </table>
            </div>
            <?php endif; ?>
        </div>

        <?php
        $payoutRates = ob_get_contents();
        ob_end_clean();
        return $payoutRates;
    }
}
