<?php

namespace App\Controller\Member;

use App\Controller\Member\AppMemberController;

class WithdrawsController extends AppMemberController
{

    public function index()
    {
        $query = $this->Withdraws->find()
            ->where(['user_id' => $this->Auth->user('id')]);
        $withdraws = $this->paginate($query);

        $this->set('withdraws', $withdraws);

        $tolal_withdrawn = $this->Withdraws->find()
            ->where(['user_id' => $this->Auth->user('id')])
            ->where(['status' => 'Complete'])
            ->sumOf('amount');

        $this->set('tolal_withdrawn', $tolal_withdrawn);

        $pending_withdrawn = $this->Withdraws->find()
            ->where(['user_id' => $this->Auth->user('id')])
            ->where(['status' => 'Pending'])
            ->sumOf('amount');

        $this->set('pending_withdrawn', $pending_withdrawn);

        $user = $this->Withdraws->Users->get($this->Auth->user('id'));
        $this->set('user', $user);
    }

    public function request()
    {

        $this->request->allowMethod(['post', 'put']);

        $user = $this->Withdraws->Users->get($this->Auth->user('id'));

        $withdraw = $this->Withdraws->newEntity();
        $data = [];

        $withdraw->user_id = $this->Auth->user('id');
        $withdraw->status = 'Pending';
        $withdraw->publisher_earnings = $user->publisher_earnings;
        $withdraw->referral_earnings = $user->referral_earnings;
        $data['amount'] = $user->publisher_earnings + $user->referral_earnings;

        $minimum_withdrawal_amount = get_option('minimum_withdrawal_amount', 5);
        if ($data['amount'] < $minimum_withdrawal_amount) {
            $this->Flash->error(__('Withdraw amount should be equal or greater than {0}.',
                display_price_currency($minimum_withdrawal_amount)));
            return $this->redirect(['action' => 'index']);
        }

        $withdraw = $this->Withdraws->patchEntity($withdraw, $data);
        if ($this->Withdraws->save($withdraw)) {
            // Rest publisher balance
            $user->publisher_earnings = 0;
            $user->referral_earnings = 0;
            $this->Withdraws->Users->save($user);

            $this->Flash->success(__('Your withdraw has been request and under review.'));
        } else {
            $this->Flash->error(__('Unable to request the withdraw.'));
        }
        return $this->redirect(['action' => 'index']);
    }
}
