<?php

namespace App\Controller\Admin;

use App\Controller\Admin\AppAdminController;
use Migrations\Migrations;
use Cake\ORM\TableRegistry;

class UpgradeController extends AppAdminController
{
    public function index()
    {
        if ($this->request->is('post')) {
            set_time_limit(10 * MINUTE);

            try {
                $migrations = new Migrations();
                $result = $migrations->migrate();
            } catch (\Exception $ex) {
                $result = __('Can not able to run upgrade. Error: ') . $ex->getMessage();
            }

            if ($result !== true) {
                $this->Flash->error($result);
            } else {
                $Options = TableRegistry::get('Options');
                $app_version = $Options->findByName('app_version')->first();
                $app_version->value = APP_VERSION;
                $Options->save($app_version);
                
                emptyTmp();
                
                $this->Flash->success(__('Database upgraded successfully.'));
                return $this->redirect(['controller' => 'Users', 'action' => 'dashboard']);
            }
        }
    }
    
}
