<?php

use Cake\Core\Configure;

define("APP_VERSION", "2.6.0");

// Cache
\Cake\Cache\Cache::config('long', [
    'className' => 'Cake\Cache\Engine\FileEngine',
    'duration' => '+1 month',
    'serialize' => true,
    'path' => CACHE . 'models' . DS,
    'prefix' => 'ms_'
]);

/**
 * Set server timezone to UTC. You can change it to another timezone of your
 * choice but using UTC makes time calculations / conversions easier.
 */
date_default_timezone_set('UTC');

/**
 * Configure the mbstring extension to use the correct encoding.
 */
mb_internal_encoding(Configure::read('App.encoding'));

/**
 * Set the default locale. This controls how dates, number and currency is
 * formatted and sets the default language to use for translations.
 */
ini_set('intl.default_locale', get_option('language', 'en_US'));
