<?php
$this->assign('title', __('Campaign #{0}', $campaign->id));
$this->assign('description', '');
$this->assign('content_title', __('Campaign #{0}', $campaign->id));

?>


<div class="box box-primary checkout-form">
    <div class="box-header with-border">
        <i class="fa fa-credit-card"></i> <h3 class="box-title"><?= __('Payment Method') ?></h3>
    </div>
    <div class="box-body">
        
        <?=
        $this->Form->create(null, [
            'url' => ['controller' => 'Campaigns', 'action' => 'checkout'],
            'id' => 'checkout-form'
        ]);

        $this->Form->templates([
            'radioWrapper' => '<div class="radio">{{label}}</div>'
        ]);
        ?>
        
        <?= $this->Form->hidden('id', ['value' => $campaign->id]); ?>
        
        <?= $this->Form->input('payment_method', [
            'type' => 'radio',
            'escape' => false,
            'options' => [
                'paypal' => '<img src="https://www.paypalobjects.com/webstatic/en_US/i/btn/png/silver-rect-paypal-34px.png" alt="PayPal">',
                'payza' => '<img src="https://www.payza.com/images/payza-buy-now.png" alt="Payza">'
            ],
            'required' => 'required',
            'label' => false
        ]);
        ?>
        
        <?= $this->Form->button(__('Pay Campaign'), ['class' => 'btn btn-success btn-lg']); ?>
        
        <?= $this->Form->end(); ?>
        
    </div><!-- /.box-body -->
</div>

<?php $this->start('scriptBottom'); ?>
<script>
    /**
     * Report invalid link
     */
    $( "#checkout-form" ).one( "submit", function ( e ) {
        e.preventDefault();
        var checkoutForm = $( this );

        var submitButton = checkoutForm.find( 'button' );

        $.ajax( {
            dataType: 'json', // The type of data that you're expecting back from the server.
            type: 'POST', // he HTTP method to use for the request
            url: checkoutForm.attr( 'action' ),
            data: checkoutForm.serialize(), // Data to be sent to the server.
            beforeSend: function ( xhr ) {
                submitButton.attr( "disabled", "disabled" );
                $( '<div class="overlay"><i class="fa fa-refresh fa-spin"></i></div>' ).insertAfter( $( '.checkout-form .box-body' ) );
            },
            success: function ( result, status, xhr ) {
                //console.log( result );
                if ( result.form ) {
                    //console.log( result.message );
                    $( result.form ).insertAfter( checkoutForm );
                    $('#checkout-redirect-form').submit();
                } else {
                    alert( result.message );
                }
            },
            error: function ( xhr, status, error ) {
                alert( "An error occured: " + xhr.status + " " + xhr.statusText );
            },
            complete: function ( xhr, status ) {
                
            }
        } );
    } );
</script>
<?php $this->end(); ?>
