<?php
$this->assign('title', $link->title);
$this->assign('description', $link->description);
$this->assign('og_image', $link->image);
$this->assign('content_title', get_option('site_name'));

?>

<?php
//pr( 'Campaign URL: ' . $campaign_item->campaign->website_url );
//pr( 'Link URL: ' . $link->url );

?>
<div class="myTestAd" style="height: 5px; width: 5px; position: absolute;"></div>
<iframe id="frame" src="<?= $campaign_item->campaign->website_url ?>" style="width: 100%; border: none;"></iframe>


<?=
$this->Form->create(null, [
    'url' => [ 'controller' => 'Links', 'action' => 'go', 'prefix' => false],
    'id' => 'go-link',
    'class' => 'hidden'
]);

?>

<?= $this->Form->hidden('alias', ['value' => $link->alias]); ?>
<?= $this->Form->hidden('ci', ['value' => $campaign_item->campaign_id]); ?>
<?= $this->Form->hidden('cui', ['value' => $campaign_item->campaign->user_id]); ?>
<?= $this->Form->hidden('cii', ['value' => $campaign_item->id]); ?>
<?= $this->Form->hidden('ref', ['value' => strtolower(env('HTTP_REFERER'))]); ?>

<?=
$this->Form->button(__('Please Wait 10s'), [
    'id' => 'go-submit',
    'class' => 'btn btn-default',
    'onclick' => 'javascript: return false;'
]);

?>
<?= $this->Form->end(); ?>

<?php $this->start('scriptBottom'); ?>

<script>
    
    function checkAdblockUser() {
        var myTestAd = $( '.myTestAd' );
        <?php
        $time = \Cake\I18n\Time::now()->modify('+1 day')->toCookieString();

        ?>

        document.cookie = "adblockUser=0; expires=<?= $time ?>";

        if ( myTestAd.filter( ':visible' ).length === 0 ||
            myTestAd.filter( ':hidden' ).length > 0 ||
            myTestAd.height() === 0 ) {
            //console.log( 'adblockUser' );
            document.cookie = "adblockUser=1; expires=<?= $time ?>";
        }
    }

    $( document ).ready( function () {
        window.setTimeout( function () {
            checkAdblockUser();
        }, 1500 );
    } );

// http://stackoverflow.com/a/5766416
    $( function () {
        var counter = $( 'a.skip-ad' );

        ( function () {
            var time = <?= get_option('counter_value', 5) * 1000 ?>,
                delta = 1000,
                tid;

            tid = setInterval( function () {
                if ( window.blurred ) {
                    return;
                }
                time -= delta;
                counter.text( '<?= __('Please Wait') ?> ' + ( time / 1000 ) + 's' );
                if ( time <= 0 ) {
                    counter.text( '<?= __('Skip Ad') ?>' );
                    ;
                    clearInterval( tid );
                    $( '#go-link' ).addClass( 'go-link' );
                    $( '#go-link.go-link' ).submit();
                }
            }, delta );
        } )();

        document.onblur = function () {
            window.blurred = true;
        };
        document.onfocus = function () {
            window.blurred = false;
        };
    } );


    /**
     * Report invalid link
     */
    $( "#go-link" ).one( "submit", function ( e ) {
        e.preventDefault();
        var goForm = $( this );

        if ( !goForm.hasClass( 'go-link' ) ) {
            return;
        }

        var submitButton = goForm.find( 'button' );

        $.ajax( {
            dataType: 'json', // The type of data that you're expecting back from the server.
            type: 'POST', // he HTTP method to use for the request
            url: goForm.attr( 'action' ),
            data: goForm.serialize(), // Data to be sent to the server.
            beforeSend: function ( xhr ) {
                submitButton.attr( "disabled", "disabled" );
                //goForm.replaceWith( '<a href="#" class="btn btn-default skip-ad" onclick="javascript: return false;"><?= __('Skip Ad') ?></a>' );
            },
            success: function ( result, status, xhr ) {
                //console.log( result );
                if ( result.url ) {
                    //console.log( result.message + ' - ' + result.url );
                    //window.location.href = result.url;
                    $( 'a.skip-ad' ).attr( 'href', result.url ).removeAttr( 'onclick' );
                    //submitButton.text( 'Redirecting...' );
                    //goForm.replaceWith( '<button class="btn btn-default" onclick="javascript: return false;">Redirecting...</button>' );
                } else {
                    alert( result.message );
                }
            },
            error: function ( xhr, status, error ) {
                alert( "An error occured: " + xhr.status + " " + xhr.statusText );
            },
            complete: function ( xhr, status ) {

            }
        } );
    } );


</script>

<?php $this->end(); ?>
