<?php $user = $this->request->session()->read('Auth.User'); ?>
<!DOCTYPE html>
<html>
    <head>
        <?= $this->Html->charset(); ?>
        <title><?= h($this->fetch('title')); ?></title>
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="<?= h($this->fetch('description')); ?>">
        <meta property="og:image" content="<?= h($this->fetch('og_image')); ?>" />
        <?php
        echo $this->Html->meta('icon');

        //echo $this->Html->css( 'base.css' );
        //echo $this->Html->css( 'cake.css' );
        echo $this->Html->css('//cdn.rawgit.com/twbs/bootstrap/v3.3.6/dist/css/bootstrap.min.css');
        //echo $this->Html->css( '//cdn.rawgit.com/twbs/bootstrap/v3.3.6/dist/css/bootstrap-theme.min.css' );
        if (get_option('language_direction') == 'rtl') {
            echo $this->Html->css('//cdn.rawgit.com/morteza/bootstrap-rtl/v3.4.0/dist/css/bootstrap-rtl.min.css');
            //echo $this->Html->css( '//cdn.rawgit.com/morteza/bootstrap-rtl/v3.4.0/dist/css/bootstrap-flipped.min.css' );
        }
        echo $this->Html->css('//cdn.rawgit.com/FortAwesome/Font-Awesome/v4.6.3/css/font-awesome.min.css');
        echo $this->Html->css('//cdn.rawgit.com/almasaeed2010/AdminLTE/v2.3.3/dist/css/AdminLTE.min.css');
        echo $this->Html->css('//cdn.rawgit.com/almasaeed2010/AdminLTE/v2.3.3/dist/css/skins/skin-blue.min.css');
        echo $this->Html->css('app.css?ver=' . APP_VERSION);
        if (get_option('language_direction') == 'rtl') {
            echo $this->Html->css('app-rtl');
        }
        echo $this->fetch('meta');
        echo $this->fetch('css');
        echo $this->fetch('script');

        ?>

        <?= get_option('head_code'); ?>

        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
    </head>
    <body class="<?= (get_option('language_direction') == 'rtl' ? "rtl" : "") ?> layout-top-nav skin-blue">
        <?= get_option('after_body_tag_code'); ?>

        <div class="wrapper">

            <header class="main-header">
                <!-- Fixed navbar -->
                <nav class="navbar">
                    <div class="container">
                        <div class="navbar-header">
                            <?php
                            $logo = get_logo();
                            $class= '';
                            if( $logo['type'] == 'image' ) {
                                $class = 'logo-image';
                            }
                            ?>
                            <a class="navbar-brand <?= $class ?>" href="<?= $this->Url->build('/'); ?>"><?= $logo['content'] ?></a>
                            <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#navbar-collapse">
                                <i class="fa fa-bars"></i>
                            </button>
                        </div>

                        <!-- Collect the nav links, forms, and other content for toggling -->
                        <div class="collapse navbar-collapse" id="navbar-collapse">
                            <ul class="nav navbar-nav navbar-right">
                                <?php if (get_option('enable_advertising', 'yes') == 'yes') : ?>
                                    <li>
                                        <a href="<?= $this->Url->build('/advertising-rates'); ?>"><?= __('Advertising') ?></a>
                                    </li>
                                <?php endif; ?>
                                <li>
                                    <a href="<?= $this->Url->build('/payout-rates'); ?>"><?= __('Payout Rates') ?></a>
                                </li>
                            </ul>
                        </div>
                        <!-- /.navbar-collapse -->
                    </div>
                </nav>
            </header>

            <div class="content-wrapper">
                <div class="container banner-container">

                    <!-- Main content -->
                    <section class="content">

                        <?= $this->Flash->render() ?>
                        <?= $this->fetch('content') ?>

                    </section>
                    <!-- /.content -->
                </div>
                <!-- /.container -->
            </div>
            <!-- /.content-wrapper -->

            <footer class="main-footer">
                <div class="container">
                    <div class="pull-right hidden-xs">
                        <ul class="list-inline">
                            <li><a href="<?= $this->Url->build('/pages/privacy'); ?>"><?= __('Privacy Policy') ?></a></li>
                            <li><a href="<?= $this->Url->build('/pages/terms'); ?>"><?= __('Terms of Use') ?></a></li>
                        </ul>
                    </div>
                    <?= __('Copyright &copy;') ?> <?= h(get_option('site_name')) ?> <?= date("Y") ?>
                </div>
                <!-- /.container -->
            </footer>

        </div>
        <?= $this->Html->script('//ajax.googleapis.com/ajax/libs/jquery/1.12.4/jquery.min.js'); ?>
        <?= $this->Html->script('//cdn.rawgit.com/twbs/bootstrap/v3.3.6/dist/js/bootstrap.min.js'); ?>
        <?= $this->Html->script('//cdn.rawgit.com/zenorocha/clipboard.js/v1.5.12/dist/clipboard.min.js'); ?>
        <script type='text/javascript'>
            /* <![CDATA[ */
            var app_vars = [];
            app_vars['base_url'] = '<?php echo $this->Url->build('/', true); ?>';
            app_vars['language'] = '<?= get_option('language', 'en_US'); ?>';
            /* ]]> */
        </script>
        <?= $this->Html->script('app.js?ver=' . APP_VERSION); ?>
        <?= $this->Html->script('//cdn.rawgit.com/almasaeed2010/AdminLTE/v2.3.3/dist/js/app.js'); ?>
        <?= $this->fetch('scriptBottom') ?>
        <?= get_option('footer_code'); ?>
    </body>
</html>
