<?php
$this->assign('title', __('Settings'));
$this->assign('description', '');
$this->assign('content_title', __('Settings'));

?>

<div class="box box-primary">
    <div class="box-body">

        <?= $this->Form->create($options, ['id' => 'form-settings']); ?>

        <!-- Nav tabs -->
        <ul class="nav nav-tabs" role="tablist">
            <li role="presentation"><a href="#general" aria-controls="general" role="tab" data-toggle="tab"><?= __('General') ?></a></li>
            <li role="presentation"><a href="#links" aria-controls="links" role="tab" data-toggle="tab"><?= __('Links') ?></a></li>
            <li role="presentation"><a href="#ads" aria-controls="ads" role="tab" data-toggle="tab"><?= __('Admin Ads') ?></a></li>
            <li role="presentation"><a href="#captcha" aria-controls="captcha" role="tab" data-toggle="tab"><?= __('Captcha') ?></a></li>
            <li role="presentation"><a href="#payment" aria-controls="payment" role="tab" data-toggle="tab"><?= __('Payment') ?></a></li>
            <li role="presentation"><a href="#social" aria-controls="Social Media" role="tab" data-toggle="tab"><?= __('Social Media') ?></a></li>
            <li role="presentation"><a href="#email" aria-controls="Email" role="tab" data-toggle="tab"><?= __('Email') ?></a></li>
        </ul>

        <!-- Tab panes -->
        <div class="tab-content">
            <div role="tabpanel" id="general" class="tab-pane fade in active">
                <p></p>
                <div class="row">
                    <div class="col-sm-2"><?= __('Site Name') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['site_name']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'text',
                            'value' => $settings['site_name']['value']
                        ]);

                        ?>
                        <span class="help-block"><?= __('This is your site name as well as the site meta title.') ?></span>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Site Description') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['description']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['description']['value']
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Admin Email') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['admin_email']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'email',
                            'value' => $settings['admin_email']['value']
                        ]);

                        ?>
                        <span class="help-block"><?= __('This email used for the contact form and all outgoing emails') ?></span>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Language') ?></div>
                    <div class="col-sm-10">
                        <?php
                        $locale = new \Cake\Filesystem\Folder(APP . 'Locale');
                        $languages = $locale->subdirectories(null, false);

                        ?>
                        <?=
                        $this->Form->input('Options.' . $settings['language']['id'] . '.value', [
                            'label' => false,
                            'options' => array_combine($languages, $languages),
                            'value' => $settings['language']['value'],
                            //'empty'   => __( 'Choose' ),
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row hidden">
                    <div class="col-sm-2"><?= __('Language Direction') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['language_direction']['id'] . '.value', [
                            'label' => false,
                            'options' => [
                                'ltr' => __('LTR'),
                                'rtl' => __('RTL')
                            ],
                            'value' => $settings['language_direction']['value'],
                            //'empty'   => __( 'Choose' ),
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Time Zone') ?></div>
                    <div class="col-sm-10">
                        <?php
                        $DateTimeZone = \DateTimeZone::listIdentifiers(DateTimeZone::ALL);
                        echo $this->Form->input('Options.' . $settings['timezone']['id'] . '.value', [
                            'label' => false,
                            'options' => array_combine($DateTimeZone, $DateTimeZone),
                            'value' => $settings['timezone']['value'],
                            //'empty'   => __( 'Choose' ),
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Logo URL') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['logo_url']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'text',
                            'value' => $settings['logo_url']['value']
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Logo URL - Alternative') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['logo_url_alt']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'text',
                            'value' => $settings['logo_url_alt']['value']
                        ]);

                        ?>
                        <span class="help-block"><?= __('Alternative logo used on the login page') ?></span>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Enable Account Activation by Email') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['account_activate_email']['id'] . '.value', [
                            'label' => false,
                            'options' => [
                                'yes' => __('Yes'),
                                'no' => __('No')
                            ],
                            'value' => $settings['account_activate_email']['value'],
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Enable Advertising') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['enable_advertising']['id'] . '.value', [
                            'label' => false,
                            'options' => [
                                'yes' => __('Yes'),
                                'no' => __('No')
                            ],
                            'value' => $settings['enable_advertising']['value'],
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Referral Percentage') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['referral_percentage']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'number',
                            'value' => $settings['referral_percentage']['value']
                        ]);

                        ?>
                        <span class="help-block"><?= __('Enter the referral earning percentage. Ex. 20') ?></span>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Referral Banners Code') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['referral_banners_code']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['referral_banners_code']['value']
                        ]);

                        ?>
                        <span class="help-block"><?= __("Here you can add your referral banners html code. You can use [referral_link] as a placeholder for member referral link.") ?></span>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Front Head Code') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['head_code']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['head_code']['value']
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Auth Head Code') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['auth_head_code']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['auth_head_code']['value']
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Member Head Code') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['member_head_code']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['member_head_code']['value']
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Admin Head Code') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['admin_head_code']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['admin_head_code']['value']
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Footer Code') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['footer_code']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['footer_code']['value']
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('After Body Tag Code') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['after_body_tag_code']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['after_body_tag_code']['value']
                        ]);

                        ?>
                    </div>
                </div>


            </div>
            <div role="tabpanel" id="links" class="tab-pane fade in active">
                <p></p>
                
                <legend><?= __("Advertisement Types") ?></legend>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Enable Interstitial Advertisement') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['enable_interstitial']['id'] . '.value', [
                            'label' => false,
                            'options' => [
                                'yes' => __('Yes'),
                                'no' => __('No')
                            ],
                            'value' => $settings['enable_interstitial']['value'],
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Enable Banner Advertisement') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['enable_banner']['id'] . '.value', [
                            'label' => false,
                            'options' => [
                                'yes' => __('Yes'),
                                'no' => __('No')
                            ],
                            'value' => $settings['enable_banner']['value'],
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Enable No Advert') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['enable_noadvert']['id'] . '.value', [
                            'label' => false,
                            'options' => [
                                'yes' => __('Yes'),
                                'no' => __('No')
                            ],
                            'value' => $settings['enable_noadvert']['value'],
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>
                
                <legend><?= __("Default Advertisement Types") ?></legend>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Anonymous Default Advert') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['anonymous_default_advert']['id'] . '.value', [
                            'label' => false,
                            'options' => [
                                '1' => __('Interstitial Advertisement'),
                                '2' => __('Ad Banner'),
                                '0' => __('No Advert')
                            ],
                            'value' => $settings['anonymous_default_advert']['value'],
                            //'empty'   => __( 'Choose' ),
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Member Default Advert') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['member_default_advert']['id'] . '.value', [
                            'label' => false,
                            'options' => [
                                '1' => __('Interstitial Advertisement'),
                                '2' => __('Ad Banner'),
                                '0' => __('No Advert')
                            ],
                            'value' => $settings['member_default_advert']['value'],
                            //'empty'   => __( 'Choose' ),
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>
                
                <hr>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Counter Value') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['counter_value']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'number',
                            'value' => $settings['counter_value']['value']
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Mass Shrinker Limit') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['mass_shrinker_limit']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'number',
                            'value' => $settings['mass_shrinker_limit']['value']
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Disallowed Domains') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['disallowed_domains']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['disallowed_domains']['value']
                        ]);

                        ?>
                        <span class="help-block"><?= __('Disallow links with certain domains from being shortened. Separate by comma, no spaces.') ?></span>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Alias Min. Length') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['alias_min_length']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'text',
                            'value' => $settings['alias_min_length']['value']
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Alias Max. Length') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['alias_max_length']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'text',
                            'value' => $settings['alias_max_length']['value']
                        ]);

                        ?>
                    </div>
                </div>


            </div>
            
            <div role="tabpanel" id="ads" class="tab-pane fade in">
                <p></p>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Member Area Ad') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['ad_member']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['ad_member']['value']
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Captcha Ad') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['ad_captcha']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['ad_captcha']['value']
                        ]);

                        ?>
                    </div>
                </div>
                
                <legend><?= __('Interstitial Ads') ?></legend>
                
                <p><?= __('This ad will be displayed between logo and counter.') ?></p>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Interstitial Page Ad Code') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['interstitial_ads']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['interstitial_ads']['value']
                        ]);

                        ?>
                    </div>
                </div>
                
                <legend><?= __('Banner Ads') ?></legend>
                
                <p><?= __('Let say you have a campaign for 728×90 space then the other places 468×60 and 336×280 will be populated with the below banner ads.') ?></p>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Banner 728x90') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['banner_728x90']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['banner_728x90']['value']
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Banner 468x60') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['banner_468x60']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['banner_468x60']['value']
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Banner 336x280') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['banner_336x280']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['banner_336x280']['value']
                        ]);

                        ?>
                    </div>
                </div>
                
            </div>
            
            <div role="tabpanel" id="captcha" class="tab-pane fade in">
                <p></p>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Enable Captcha') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['enable_captcha']['id'] . '.value', [
                            'label' => false,
                            'options' => [
                                'yes' => __('Yes'),
                                'no' => __('No')
                            ],
                            'value' => $settings['enable_captcha']['value'],
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('reCAPTCHA Site key') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['reCAPTCHA_site_key']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'text',
                            'value' => $settings['reCAPTCHA_site_key']['value']
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('reCAPTCHA Secret key') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['reCAPTCHA_secret_key']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'text',
                            'value' => $settings['reCAPTCHA_secret_key']['value']
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Enable on Short Links Page') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['enable_captcha_shortlink']['id'] . '.value', [
                            'label' => false,
                            'options' => [
                                'yes' => __('Yes'),
                                'no' => __('No')
                            ],
                            'value' => $settings['enable_captcha_shortlink']['value'],
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Enable on Signup Form') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['enable_captcha_signup']['id'] . '.value', [
                            'label' => false,
                            'options' => [
                                'yes' => __('Yes'),
                                'no' => __('No')
                            ],
                            'value' => $settings['enable_captcha_signup']['value'],
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Enable on Forgot Password Form') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['enable_captcha_forgot_password']['id'] . '.value', [
                            'label' => false,
                            'options' => [
                                'yes' => __('Yes'),
                                'no' => __('No')
                            ],
                            'value' => $settings['enable_captcha_forgot_password']['value'],
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>

            </div>
            
            <div role="tabpanel" id="payment" class="tab-pane fade in">
                <p></p>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Currency Code') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['currency_code']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'text',
                            'value' => $settings['currency_code']['value']
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Currency Symbol') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['currency_symbol']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'text',
                            'value' => $settings['currency_symbol']['value']
                        ]);

                        ?>
                    </div>
                </div>

                <legend><?= __('PayPal Settings') ?></legend>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Enable PayPal') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['paypal_enable']['id'] . '.value', [
                            'label' => false,
                            'options' => [
                                'no' => __('No'),
                                'yes' => __('Yes')
                            ],
                            'value' => $settings['paypal_enable']['value'],
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Payment Business Email') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['paypal_email']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'email',
                            'value' => $settings['paypal_email']['value']
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Enable PayPal Sandbox') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['paypal_sandbox']['id'] . '.value', [
                            'label' => false,
                            'options' => [
                                'no' => __('No'),
                                'yes' => __('Yes')
                            ],
                            'value' => $settings['paypal_sandbox']['value'],
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>

                <legend><?= __('Payza Settings') ?></legend>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Enable Payza') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['payza_enable']['id'] . '.value', [
                            'label' => false,
                            'options' => [
                                'no' => __('No'),
                                'yes' => __('Yes')
                            ],
                            'value' => $settings['payza_enable']['value'],
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Payza Merchant Email') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['payza_email']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'email',
                            'value' => $settings['payza_email']['value']
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Enable Payza Test Mode') ?></div>
                    <div class="col-sm-10">
                        <p class="form-group"><?= __('You can enable Payza sandox from your Payza account settings.') ?></p>
                    </div>
                </div>

            </div>

            <div role="tabpanel" id="social" class="tab-pane fade in">
                <p></p>
                <div class="row">
                    <div class="col-sm-2"><?= __('Facebook Page URL') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['facebook_url']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'url',
                            'value' => $settings['facebook_url']['value']
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Twitter Profile URL') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['twitter_url']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'url',
                            'value' => $settings['twitter_url']['value']
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Google Plus URL') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['google_plus_url']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'url',
                            'value' => $settings['google_plus_url']['value']
                        ]);

                        ?>
                    </div>
                </div>


            </div>
            
            <div role="tabpanel" id="email" class="tab-pane fade in">
                <p></p>
                <div class="row">
                    <div class="col-sm-2"><?= __('From Email') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['email_from']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'email',
                            'value' => $settings['email_from']['value']
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Email Method') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['email_method']['id'] . '.value', [
                            'label' => false,
                            'options' => [
                                'default' => __('PHP Mail Function'),
                                'smtp' => __('SMTP')
                            ],
                            'value' => $settings['email_method']['value'],
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('SMTP Outgoing Host') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['email_smtp_host']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'text',
                            'value' => $settings['email_smtp_host']['value']
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('SMTP Outgoing Port') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['email_smtp_port']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'text',
                            'value' => $settings['email_smtp_port']['value']
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('SMTP Username') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['email_smtp_username']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'text',
                            'value' => $settings['email_smtp_username']['value']
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('SMTP Password') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['email_smtp_password']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'password',
                            'value' => $settings['email_smtp_password']['value']
                        ]);

                        ?>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('SMTP TLS') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['email_smtp_tls']['id'] . '.value', [
                            'label' => false,
                            'options' => [
                                'false' => __('No'),
                                'true' => __('Yes')
                            ],
                            'value' => $settings['email_smtp_tls']['value'],
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>

            </div>

        </div>
        <?= $this->Form->button(__('Save'), ['class' => 'btn btn-primary']); ?>
        <?= $this->Form->end(); ?>
    </div>
</div>
