<?php

namespace App\Controller\Member;

use App\Controller\AppController;
use Cake\Event\Event;

class AppMemberController extends AppController
{

    public $paginate = [
        'limit' => 10,
        'order' => ['created' => 'DESC']
    ];

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);

        if (in_array($this->Auth->user('role'), ['member', 'admin'])) {
            // Allow all actions
            $this->Auth->allow();
        }
        $this->viewBuilder()->layout('member');
    }
}
