<?php
/**
 * Unreal Studio
 * Project: UnrealLicensing
 * User: jhollsoliver
 * Date: 03/06/15
 * Time: 16:38
 */

/**
 * Configuration Includes
 */

include_once 'config.php';

if(!isset($BaseURL))
{
    header("Location: install/");
}

/**
 * Library Includes
 */
include_once 'libs/RevAlgo.php';
include_once 'libs/Gauntlet.php';
include_once 'libs/Tools.php';
include_once 'libs/FilterClass.php';
include_once 'libs/totp.class.php';
include_once 'libs/sqAES.php';
include_once 'libs/SignatureHandler.php';

/**
 * Library Object Initialization
 */

$Gauntlet = new Gauntlet();
$RevAlgo = new RevAlgo($RevAlgoCfg['key'], $RevAlgoCfg['sep']);
$Tools = new Tools();
$TOTP = new TOTP();
@$DatabaseHandler = new mysqli($Database['host'], $Database['user'], $Database['pass'], $Database['data']);
if($DatabaseHandler->connect_errno > 0)
{
    include 'system/errors/db_conn.php';
    die();
}
$TOTP->setSecretKey($RevAlgoCfg['key']);
$TOTP->setDigitsNumber(16);
$TOTP->setExpirationTime(240);
$Tools->RegisterClass('DbHandler', $DatabaseHandler);
$Tools->RegisterClass('TOTP', $TOTP);

/**
 * Constants Declaration
 */
define('BASE_URL', $BaseURL);
define('ASSETS_URL', $BaseURL.'/assets');
unset($BaseURL);
define('PRODUCT_NAME', 'PHPMyLicense');
define('PRODUCT_VERSION', '3.2.0');
define('SYSTEMPATH', dirname(__FILE__));
define('PHPMYLICENSE_API', 'https://api.phpmylicense.ml/v1');
define('PHPMYLICENSE_UPDATESERVICE', 'https://updates.phpmylicense.ml');
$query = $DatabaseHandler->query("SELECT configurations FROM settings");
$data = $query->fetch_array();
$data = json_decode($data['configurations']);
define('PRODUCT_UPDATECHANNEL', $data->updatechannel);


/**
 * Security Initialization
 */

$SignatureHandler = new SignatureHandler();

/**
 * Session Declaration
 */

session_start();