SET SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";
SET time_zone = "+00:00";

CREATE TABLE IF NOT EXISTS `apikeys` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `apikey` varchar(255) NOT NULL,
  `license_insert_permission` tinyint(1) NOT NULL DEFAULT '0',
  `license_update_permission` tinyint(1) NOT NULL DEFAULT '0',
  `license_delete_permission` tinyint(1) NOT NULL DEFAULT '0',
  `license_read_permission` tinyint(1) NOT NULL DEFAULT '1',
  `status` varchar(255) NOT NULL DEFAULT 'active',
  `issued` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=10 ;


CREATE TABLE IF NOT EXISTS `licenses` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `host` varchar(255) NOT NULL,
  `licensekey` varchar(255) NOT NULL,
  `customer_email` varchar(255) NOT NULL,
  `expirydate` varchar(255) NOT NULL,
  `productid` int(11) NOT NULL,
  `status` varchar(255) NOT NULL,
  `issued-by` int(11) NOT NULL,
  `comments` varchar(255) NOT NULL,
  `parameters` varchar(9999) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Estrutura da tabela `products`
--

CREATE TABLE IF NOT EXISTS `products` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `fullname` varchar(9999) NOT NULL,
  `shortname` varchar(9999) NOT NULL,
  `added` varchar(9999) NOT NULL,
  `sandbox` tinyint(1) NOT NULL,
  `trialtime` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 AUTO_INCREMENT=1 ;

-- --------------------------------------------------------

--
-- Estrutura da tabela `settings`
--

CREATE TABLE IF NOT EXISTS `settings` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `purchasecode` varchar(255) NOT NULL,
  `configurations` mediumtext NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=3 ;
--
-- Estrutura da tabela `users`
--

CREATE TABLE IF NOT EXISTS `users` (
  `id` int(255) NOT NULL AUTO_INCREMENT,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `avatar` mediumtext NOT NULL,
  `last_login_ip` varchar(255) NOT NULL,
  `last_login_timestamp` varchar(255) NOT NULL,
  `role` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB  DEFAULT CHARSET=latin1 AUTO_INCREMENT=6 ;

--
-- Extraindo dados da tabela `users`
--

INSERT INTO `users` (`id`, `username`, `password`, `name`, `email`, `avatar`, `last_login_ip`, `last_login_timestamp`, `role`, `status`) VALUES
(1, 'trialtimeissuer', '451e00f584ac3b6bc3f555aaf2d17220831803ec9a272d31df8c9928d616009f', 'Trial Issuer', 'trial@issuer.php', '', '0.0.0.0', '0', 'trialtimeissuer', 'active')