CREATE TABLE IF NOT EXISTS `licenses` (
  `id` int(11) NOT NULL,
  `host` varchar(255) NOT NULL,
  `licensekey` varchar(255) NOT NULL,
  `customer_email` varchar(255) NOT NULL,
  `expirydate` varchar(255) NOT NULL,
  `productid` int(11) NOT NULL,
  `status` varchar(255) NOT NULL,
  `issued-by` int(11) NOT NULL,
  `comments` varchar(255) NOT NULL,
  `parameters` varchar(9999) DEFAULT NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;

CREATE TABLE IF NOT EXISTS `products` (
  `id` int(11) NOT NULL,
  `fullname` varchar(9999) NOT NULL,
  `shortname` varchar(9999) NOT NULL,
  `added` varchar(9999) NOT NULL,
  `sandbox` tinyint(1) NOT NULL,
  `trialtime` int(11) NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
CREATE TABLE IF NOT EXISTS `settings` (
  `id` int(11) NOT NULL,
  `purchasecode` varchar(255) NOT NULL,
  `configurations` varchar(9999) DEFAULT NULL
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
CREATE TABLE IF NOT EXISTS `users` (
  `id` int(255) NOT NULL,
  `username` varchar(255) NOT NULL,
  `password` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `email` varchar(255) NOT NULL,
  `avatar` mediumtext NOT NULL,
  `last_login_ip` varchar(255) NOT NULL,
  `last_login_timestamp` varchar(255) NOT NULL,
  `role` varchar(255) NOT NULL,
  `status` varchar(255) NOT NULL
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=latin1;

INSERT INTO users VALUES (1, 'trialtimeissuer', '451e00f584ac3b6bc3f555aaf2d17220831803ec9a272d31df8c9928d616009f', 'Trial Issuer', 'trial@issuer.php', '', '0.0.0.0', '0', 'trialtimeissuer', 'active');


ALTER TABLE `licenses`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `products`
--
ALTER TABLE `products`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `settings`
--
ALTER TABLE `settings`
  ADD PRIMARY KEY (`id`);

--
-- Indexes for table `users`
--
ALTER TABLE `users`
  ADD PRIMARY KEY (`id`);

--
-- AUTO_INCREMENT for dumped tables
--

--
-- AUTO_INCREMENT for table `licenses`
--
ALTER TABLE `licenses`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT for table `products`
--
ALTER TABLE `products`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT for table `settings`
--
ALTER TABLE `settings`
  MODIFY `id` int(11) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=2;
--
-- AUTO_INCREMENT for table `users`
--
ALTER TABLE `users`
  MODIFY `id` int(255) NOT NULL AUTO_INCREMENT,AUTO_INCREMENT=5;