<?php
$this->assign('title', __('Withdraw Funds'));
$this->assign('description', '');
$this->assign('content_title', __('Withdraw Funds'));

?>

<?php ?>

<div class="row">
    <div class="col-sm-4">
        <div class="small-box bg-aqua">
            <div class="inner">
                <h3><?= (float) $user->publisher_balance ?></h3>
                <p><?= __('Available Balance') ?></p>
            </div>
            <div class="icon"><i class="fa fa-money"></i></div>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="small-box bg-red">
            <div class="inner">
                <h3>$<?= (int) $pending_withdrawn ?></h3>
                <p><?= __('Pending Withdrawn') ?></p>
            </div>
            <div class="icon"><i class="fa fa-share"></i></div>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="small-box bg-green">
            <div class="inner">
                <h3>$<?= (int) $tolal_withdrawn ?></h3>
                <p><?= __('Tolal Withdrawn') ?></p>
            </div>
            <div class="icon"><i class="fa fa-usd"></i></div>
        </div>
    </div>
</div>



<div class="box box-primary">
    <div class="box-body">
        <div class="text-center"><?= $this->Form->postLink(__('Withdraw'), ['action' => 'request'], ['confirm' => __('Are you sure?'), 'class' => 'btn btn-success btn-lg']); ?></div>

        <hr>

        <p><?= __("When your account reaches the minimum amount of $5.00 or more, you may request your earnings by clicking the above button. The payment is then sent to your PayPal account during business days no longer than 4 days after requesting. Please do not contact us regarding payments before due dates.") ?></p>

        <p><?= __("In order to receive your payments you need to fill your payment method and payment ID <a href='#'>here</a> if you haven't done so. You are also requested to fill all the required fields in the Account Details section with accurate data.") ?></p>

        <hr>

        <table class="table table-hover table-striped">
            <thead>
                <tr>
                    <th><?= __('Id') ?></th>
                    <th><?= __('Date') ?></th>
                    <th><?= __('Status') ?></th>
                    <th><?= __('Amount') ?></th>
                </tr>
            </thead>
            <?php foreach ($withdraws as $withdraw): ?>
                <tr>
                    <td><?= $withdraw->id ?></td>
                    <td><?= $this->Time->i18nFormat($withdraw->created, null, null, get_option('timezone')); ?></td>
                    <td><?= $withdraw->status ?></td>
                    <td><?= $withdraw->amount ?></td>
                </tr>
            <?php endforeach; ?>
            <?php unset($withdraw); ?>
        </table>

        <hr>

        <ul>
            <li><?= __("Pending: The payment is being checked by our team.") ?></li>
            <li><?= __("Approved: The payment has been approved and is waiting to be sent.") ?></li>
            <li><?= __("Complete: The payment has been successfully sent to your Paypal account.") ?></li>
        </ul>
    </div><!-- /.box-body -->
</div>
