<?php
$this->assign('title', __('Profile'));
$this->assign('description', '');
$this->assign('content_title', __('Profile'));

?>

<div class="box box-primary">
    <div class="box-body">

        <?= $this->Form->create($user); ?>

        <?= $this->Form->hidden('id'); ?>

        <legend><?= __('Billing Address') ?></legend>

        <div class="row">
            <div class="col-sm-6">
                <?=
                $this->Form->input('first_name', [
                    'label' => __('First Name'),
                    'class' => 'form-control'
                ])

                ?>
            </div>
            <div class="col-sm-6">
                <?=
                $this->Form->input('last_name', [
                    'label' => __('Last Name'),
                    'class' => 'form-control'
                ])

                ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-6">
                <?=
                $this->Form->input('address1', [
                    'label' => __('Address 1'),
                    'class' => 'form-control'
                ])

                ?>
            </div>
            <div class="col-sm-6">
                <?=
                $this->Form->input('address2', [
                    'label' => __('Address 2'),
                    'class' => 'form-control'
                ])

                ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-6">
                <?=
                $this->Form->input('city', [
                    'label' => __('City'),
                    'class' => 'form-control'
                ])

                ?>
            </div>
            <div class="col-sm-6">
                <?=
                $this->Form->input('state', [
                    'label' => __('State'),
                    'class' => 'form-control'
                ])

                ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-6">
                <?=
                $this->Form->input('zip', [
                    'label' => __('ZIP'),
                    'class' => 'form-control'
                ])

                ?>
            </div>
            <div class="col-sm-6">
                <?=
                $this->Form->input('country', [
                    'label' => __('Country'),
                    'options' => get_countries(),
                    'empty' => __('Choose'),
                    'class' => 'form-control'
                ]);

                ?>
            </div>
        </div>

        <div class="row">
            <div class="col-sm-6">
                <?=
                $this->Form->input('phone_number', [
                    'label' => __('Phone Number'),
                    'class' => 'form-control'
                ])

                ?>
            </div>
        </div>

        <legend><?= __('Withdrawal Info') ?></legend>

        <div class="row">
            <div class="col-sm-6">
                <?=
                $this->Form->input('withdrawal_method', [
                    'label' => __('Withdrawal Method'),
                    'options' => [
                        'paypal' => __('PayPal')
                    ],
                    'empty' => __('Choose'),
                    'class' => 'form-control'
                ]);

                ?>
            </div>
            <div class="col-sm-6">
                <?=
                $this->Form->input('withdrawal_email', [
                    'label' => __('Withdrawal Email'),
                    'class' => 'form-control',
                    'type' => 'email'
                ])

                ?>
            </div>
        </div>



        <?= $this->Form->button(__('Submit'), [ 'class' => 'btn btn-primary btn-lg']); ?>

        <?= $this->Form->end() ?>

    </div>
</div>
