<?php
$this->assign('title', __('Manage Campaigns'));
$this->assign('description', '');
$this->assign('content_title', __('Manage Campaigns'));

?>

<div class="box box-primary">
    <div class="box-body">

        <table class="table table-hover table-striped">
            <thead>
                <tr>
                    <th><?= __('Reference') ?></th>
                    <th><?= __('title') ?></th>
                    <th><?= __('Price') ?></th>
                    <th><?= __('Visitors/Total') ?></th>
                    <th><?= __('Status') ?></th>
                    <th><?= __('Created') ?></th>
                    <th><?= __('Actions') ?></th>
                </tr>
            </thead>
            <?php foreach ($campaigns as $campaign): ?>
                <tr>
                    <td><?= $campaign->id ?></td>
                    <td>
                        <?php echo $this->Html->link($campaign->title, array('controller' => 'Campaigns', 'action' => 'view', $campaign->id));

                        ?>
                    </td>
                    <td>$<?= $campaign->price; ?></td>
                    <td>
                        <?php
                        $views_total = ['views' => 0, 'total' => 0];
                        foreach ($campaign->campaign_items as $campaign_item) {
                            $views_total['views'] += $campaign_item->views;
                            $views_total['total'] += $campaign_item->purchase * 1000;
                        }

                        ?>
                        <?= $views_total['views'] ?>/<?= $views_total['total'] ?>
                    </td>
                    <td><?= $campaign->status; ?></td>
                    <td><?= $this->Time->i18nFormat($campaign->created, null, null, get_option('timezone')); ?></td>
                    <td>
                        <?= $this->Html->link(__('View'), ['action' => 'view', $campaign->id], ['class' => 'btn btn-primary btn-xs']); ?>
                        <?php if ('Pending Payment' == $campaign->status) : ?>
                            <?= $this->Form->postLink(__('Pay'), ['action' => 'pay', $campaign->id], ['confirm' => __('Are you sure?'), 'class' => 'btn btn-success btn-xs']); ?>
                        <?php endif; ?>
                        <?php if ('Active' == $campaign->status) : ?>
                            <?= $this->Form->postLink(__('Pause'), ['action' => 'pause', $campaign->id], ['confirm' => __('Are you sure?'), 'class' => 'btn btn-success btn-xs']); ?>
                        <?php endif; ?>
                        <?php if ('Paused' == $campaign->status) : ?>
                            <?= $this->Form->postLink(__('Resume'), ['action' => 'resume', $campaign->id], ['confirm' => __('Are you sure?'), 'class' => 'btn btn-success btn-xs']); ?>
                        <?php endif; ?>
                    </td>
                </tr>
            <?php endforeach; ?>
            <?php unset($campaign); ?>
        </table>

    </div><!-- /.box-body -->
</div>

<ul class="pagination">
    <!-- Shows the previous link -->
    <?php
    if ($this->Paginator->hasPrev()) {
        echo $this->Paginator->prev('«', array('tag' => 'li'), null, array('class' => 'disabled', 'tag' => 'li', 'disabledTag' => 'a'));
    }

    ?>
    <!-- Shows the page numbers -->
    <?php //echo $this->Paginator->numbers();    ?>
    <?php
    echo $this->Paginator->numbers(array(
        'modulus' => 4,
        'separator' => '',
        'ellipsis' => '<li><a>...</a></li>',
        'tag' => 'li',
        'currentTag' => 'a',
        'first' => 2,
        'last' => 2
    ));

    ?>
    <!-- Shows the next link -->
    <?php
    if ($this->Paginator->hasNext()) {
        echo $this->Paginator->next('»', array('tag' => 'li'), null, array('class' => 'disabled', 'tag' => 'li', 'disabledTag' => 'a'));
    }

    ?>
</ul>
