<?php
$this->assign('title', __('Create Campaign'));
$this->assign('description', '');
$this->assign('content_title', __('Create Campaign'));

?>

<?php
$interstitial_price = get_option('interstitial_price');
$countries = get_countries(true);
$i = 0;

?>

<div class="box box-primary">
    <div class="box-body">

        <p>Please find our advertising rate table below. Each visitor you will purchase from adf.ly will meet the following criteria:</p>

        <ul>
            <li>Unique within a 24 hour time frame</li>
            <li>They will have JavaScript enabled</li>
            <li>They will have Cookies enabled</li>
            <li>Must view your website for at least 5 seconds</li>
            <li>Anonymous proxy filtered against a massive daily updated list</li>
        </ul>

        <p>You may receive traffic that does not meet this criteria, but you will never be charged for it.</p>


        <?= $this->Form->create($campaign, ['id' => 'campaign-create']); ?>

        <legend><?= __('Website Details') ?></legend>

        <?=
        $this->Form->input('title', [
            'label' => __('Title'),
            'class' => 'form-control'
        ]);

        ?>

        <?=
        $this->Form->input('url', [
            'label' => __('URL'),
            'class' => 'form-control',
            'type' => 'url'
        ]);

        ?>

        <legend><?= __('Advertising Rates') ?></legend>

        <table class="table table-hover table-striped">
            <thead>
                <tr>
                    <th><?= __('Country') ?></th>
                    <th><?= __('Price / 1,000') ?></th>
                    <th><?= __('Purchase') ?></th>
                </tr>
            </thead>
            <?php foreach ($interstitial_price as $key => $value) : ?>
                <?php
                if (empty($value['advertiser'])) {
                    continue;
                }

                ?>
                <tr>
                    <td>
                        <?= $countries[$key] ?>
                        <?= $this->Form->hidden("campaign_items.$i.country", ['value' => $key]); ?>
                        <?= $this->Form->input("campaign_items.$i.advertiser_price", ['type' => 'hidden', 'value' => $value['advertiser']]); ?>
                        <?= $this->Form->input("campaign_items.$i.publisher_price", ['type' => 'hidden', 'value' => $value['publisher']]); ?>
                    </td>
                    <td>
                        <?= $value['advertiser'] ?>
                    </td>
                    <td>
                        <?=
                        $this->Form->input("campaign_items.$i.purchase", [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'number'
                        ]);

                        ?>
                    </td>
                </tr>
                <?= ( 0 == $i % 2 ) ? '</div><div class="row">' : ''; ?>
                <?php $i++ ?>
            <?php endforeach; ?>
        </table>
        <div class="text-center">
            <p class="text-success" style="font-size: 23px;"><?= __("You have ordered <span id='total-visitors'>0</span> visitors for a total of $<span id='total-price'>0.00</span>") ?></p>
            <?= $this->Form->button(__('Pay Campaign'), ['class' => 'btn btn-success btn-lg']); ?>
        </div>

        <?= $this->Form->end(); ?>
    </div><!-- /.box-body -->
</div>



