<?php $user = $this->request->session()->read('Auth.User'); ?>
<!DOCTYPE html>
<html>
    <head>
        <?php echo $this->Html->charset(); ?>
        <title><?= $this->fetch('title'); ?></title>
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="description" content="<?= $this->fetch('description'); ?>">
        <?php
        echo $this->Html->meta('icon');

        //echo $this->Html->css( 'base.css' );
        //echo $this->Html->css( 'cake.css' );
        echo $this->Html->css('//cdn.rawgit.com/twbs/bootstrap/v3.3.6/dist/css/bootstrap.min.css');
        //echo $this->Html->css( '//cdn.rawgit.com/twbs/bootstrap/v3.3.6/dist/css/bootstrap-theme.min.css' );
        if (get_option('language_direction') == 'rtl') {
            echo $this->Html->css('//cdn.rawgit.com/morteza/bootstrap-rtl/v3.4.0/dist/css/bootstrap-rtl.min.css');
            //echo $this->Html->css( '//cdn.rawgit.com/morteza/bootstrap-rtl/v3.4.0/dist/css/bootstrap-flipped.min.css' );
        }
        echo $this->Html->css('//cdn.rawgit.com/FortAwesome/Font-Awesome/v4.6.3/css/font-awesome.min.css');
        echo $this->Html->css('//cdn.rawgit.com/almasaeed2010/AdminLTE/v2.3.3/dist/css/AdminLTE.min.css');
        echo $this->Html->css('//cdn.rawgit.com/almasaeed2010/AdminLTE/v2.3.3/dist/css/skins/skin-blue.min.css');
        echo $this->Html->css('app');
        if (get_option('language_direction') == 'rtl') {
            echo $this->Html->css('app-rtl');
        }
        echo $this->fetch('meta');
        echo $this->fetch('css');
        echo $this->fetch('script');

        ?>

        <?= get_option('head_code'); ?>

        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/html5shiv/3.7.3/html5shiv.min.js"></script>
        <script src="https://oss.maxcdn.com/respond/1.4.2/respond.min.js"></script>
        <![endif]-->
    </head>
    <body class="<?= (get_option('language_direction') == 'rtl' ? "rtl" : "") ?> frame layout-top-nav skin-blue">
        <?= get_option('after_body_tag_code'); ?>

        <div class="wrapper">


            <header class="main-header">
                <!-- Fixed navbar -->
                <nav class="navbar">
                    <div class="container">
                        <div class="navbar-header pull-left">
                            <a class="navbar-brand" href="<?= $this->Url->build('/'); ?>"><?= h(get_option('site_name')) ?></a>
                        </div>
                        <div class="pull-right counter">
                            <?=
                            $this->Form->create(null, [
                                'url' => [ 'controller' => 'Links', 'action' => 'go', 'prefix' => false],
                                'id' => 'go-link'
                            ]);

                            ?>

                            <?= $this->Form->hidden('alias', ['value' => $link->alias]); ?>
                            <?= $this->Form->hidden('ci', ['value' => $campaign_item->campaign_id]); ?>
                            <?= $this->Form->hidden('cui', ['value' => $campaign_item->campaign->user_id]); ?>
                            <?= $this->Form->hidden('cii', ['value' => $campaign_item->id]); ?>
                            <?= $this->Form->hidden('ref', ['value' => strtolower(env('HTTP_REFERER'))]); ?>

                            <?=
                            $this->Form->button(__('Please Wait 10s'), [
                                'id' => 'go-submit',
                                'class' => 'btn btn-default',
                                'onclick' => 'javascript: return false;'
                            ]);

                            ?>
                            <?= $this->Form->end(); ?>
                        </div>
                    </div>
                </nav>
            </header>

            <?= $this->Flash->render() ?>
            <?= $this->fetch('content') ?>

        </div>
        <?= $this->Html->script('//code.jquery.com/jquery-1.12.4.min.js'); ?>
        <?= $this->Html->script('//cdn.rawgit.com/twbs/bootstrap/v3.3.6/dist/js/bootstrap.min.js'); ?>
        <script type="text/javascript">
            var addthis_config = {
                "ui_language": "<?= h(get_option('language', 'en')); ?>"
            };
        </script>
        <?= $this->Html->script('app'); ?>
        <?= $this->Html->script('//cdn.rawgit.com/almasaeed2010/AdminLTE/v2.3.3/dist/js/app.js'); ?>
        <?= $this->fetch('scriptBottom') ?>
        <?= get_option('footer_code'); ?>
    </body>
</html>
