<?php
$this->assign('title', __('Manage Withdraws'));
$this->assign('description', '');
$this->assign('content_title', __('Manage Withdraws'));

?>

<div class="row">
    <div class="col-sm-4">
        <div class="small-box bg-aqua">
            <div class="inner">
                <h3><?= (float) $publishers_balance ?></h3>
                <p><?= __('Publishers Available Balance') ?></p>
            </div>
            <div class="icon"><i class="fa fa-money"></i></div>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="small-box bg-red">
            <div class="inner">
                <h3>$<?= (int) $pending_withdrawn ?></h3>
                <p><?= __('Pending Withdrawn') ?></p>
            </div>
            <div class="icon"><i class="fa fa-share"></i></div>
        </div>
    </div>
    <div class="col-sm-4">
        <div class="small-box bg-green">
            <div class="inner">
                <h3>$<?= (int) $tolal_withdrawn ?></h3>
                <p><?= __('Tolal Withdrawn') ?></p>
            </div>
            <div class="icon"><i class="fa fa-usd"></i></div>
        </div>
    </div>
</div>



<div class="box box-primary">
    <div class="box-body">
        <table class="table table-hover table-striped">
            <thead>
                <tr>
                    <th><?= __('Id') ?></th>
                    <th><?= __('User') ?></th>
                    <th><?= __('Date') ?></th>
                    <th><?= __('Status') ?></th>
                    <th><?= __('Amount') ?></th>
                    <th><?= __('Action') ?></th>
                </tr>
            </thead>
            <?php foreach ($withdraws as $withdraw): ?>
                <tr>
                    <td><?= $this->Html->link($withdraw->id, array('action' => 'edit', $withdraw->id)); ?></td>
                    <td><?= $this->Html->link($withdraw->user->username, array('controller' => 'Users', 'action' => 'view', $withdraw->user->id, 'prefix' => 'admin')); ?></td>
                    <td><?= $this->Time->i18nFormat($withdraw->created, null, null, get_option('timezone')); ?></td>
                    <td><?= $withdraw->status ?></td>
                    <td><?= $withdraw->amount ?></td>
                    <td>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $withdraw->id], ['class' => 'btn btn-primary btn-xs']); ?>
                        <?php if ($withdraw->status == 'Pending'): ?>
                            <?= $this->Form->postLink(__('Approve'), ['action' => 'approve', $withdraw->id], ['confirm' => __('Are you sure?'), 'class' => 'btn btn-success btn-xs']); ?>
                        <?php endif; ?>

                        <?php if ($withdraw->status == 'Approved'): ?>
                            <?= $this->Form->postLink(__('Complete'), ['action' => 'complete', $withdraw->id], ['confirm' => __('Are you sure?'), 'class' => 'btn btn-success btn-xs']); ?>
                        <?php endif; ?>

                    </td>
                </tr>
            <?php endforeach; ?>
            <?php unset($withdraw); ?>
        </table>

        <ul>
            <li><?= __("Pending: The payment is being checked by our team.") ?></li>
            <li><?= __("Approved: The payment has been approved and is waiting to be sent.") ?></li>
            <li><?= __("Complete: The payment has been successfully sent to your Paypal account.") ?></li>
        </ul>

    </div><!-- /.box-body -->
</div>
