<?php
$this->assign('title', __('Dashboard'));
$this->assign('description', '');
$this->assign('content_title', __('Dashboard'));

?>

<div class="row">
    <div class="col-lg-3 col-xs-6">
        <!-- small box -->
        <div class="small-box bg-aqua">
            <div class="inner">
                <h3><?= $owner_earnings ?></h3>

                <p><?= __('Owner Earnings') ?></p>
            </div>
            <div class="icon">
                <i class="fa fa-dollar"></i>
            </div>
            <a href="<?php echo $this->Url->build(array('controller' => 'Campaigns', 'action' => 'index')); ?>" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
        </div>
    </div>

    <div class="col-lg-3 col-xs-6">
        <!-- small box -->
        <div class="small-box bg-aqua">
            <div class="inner">
                <h3><?= $publisher_earnings ?></h3>

                <p><?= __('Publisher Earnings') ?></p>
            </div>
            <div class="icon">
                <i class="fa fa-shopping-bag"></i>
            </div>
            <a href="<?php echo $this->Url->build(array('controller' => 'Campaigns', 'action' => 'index')); ?>" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
        </div>
    </div>

    <div class="col-lg-3 col-xs-6">
        <!-- small box -->
        <div class="small-box bg-yellow">
            <div class="inner">
                <h3><?= $total_views ?></h3>

                <p><?= __('Tolal Views') ?></p>
            </div>
            <div class="icon">
                <i class="fa fa-bar-chart"></i>
            </div>
            <a href="#" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
        </div>
    </div>

    <div class="col-lg-3 col-xs-6">
        <!-- small box -->
        <div class="small-box bg-green">
            <div class="inner">
                <h3><?= $tolal_withdrawn ?><sup style="font-size: 20px">$</sup></h3>

                <p><?= __('Tolal Withdrawn') ?></p>
            </div>
            <div class="icon">
                <i class="fa fa-share"></i>
            </div>
            <a href="<?php echo $this->Url->build(array('controller' => 'Withdraws', 'action' => 'index')); ?>" class="small-box-footer">More info <i class="fa fa-arrow-circle-right"></i></a>
        </div>
    </div>
</div>

<?php
//pr( $linksStats );

?>

<div class="box box-primary">
    <div class="box-header with-border">
        <i class="fa fa-bar-chart"></i> <h3 class="box-title"><?= __('Statistics') ?></h3>
        <div class="pull-right box-tools">
            <?=
            $this->Form->create(null, [
                'url' => [ 'controller' => 'Users', 'action' => 'dashboard'],
            ]);

            ?>

            <?=
            $this->Form->input('to_month', [
                'label' => false,
                'options' => $year_month,
                'class' => 'form-control input-sm',
                'onchange' => 'this.form.submit();'
            ]);

            ?>

            <?= $this->Form->button(__('Submit'), ['class' => 'hidden']); ?>

            <?= $this->Form->end(); ?>
        </div>
    </div>
    <div class="box-body no-padding">
        <div id="chart_div" style="position: relative; height: 300px; width: 100%;"></div>
    </div>

    <table class="table table-hover table-striped">
        <thead>
            <tr>
                <th><?= __('Date') ?></th>
                <th><?= __('Views') ?></th>
                <th><?= __('Link Earnings') ?></th>
            </tr>
        </thead>
        <?php foreach ($CurrentMonthDays as $key => $value): ?>
            <tr>
                <td><?= $key ?></td>
                <td><?= $value['view'] ?></td>
                <td><?= $value['earn'] ?></td>

            </tr>
        <?php endforeach; ?>
    </table>



    <?php $this->start('scriptBottom'); ?>

    <link rel="stylesheet" href="//cdn.rawgit.com/almasaeed2010/AdminLTE/v2.3.3/plugins/morris/morris.css">
    <script src="//cdn.rawgit.com/DmitryBaranovskiy/raphael/v2.1.0/raphael-min.js"></script>
    <script src="//cdn.rawgit.com/almasaeed2010/AdminLTE/v2.3.3/plugins/morris/morris.min.js" type="text/javascript"></script>

    <script>
        jQuery(document).ready(function () {
            new Morris.Line({
                element: 'chart_div',
                resize: true,
                data: [
<?php
foreach ($CurrentMonthDays as $key => $value) {
    $date = date("Y-m-d", strtotime($key));
    echo '{date: "' . $date . '", views: ' . $value['view'] . '},';
}

?>
                ],
                xkey: 'date',
                xLabels: 'day',
                ykeys: ['views'],
                labels: ['<?= __('Views') ?>'],
                lineColors: ['#3c8dbc'],
                lineWidth: 2,
                hideHover: 'auto',
                smooth: false
            });
        });
    </script>



    <?php
    $this->end();

    