<?php
$this->assign('title', __('Settings'));
$this->assign('description', '');
$this->assign('content_title', __('Settings'));

?>

<div class="box box-primary">
    <div class="box-body">

        <?= $this->Form->create($options, ['id' => 'form-settings']); ?>

        <!-- Nav tabs -->
        <ul class="nav nav-tabs" role="tablist">
            <li role="presentation" class=""><a href="#general" aria-controls="general" role="tab" data-toggle="tab"><?= __('General') ?></a></li>
            <li role="presentation" class=""><a href="#links" aria-controls="links" role="tab" data-toggle="tab"><?= __('Links') ?></a></li>
            <li role="presentation"><a href="#captcha" aria-controls="captcha" role="tab" data-toggle="tab"><?= __('Captcha') ?></a></li>
            <li role="presentation"><a href="#payment" aria-controls="payment" role="tab" data-toggle="tab"><?= __('Payment') ?></a></li>
            <li role="presentation"><a href="#social" aria-controls="Social Media" role="tab" data-toggle="tab"><?= __('Social Media') ?></a></li>
        </ul>

        <!-- Tab panes -->
        <div class="tab-content">
            <div role="tabpanel" id="general" class="tab-pane fade in active">
                <p></p>
                <div class="row">
                    <div class="col-sm-2"><?= __('Site Name') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['site_name']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'text',
                            'value' => $settings['site_name']['value']
                        ]);

                        ?>
                        <span class="help-block"><?= __('This is your site name as well as the site meta title.') ?></span>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Site Description') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['description']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['description']['value']
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Admin Email') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['admin_email']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'email',
                            'value' => $settings['admin_email']['value']
                        ]);

                        ?>
                        <span class="help-block"><?= __('This email used for the contact form and all outgoing emails') ?></span>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Language') ?></div>
                    <div class="col-sm-10">
                        <?php
                        $locale = new \Cake\Filesystem\Folder(APP . 'Locale');
                        $languages = $locale->subdirectories(null, false);

                        ?>
                        <?=
                        $this->Form->input('Options.' . $settings['language']['id'] . '.value', [
                            'label' => false,
                            'options' => array_combine($languages, $languages),
                            'value' => $settings['language']['value'],
                            //'empty'   => __( 'Choose' ),
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row hidden">
                    <div class="col-sm-2"><?= __('Language Direction') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['language_direction']['id'] . '.value', [
                            'label' => false,
                            'options' => [
                                'ltr' => __('LTR'),
                                'rtl' => __('RTL')
                            ],
                            'value' => $settings['language_direction']['value'],
                            //'empty'   => __( 'Choose' ),
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Time Zone') ?></div>
                    <div class="col-sm-10">
                        <?php
                        $DateTimeZone = \DateTimeZone::listIdentifiers(DateTimeZone::ALL);
                        echo $this->Form->input('Options.' . $settings['timezone']['id'] . '.value', [
                            'label' => false,
                            'options' => array_combine($DateTimeZone, $DateTimeZone),
                            'value' => $settings['timezone']['value'],
                            //'empty'   => __( 'Choose' ),
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Head Code') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['head_code']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['head_code']['value']
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Footer Code') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['footer_code']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['footer_code']['value']
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('After Body Tag Code') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['after_body_tag_code']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['after_body_tag_code']['value']
                        ]);

                        ?>
                    </div>
                </div>


            </div>
            <div role="tabpanel" id="links" class="tab-pane fade in active">
                <p></p>
                <div class="row">
                    <div class="col-sm-2"><?= __('Disallowed Domains') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['disallowed_domains']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'textarea',
                            'value' => $settings['disallowed_domains']['value']
                        ]);

                        ?>
                        <span class="help-block"><?= __('Disallow links with certain domains from being shortened. Separate by comma, no spaces.') ?></span>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Alias Min. Length') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['alias_min_length']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'text',
                            'value' => $settings['alias_min_length']['value']
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Alias Max. Length') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['alias_max_length']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'text',
                            'value' => $settings['alias_max_length']['value']
                        ]);

                        ?>
                    </div>
                </div>


            </div>
            <div role="tabpanel" id="captcha" class="tab-pane fade in">
                <p></p>
                <div class="row">
                    <div class="col-sm-2"><?= __('reCAPTCHA Site key') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['reCAPTCHA_site_key']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'text',
                            'value' => $settings['reCAPTCHA_site_key']['value']
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('reCAPTCHA Secret key') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['reCAPTCHA_secret_key']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'text',
                            'value' => $settings['reCAPTCHA_secret_key']['value']
                        ]);

                        ?>
                    </div>
                </div>

            </div>

            <div role="tabpanel" id="payment" class="tab-pane fade in">
                <p></p>

                <div class="row">
                    <div class="col-sm-2"><?= __('Payment Method') ?></div>
                    <div class="col-sm-10">
                        <div class="form-group">
                            <p class="form-control-static"><?= __('PayPal') ?></p>
                        </div>
                    </div>
                </div>
                
                <div class="row">
                    <div class="col-sm-2"><?= __('Enable PayPal Sandbox') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['paypal_sandbox']['id'] . '.value', [
                            'label' => false,
                            'options' => [
                                'no' => __('No'),
                                'yes' => __('Yes')
                            ],
                            'value' => $settings['paypal_sandbox']['value'],
                            'class' => 'form-control'
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Payment Business Email') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['paypal_email']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'email',
                            'value' => $settings['paypal_email']['value']
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Currency Code') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['currency_code']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'text',
                            'value' => $settings['currency_code']['value']
                        ]);

                        ?>
                    </div>
                </div>


            </div>

            <div role="tabpanel" id="social" class="tab-pane fade in">
                <p></p>
                <div class="row">
                    <div class="col-sm-2"><?= __('Facebook Page URL') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['facebook_url']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'url',
                            'value' => $settings['facebook_url']['value']
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Twitter Profile URL') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['twitter_url']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'url',
                            'value' => $settings['twitter_url']['value']
                        ]);

                        ?>
                    </div>
                </div>

                <div class="row">
                    <div class="col-sm-2"><?= __('Google Plus URL') ?></div>
                    <div class="col-sm-10">
                        <?=
                        $this->Form->input('Options.' . $settings['google_plus_url']['id'] . '.value', [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'url',
                            'value' => $settings['google_plus_url']['value']
                        ]);

                        ?>
                    </div>
                </div>


            </div>

        </div>
        <?= $this->Form->button(__('Save'), ['class' => 'btn btn-primary']); ?>
        <?= $this->Form->end(); ?>
    </div>
</div>
