<?php
$this->assign('title', __('Manage Links'));
$this->assign('description', '');
$this->assign('content_title', __('Manage Links'));

?>


<?php foreach ($links as $link): ?>

    <?php
    $short_url = $this->Url->build('/' . $link->alias, true);

    ?>


    <div class="box box-solid">
        <div class="box-body">
            <h4><a href="<?= $short_url ?>" target="_blank"><span class="glyphicon glyphicon-link"></span> <?= $link->alias ?></a></h4>
            <p class="text-muted">
                <small><?= __('Status') ?> <?= $link->status ?>- <i class="fa fa-user"></i>  <?= $this->Html->link($link->user->username, ['controller' => 'Users', 'action' => 'view', $link->user_id]); ?> - <i class="fa fa-calendar"></i> <?= $this->Time->i18nFormat($link->created, null, null, get_option('timezone')); ?> - <a target="_blank" href="<?= $link->url ?>"><?= strtoupper(parse_url($link->url, PHP_URL_HOST)); ?></a></small>
            </p>
            <div class="row">
                <div class="col-sm-6">
                    <input type="text" class="form-control input-sm" value="<?= $short_url ?>" readonly="" onfocus="javascript:this.select()">
                </div>
                <div class="col-sm-6">
                    <div class="text-right">
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $link->alias], ['class' => 'btn btn-primary btn-sm']); ?>
                        <?= $this->Form->postLink(__('Hide'), ['action' => 'hide', $link->alias], ['confirm' => __('Are you sure?'), 'class' => 'btn btn-danger btn-sm']); ?>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php endforeach; ?>
<?php unset($link); ?>

<ul class="pagination">
    <!-- Shows the previous link -->
    <?php
    if ($this->Paginator->hasPrev()) {
        echo $this->Paginator->prev('«', array('tag' => 'li'), null, array('class' => 'disabled', 'tag' => 'li', 'disabledTag' => 'a'));
    }

    ?>
    <!-- Shows the page numbers -->
    <?php //echo $this->Paginator->numbers();    ?>
    <?php
    echo $this->Paginator->numbers(array(
        'modulus' => 4,
        'separator' => '',
        'ellipsis' => '<li><a>...</a></li>',
        'tag' => 'li',
        'currentTag' => 'a',
        'first' => 2,
        'last' => 2
    ));

    ?>
    <!-- Shows the next link -->
    <?php
    if ($this->Paginator->hasNext()) {
        echo $this->Paginator->next('»', array('tag' => 'li'), null, array('class' => 'disabled', 'tag' => 'li', 'disabledTag' => 'a'));
    }

    ?>
</ul>