<?php
$this->assign('title', __('Add Campaign'));
$this->assign('description', '');
$this->assign('content_title', __('Add Campaign'));

?>

<?php
$interstitial_price = get_option('interstitial_price');
$countries = get_countries(true);

?>

<div class="box box-primary">
    <div class="box-body">
        <?= $this->Form->create($campaign, ['id' => 'campaign-create']); ?>

        <legend><?= __('Campaign Website Details') ?></legend>

        <?=
        $this->Form->input('status', [
            'label' => __('Status'),
            'options' => [
                'Active' => __('Active'),
                'Paused' => __('Paused'),
                'Canceled' => __('Canceled'),
                'Finished' => __('Finished'),
                'Under Review' => __('Under Review'),
                'Pending Payment' => __('Pending Payment'),
                'Invalid Payment' => __('Invalid Payment')
            ],
            'empty' => __('Choose'),
            'class' => 'form-control'
        ]);

        ?>
        <?=
        $this->Form->input('title', [
            'label' => __('Title'),
            'class' => 'form-control'
        ]);

        ?>

        <?=
        $this->Form->input('url', [
            'label' => __('URL'),
            'class' => 'form-control',
            'type' => 'url'
        ]);

        ?>


        <legend><?= __('Advertising Rates') ?></legend>

        <table class="table table-hover table-striped">
            <thead>
                <tr>
                    <th><?= __('Country') ?></th>
                    <th><?= __('Advertiser Price / 1,000') ?></th>
                    <th><?= __('Publisher Price / 1,000') ?></th>
                    <th><?= __('Purchase') ?></th>
                </tr>
            </thead>

            <?php foreach ($campaign->campaign_items as $key => $campaign_item) : ?>
                <tr>
                    <td>
                        <?= $this->Form->hidden("campaign_items.$key.id"); ?>
                        <?=
                        $this->Form->input("campaign_items.$key.country", [
                            'label' => false,
                            'class' => 'form-control'
                        ]);

                        ?>
                    </td>
                    <td>
                        <?= $this->Form->hidden("campaign_items.$key.advertiser_price"); ?>
                        <pre><?= $campaign_item->advertiser_price ?></pre>
                    </td>
                    <td>
                        <?=
                        $this->Form->input("campaign_items.$key.publisher_price", [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'text'
                        ]);

                        ?>
                    </td>
                    <td>
                        <?=
                        $this->Form->input("campaign_items.$key.purchase", [
                            'label' => false,
                            'class' => 'form-control',
                            'type' => 'number'
                        ]);

                        ?>
                    </td>
                </tr>
            <?php endforeach; ?>
        </table>

        <?= $this->Form->button(__('Update Campaign'), ['class' => 'btn btn-success btn-lg']); ?>
        <?= $this->Form->end(); ?>
    </div><!-- /.box-body -->
</div>



