<?php

namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\Validation\Validator;

class CampaignsTable extends Table
{

    public function initialize(array $config)
    {
        $this->belongsTo('Users');
        $this->hasMany('CampaignItems', [
            'dependent' => true,
            'cascadeCallbacks' => true
        ]);
        $this->addBehavior('Timestamp');
    }

    public function validationDefault(Validator $validator)
    {
        $validator
            ->requirePresence('title')
            ->notEmpty('title', __('Please add a title.'))
            ->requirePresence('url')
            ->notEmpty('url', __('Please add a URL.'))
            ->add('url', 'url', [
                'rule' => 'url',
                'message' => __('URL must be valid.')
            ])
            //->requirePresence('price')
            ->notEmpty('price', __('You must have a purchase.'));

        return $validator;
    }

    public function isOwnedBy($id, $user_id)
    {
        return $this->exists(['id' => $id, 'user_id' => $user_id]);
    }
}
