<?php

namespace App\Controller;

use App\Controller\AppController;
use Cake\Event\Event;
use Cake\Network\Exception\NotFoundException;

class PagesController extends AppController
{

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        $this->Auth->allow(['home', 'view']);
    }

    public function home()
    {
        
    }

    public function view($slug = null)
    {
        if (!$slug) {
            throw new NotFoundException(__('Invalid Page.'));
        }

        $page = $this->Pages->find()->where(['slug' => $slug, 'published' => 1])->first();

        if (!$page) {
            throw new NotFoundException(__('Invalid Page.'));
        }

        $page->content = str_replace('[advertising_rates]', $this->advertisingRates(), $page->content);
        $page->content = str_replace('[payout_rates]', $this->payoutRates(), $page->content);

        $this->set('page', $page);
    }

    protected function advertisingRates()
    {
        ob_start();

        ?>
        <table class="table table-hover table-striped">
            <thead>
                <tr>
                    <th><?= __('Package Description / Country') ?></th>
                    <th><?= __('Price 1,000') ?></th>
                </tr>
            </thead>
            <?php
            $interstitial_prices = get_option('interstitial_price');
            $countries = get_countries(true);
            $advertiser_prices = [];
            foreach ($interstitial_prices as $key => $value) {
                if (!empty($value['advertiser'])) {
                    $advertiser_prices[$key] = $value['advertiser'];
                }
            }

            ?>
            <?php foreach ($advertiser_prices as $key => $value) : ?>
                <tr>
                    <td><?= $countries[$key] ?></td>
                    <td>$ <?= $value ?></td>
                </tr>
            <?php endforeach; ?>
        </table>
        <?php
        $advertisingRates = ob_get_contents();
        ob_end_clean();
        return $advertisingRates;
    }

    protected function payoutRates()
    {
        ob_start();

        ?>
        <table class="table table-hover table-striped">
            <thead>
                <tr>
                    <th><?= __('Package Description / Country') ?></th>
                    <th><?= __('Price 1,000') ?></th>
                </tr>
            </thead>
            <?php
            $interstitial_prices = get_option('interstitial_price');
            $countries = get_countries(true);
            $publisher_prices = [];
            foreach ($interstitial_prices as $key => $value) {
                if (!empty($value['advertiser'])) {
                    $publisher_prices[$key] = $value['publisher'];
                }
            }

            ?>
            <?php foreach ($publisher_prices as $key => $value) : ?>
                <tr>
                    <td><?= $countries[$key] ?></td>
                    <td>$ <?= $value ?></td>
                </tr>
            <?php endforeach; ?>
        </table>
        <?php
        $payoutRates = ob_get_contents();
        ob_end_clean();
        return $payoutRates;
    }
}
