<?php

namespace App\Controller\Member;

use App\Controller\Member\AppMemberController;
use Cake\Event\Event;
use Cake\Network\Exception\NotFoundException;

class LinksController extends AppMemberController
{

    public function initialize()
    {
        parent::initialize();
        $this->loadComponent('Paginator');
    }

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
    }

    public function isAuthorized($user = null)
    {
        // The owner of an article can edit and delete it
        if (in_array($this->request->action, ['edit', 'hide'])) {
            $alias = (string) $this->request->params['pass'][0];
            return $this->Links->isOwnedBy($alias, $user['id']);
        }

        return parent::isAuthorized($user);
    }

    public function index()
    {
        $query = $this->Links->find()
            ->where([
                'user_id' => $this->Auth->user('id'),
                'status' => 'active'
                ]);
        $links = $this->paginate($query);

        $this->set('links', $links);
    }

    public function add()
    {
        $link = $this->Links->newEntity();
        if ($this->request->is('post')) {
            $this->request->data['user_id'] = $this->Auth->user('id');
            $this->request->data['alias'] = $this->Links->geturl();

            $link = $this->Links->patchEntity($link, $this->request->data);

            $link->status = 'active';
            $link->hits = 0;

            if ($this->Links->save($link)) {
                $this->Flash->success(__('Your link has been added.'));
                return $this->redirect(['action' => 'index']);
            } else {
                $this->Flash->error(__('Oops! There are mistakes in the form. Please make the correction.'));
            }
        }
        $this->set('link', $link);
    }

    public function edit($alias = null)
    {
        if (!$alias) {
            throw new NotFoundException(__('Invalid link'));
        }

        $link = $this->Links->findByAlias($alias)->first();
        if (!$link) {
            throw new NotFoundException(__('Invalid link'));
        }

        if ($this->request->is(['post', 'put'])) {
            $this->request->data['user_id'] = $this->Auth->user('id');

            $link = $this->Links->patchEntity($link, $this->request->data);

            if ($this->Links->save($link)) {
                $this->Flash->success(__('Your Link has been updated.'));
                return $this->redirect(['action' => 'edit', $alias]);
            } else {
                //debug( $link->errors() );
                $this->Flash->error(__('Oops! There are mistakes in the form. Please make the correction.'));
            }
        }
        $this->set('link', $link);
    }

    public function hide($alias)
    {
        $this->request->allowMethod(['post', 'delete']);
        
        $link = $this->Links->findByAlias($alias)->first();

        $link->status = 'hidden';

        if ($this->Links->save($link)) {
            $this->Flash->success(__('The Link with id: {0} has been hided.', $alias));
            return $this->redirect(['action' => 'index']);
        }
    }
}
