<?php

namespace App\Controller\Admin;

use App\Controller\AppController;
use Cake\Event\Event;

class AppAdminController extends AppController
{

    public $paginate = [
        'limit' => 10,
        'order' => ['created' => 'DESC']
    ];

    public function beforeFilter(Event $event)
    {
        parent::beforeFilter($event);
        if ($this->Auth->user('role') === 'admin') {
            // Allow all actions
            $this->Auth->allow();
        }
        $this->viewBuilder()->layout('admin');
    }

    public function isAuthorized($user = null)
    {
        // Admin can access every action
        if ($user['role'] === 'admin') {
            return true;
        }
        // Default deny
        return false;
    }
}
