<?php
require_once "engine.php";
class template extends engine
{
	public function loadhead($page_title, $addscript = "")
	{
		$user_username = engine::getuserdata(USER_USERNAME, "*");
		$profile_username = engine::getuserdata(PROFILE_USER, "*");
		$THEME = $user_username['theme'];
		$PROFILE_THEME = $profile_username['theme'];
		$USER_PHOTO = $user_username['photo'];
		$PROFILE_PHOTO = $profile_username['photo'];
		$USER_BG = $user_username['background'];
		$PROFILE_BG = $profile_username['background'];
		$this->addline('<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">');
		$this->addline('<html xmlns="http://www.w3.org/1999/xhtml">');
		$this->addline('<head>');
		$this->addline('<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />');
		$this->addline('<meta name="description" content="'.SITE_DESCRIPTION.'" />');
		if($page_title == "" || strlen($page_title) <= 0) $page_title = ''.template::getlangval(22).''; 
		if(SITE_DOMAIN != "" && strlen(SITE_DOMAIN) > 0) $this->addline('<base href="http://'.SITE_DOMAIN.'/" />');
		$this->addline('<title>'.$page_title.' | '.SITE_NAME.'</title>');
		$this->addline('<link type="image/x-icon" href="media/images/ico.png" rel="icon" />');
		$this->addline('<link type="image/x-icon" href="media/images/ico.png" rel="shortcut icon" />');
		$this->addline('<meta name="keywords" content="'.SITE_KEYWORDS.'" />');
		$this->addline('<meta name="viewport" content="width=device-width" />');
		if(SESSION_STATUS != false)
		{
			if($THEME!="")
			{
				if($THEME=="background") $this->addline("<style type='text/css'>body{background:url(media/images/backgrounds/$USER_BG);background-size:100% 100%;background-attachment:fixed;transition: none;-moz-transition:none;-webkit-transition:none;-o-transition:none}</style>");
				else $this->addline("<link type='text/css' href='media/css/themes/$THEME.css' rel='stylesheet' />");
			}
			if($PROFILE_THEME!="")
			{
				if($PROFILE_THEME=="background") $this->addline("<style type='text/css'>body{background:url(media/images/backgrounds/$PROFILE_BG);background-size:100% 100%;background-attachment:fixed;transition: none;-moz-transition:none;-webkit-transition:none;-o-transition:none}</style>");
				else $this->addline("<link type='text/css' href='media/css/themes/$PROFILE_THEME.css' rel='stylesheet' />");
			}
		}
		else
		{
			if($PROFILE_THEME=="background") $this->addline("<style type='text/css'>body{background:url(media/images/backgrounds/$PROFILE_BG);background-size:100% 100%;background-attachment:fixed;transition: none;-moz-transition:none;-webkit-transition:none;-o-transition:none}</style>");
			else $this->addline("<link type='text/css' href='media/css/themes/$PROFILE_THEME.css' rel='stylesheet' />");
		}
		$this->addline('<link type="text/css" rel="stylesheet" href="media/css/bootstrap.min.css">');
		$this->addline('<link type="text/css" rel="stylesheet" href="media/css/font-awesome.min.css">');
		$this->addline('<link type="text/css" href="media/css/style.css" rel="stylesheet" />');
		$this->addline('<script type="text/javascript" src="media/js/jquery.js"></script>');
		$this->addline('<script type="text/javascript" src="media/js/bootstrap.min.js"></script>');
		$this->addline('<script type="text/javascript" src="media/js/scripts.js"></script>');
		$this->addline('<script type="text/javascript" src="media/js/maxlength.js"></script>');
		$this->addline('<script type="text/javascript" src="media/js/scroll.js"></script>');
		$this->addline('<script type="text/javascript" src="media/js/imgLiquid-min.js"></script>');
		$this->addline('<script type="text/javascript" src="media/js/jstz-1.0.4.min.js"></script>');
		$this->addline('<script type="text/javascript" src="media/js/jquery-ui-1.10.3.custom.min.js"></script>');
		$this->addline('<script type="text/javascript" src="media/js/bootstrap.file-input.js"></script>');
		if($addscript != "")
		{
			$this->addline('<script type="text/javascript">'.$addscript.'</script>');
		}
		if(SESSION_STATUS != false)
		{
			$this->addline('<script type="text/javascript">notifications();</script>');
		}
		$this->addline('</head>');
		$this->addline('<body>');
	}
	
	public function loadend()
	{
		$this->addline('</body>');
		$this->addline('</html>');
	}

	public function loadlogo($type=0)
	{
		if($type==1) $this->addline('<div id="wrapper" class="homebg">');
		else $this->addline('<div id="wrapper">');
		$this->addline('<div class="navsearch">');
		$this->addline('<form method="post" action="search">');
		$this->addline('<input type="hidden" name="searchtype" id="searchtype" value="name">');
		$this->addline('<input type="text" name="query" id="query" size="40" value="" placeholder="'.template::getlangval(11).'">');
		$this->addline('<input type="submit" value="Search" class="button" id="searchSubmit">');
		$this->addline('</form>');
		$this->addline('</div>');
		$this->addline('<div id="header">');
		$this->addline('<div id="headercontent">');
		$this->addline('<div id="logo">');
		$this->addline('<a href="http://'.SITE_DOMAIN.'/"><img src="media/images/logo.png" alt="'.SITE_NAME.'" /></a>');
		$this->addline('</div>');
		$this->addline('<i class="fa fa-search fa-2x" onclick="javascript:toogle_search();"></i>');
		if(SESSION_STATUS != true)
		{
			$this->addline('<a href="people"><i class="fa fa-user fa-2x"></i></a>');
		}
	}
	
	public function loadmenu()
	{
		if(SESSION_STATUS != false)
		{
			if(SITE_MAINTENANCE == 0)
			{
				$this->addline('<a href="site/stream"><i class="fa fa-users fa-2x"></i></a>');
				if(SESSION_STATUS != false && SITE_MAINTENANCE == 0)
				{
					$this->addline('<a onclick="opennotification(2);"><i class="fa fa-comment-o fa-2x nposts"></i></a><span class="not2"></span>');
					$this->addline('<a onclick="opennotification(3);"><i class="fa fa-reply fa-2x nanswers"></i></a><span class="not3"></span>');
					$this->addline('<a onclick="opennotification(1);"><i class="fa fa-heart fa-2x nlikes"></i></a><span class="not1"></span>');
				}
				$this->addline('<a href="people"><i class="fa fa-user fa-2x"></i></a>');
				$this->addline('<a href="account/settings"><i class="fa fa-cogs fa-2x"></i></a>');
				$this->addline('<a href="account/logout"><i class="fa fa-power-off fa-2x"></i></a>');	
				
				if(engine::getuserrights("ADM") != false || engine::getuserrights("MOD") != false)
				{
					if(engine::getuserrights("FREE_HM_ACCESS") != false)
					{
							$this->addline('<a href="administration/index.php"><i class="fa fa-database fa-2x"></i></a>');
					}
				}
			}
		}
		$this->addline('<div class="clear"></div></div></div><div style="height:100px"></div>');
	}
	
	public function showerror($error_title, $error_message)
	{
		die('<center><h1>'.$error_title.'</h1><p>'.$error_message.' </div><div id="footer"><ul id="footernav"><li><a href="./site/privacy">'.template::getlangval(23).'</a></li><li><a href="./site/terms">'.template::getlangval(24).'</a></li></ul><div class="clear"></div></div></body></html>');
	}
	
	public function loadtpl($template, $folder = "tpl", $file_type = "tpl")
	{
		$filename = dirname(__FILE__).'/'.$folder.'/'.$template.'.'.$file_type.'';
		if(file_exists($filename) != FALSE)
		{
			if(pathinfo($filename, PATHINFO_EXTENSION) == "tpl")
			{
				require_once(dirname(__FILE__).'/'.$folder.'/'.$template.'.'.$file_type.'');
			}
		}
		else
		{
			$this->showerror(''.template::getlangval(26).'', ''.template::getlangval(27).' <b>'.$template.'.tpl</b> '.template::getlangval(28).'<br>'.template::getlangval(29).' <br>');
		}
	}
	
	public function addline($text)
	{
		echo(''.$text.'');
	}
	
	public function setparameter($var, $value, $boolean)
	{
		$parameter = define("$var", "$value", $boolean);
		return $parameter;
	}
	
	public function getlangval($request_id, $folder = "lang")
	{
		if($_COOKIE['lang']) 	@include (dirname(__FILE__).'/'.$folder.'/'.$_COOKIE['lang'].'.php');
		else					@include (dirname(__FILE__).'/'.$folder.'/en.php');
		return $arr[''.$request_id.''];
	}

	public function addscroll($nr,$user,$offset)
	{
		$this->addline('<script>');
		$this->addline('$(document).ready(function() {');
		$this->addline('	$("#wrapper").scrollPagination({');
		$this->addline('		nop     : '.$nr.',');
		$this->addline('		user  	: "'.$user.'",');		
		$this->addline('		offset  : '.$offset.',');
		$this->addline('		error   : "'.getLanguage(421,1).'",');
		$this->addline('		delay   : 100,');
		$this->addline('		scroll  : true');
		$this->addline('	});');
		$this->addline('});');
		$this->addline('</script>');
	}
}
?>