 $(document).ready(function() {

        /* Search on enter code */
         $("#q").keyup(function(e){
              if (e.keyCode === 13) {
                url =  app.domain + 'search/string/' + document.getElementById('q').value;  
                window.location = url;
              }
         });

        /* Initing the radio tooltips */
        initThumbnails();
        $( document ).ajaxComplete(function() {
          initThumbnails();
        });

        /* The initial player init */
        $("[rel='tooltip']").tooltip(); 
        playStream();
        initPlayBtn()

    });


   function initPlayBtn(){
       /* Playing stream button actions */ 
       $('.playStreamBtn').on('click',function(){
           radioBox = $(this).parent().parent();
           radioName = $(radioBox).find('h4 a').html();
           radioStream = $(radioBox).find('.streamUrl').val();
           playStream(radioName,radioStream,true);
       });
   }

    function switch_tabs(obj)
    {
        $('.tab-content').hide();
        $('.tabs button').removeClass("selected");
        var id = obj.attr("rel");
     
        $('#'+id).show();
        obj.addClass("selected");
    }

    function showMore(type){
        
        activeUrl = window.location.href;

        if(activeUrl.indexOf('search') >= 0){
           tempUrl = activeUrl.split('/');
           term    = tempUrl[tempUrl.length - 1];
        }
        else if (activeUrl.indexOf('categories') >= 0){
           tempUrl = activeUrl.split('/');
           term    = tempUrl[tempUrl.length - 2];
        }
        else if (activeUrl.indexOf('countries') >= 0){
           tempUrl = activeUrl.split('/');
           term    = tempUrl[tempUrl.length - 2];
        }
        else{
            return;
        }

        app.listOffset++;
        loading.start();
        $.post(app.domain + 'php/ajax.php?r=gmr',{listOffset: app.listOffset, gmrType : type, string:term}).done(function(data){
            data = JSON.parse(data); 
            if(data.count){
                $(data.html).insertBefore('.loadMoreBtn:parent');
                initPlayBtn();
            }
            else{
                $('.loadMoreBtn').attr('onClick','javascript:void(0);');
                $('.loadMoreBtn').html('No more results to show');
                $('.loadMoreBtn').addClass('disabled');
            }
            loading.stop();
            
        }); 
    }

 loading = {
     start: function() {
            var over = '<div id="overlay">' +
                '<img id="loading" src="'+app.domain+'img/ajax-loader.gif">' +
                '</div>';
            $(over).appendTo('body');
            $(document).keyup(function(e) {
                if (e.which === 27) {
                    $('#overlay').remove();
                }
            });
        },
        stop: function(){
            $('#overlay').remove();
        }
 }

function initThumbnails(){
            $('.thumbnail').hover(
            function(){
                $(this).find('.caption').fadeIn(250);
            },
            function(){
                $(this).find('.caption').fadeOut(250);
            }
        );  
}

function playStream(name,stream,autoplay){
            if(typeof name == 'undefined' && typeof stream == 'undefined'){
                var stream = {
                    title: "Los Megaexitos",
                    mp3: "http://listen.radionomy.com/losmegaexitos"
                }
            }
            else{
                var stream = {
                    title: name,
                    mp3: stream
                }
            }
            ready = false;

            $("#theRadioPlayer").jPlayer("destroy");
            $("#theRadioPlayer").jPlayer({
                ready: function (event) {
                    ready = true;
                    if(typeof autoplay == 'undefined'){
                        $(this).jPlayer("setMedia", stream);
                    }else{
                        $(this).jPlayer("setMedia", stream).jPlayer("play");
                    }
                    
                },
                pause: function() {
                    $(this).jPlayer("clearMedia");
                },
                error: function(event) {
                    if(ready && event.jPlayer.error.type === $.jPlayer.error.URL_NOT_SET) {
                        // Setup the media stream again and play it.
                        $(this).jPlayer("setMedia", stream).jPlayer("play");
                    }
                },
                swfPath: "../dist/jplayer",
                supplied: "mp3",
                preload: "none",
                wmode: "window",
                useStateClassSkin: true,
                autoBlur: false,
                keyEnabled: true
            });

}