<?php
/**
 * ajax -> data -> audio
 * 
 * @package Sngine v2+
 * @author Zamblek
 */

// fetch bootstrap
require('../../../bootstrap.php');

// check AJAX Request
is_ajax();

// check secret
if($_SESSION['secret'] != $_POST['secret']) {
    _error(403);
}

// check user logged in
if(!$user->_logged_in) {
    modal(LOGIN);
}

// check user activated
if($system['email_send_activation'] && !$user->_data['user_activated']) {
    modal(MESSAGE, __("Not Activated"), __("Before you can interact with other users, you need to confirm your email address"));
}

// check audio upload enabled
if(!$system['audio_enabled']) {
    modal(MESSAGE, __("Not Allowed"), __("This feature has been disabled"));
}

// valid inputs
if(!isset($_FILES["file"]) || $_FILES["file"]["error"] != UPLOAD_ERR_OK) {
    modal(MESSAGE, __("Upload Error"), __("Something wrong with upload! Is 'upload_max_filesize' set correctly?"));
}

// check file size
$max_allowed_size = $system['max_audio_size'] * 1024;
if($_FILES["file"]["size"] > $max_allowed_size) {
    modal(MESSAGE, __("Upload Error"), __("The file size is so big"));
}


// check file extesnion
$extension = get_extension($_FILES['file']['name']);
if(!valid_extension($extension, $system['audio_extensions'])) {
    modal(MESSAGE, __("Upload Error"), __("The file type is not valid or not supported"));
}

// upload
try {

    /* check & create uploads dir */
    $depth = '../../../';
    $folder = 'sounds';
    if(!file_exists($depth.$system['system_uploads_directory'].'/'.$folder)) {
        @mkdir($depth.$system['system_uploads_directory'].'/'.$folder, 0777, true);
    }
    if(!file_exists($depth.$system['system_uploads_directory'].'/'.$folder.'/' . date('Y'))) {
        @mkdir($depth.$system['system_uploads_directory'].'/'.$folder.'/' . date('Y'), 0777, true);
    }
    if(!file_exists($system['system_uploads_directory'].'/'.$folder.'/' . date('Y') . '/' . date('m'))) {
        @mkdir($depth.$system['system_uploads_directory'].'/'.$folder.'/' . date('Y') . '/' . date('m'), 0777, true);
    }

    /* prepare new file name */
    $directory = $folder.'/'. date('Y') . '/' . date('m') . '/';
    $prefix = $system['uploads_prefix'].'_'.md5(time()*rand(1, 9999));
    $file_name = $directory.$prefix.'.'.$extension;
    $path = $depth.$system['system_uploads_directory'].'/'.$file_name;

    /* check if the file uploaded successfully */
    if(!@move_uploaded_file($_FILES['file']['tmp_name'], $path)) {
        modal(MESSAGE, __("Upload Error"), __("Sorry, can not upload the file"));
    }

    // return the file new name & exit
    return_json(array("file" => $file_name));

} catch (Exception $e) {
    modal(ERROR, __("Error"), $e->getMessage());
}
    
?>