/**************
 *
 * SFS V1.6.3
 *  sfs.js 1.6.3
 *  February 22nd 2014
 *
 * TOC
 *  1. some helperlies
 *  2. Get Variables-Values-Parser
 *  3. some essential PHP-Values into JS Variables
 *  4. Contact form
 *  5. File uploader
 *  6. Admin-login Autofocus
 *  7. Admin: Datatables
 *  8. Admin: Flot Charts
 *  9. Wait X Seconds before download Countdowner
 * 10. SINGLE: Password protect download links
 * 11. Verify password protected download links 
 * 12. Abuse form
 * 13. MULTI: Password protect download links
 * 14. Filesgroup options
 * 15. don't leave site willy-nilly
 * 16. prevent of re-clicking download button
 * 17. SINGLE: autodelete after X days - set by uploader
 * 18. MULTI: autodelete after X days - set by uploader
 *
 **************/


 $(document).ready(function() { 

   /******
   * 1. Some helperlies [+]
   ******/ 
    //object dumper
    function dump(obj) {
      var op = '';
      for (var i in obj) {
          op += i + ": " + obj[i] + "\n";
      }
     alert(op);
    }
    //checks if value in array
    function in_array(needle,arr) {
      for(i=0;i<arr.length;i++) {
        if (needle == arr[i]) {
          return true;
        }
      }
      return false;
    }

    //get JS working directory (relative to installation directory)
    function dirname(path) {
      if (!path) return false;
      return path.replace(/\\/g,'/').replace(/\/[^\/]*$/, '');;
    }
    function basename(path) {
      if (!path) return false;
      return path.replace(/\\/g,'/').replace( /.*\//, '' );
    }
    function setRelDir(cwd) {
      if (!cwd) return "";
      if (cwd == "download" || cwd == "filesgroup") return "../";
      return "";
    }
    var relDir = setRelDir(basename(dirname(document.location.pathname)));

    //get human readable filesizes
    function fsize(size) {
      size = parseInt(size);
      kb = 1024;
      mb = kb*1024;
      gb = mb*1024;
      tb = gb*1024;
      pb = tb*1024;
      if (size < kb) return size + " B";
      else if (size < mb) return Math.round(100*size/kb)/100 + " KB";
      else if (size < gb) return Math.round(100*size/mb)/100 + " MB";
      else if (size < tb) return Math.round(100*size/gb)/100 + " GB";
      else if (size < pb) return Math.round(100*size/tb)/100 + " TB";
      else return Math.round(100*size/pb)/100 + " PB";
    }
   /******
   * 1. Some helperlies [-]
   ******/ 

  /******
   * 2. Get Variables-Values-Parser [+]
   ******/
  function getGetVars(url,varName){
    var urlA = url.split("?"); 
    var vars = urlA[1].split("&"); 
    for (var i=0;i<vars.length;i++) {   
          var pair = vars[i].split("=");
          //remove anchor
          if(pair[0] == varName) {
            return pair[1].replace(/#.*$/,'');
          }
     }
  }
  /******
   * 2. Get Variables-Values-Parser [-]
   ******/

  
  /******
   * 3. some essential PHP-Values into JS Variables [+]
   ******/
  var jsVars
  $.ajax({
    url: relDir + "js.vars.php",
    type: 'get',
    dataType: 'json',
    async: false,
    success: function(data) {
        jsVars = data;
    }
  });

 /******
  * 3. some essential PHP-Values into JS Variables [-]
  ******/


  /******
   * 4. Contact form [+]
   ******/
  $("form#contactf").submit(function() {
    $("#cnote").slideUp();
    var str = $(this).serialize();
    $.ajax({
      type: "POST",
      url: "functions.ajax.php",
      data: str,
      success: function(msg){ 
        if(msg == 'OK') {
          $("#cnote").html('<div class="alert alert-success">' + jsVars.lang_success_mess_sent + '<\/div>');
          $("#cnote").slideDown();
          $("form#contactf").fadeOut();
        } else {
          $("#cnote").html(msg);
          $("#cnote").slideDown();
        }
      }
    });
    return false;
  });
  /******
   * 4. Contact form [-]
   ******/


  /******
   * 5. File uploader [+]
   ******/
  if ($("#fileupload").length) {
    $(document).bind('drop dragover', function (e) {
        e.preventDefault();
    });
    $(function () {
      var DownLink; var DelLink;var abortCnt = 0;
      $("#fileupload").fileupload({
        formData: {u_key: $("input[name='u_key']").val()},
        add: function (e, data) {
            var extErrors = new Array(); var sizeErrors = new Array(); var extAllowedErrors = new Array(); 
            $.each(data.originalFiles, function (index, file) {
                //extensions check - for all
                var ext = file.name.split(".").pop().toLowerCase();
                if (jsVars.extDenied.length && ext && in_array(ext,jsVars.extDenied)) {
                  extErrors.push(file.name);
                }
                if (jsVars.extAllowed.length && ext && !in_array(ext,jsVars.extAllowed)) {    
                  extAllowedErrors.push(file.name);
                }
                //filesize check for all
                if (file.size > jsVars.maxFileSizeB) {
                 sizeErrors.push(file.name);
              }
            });
            filesCount = data.originalFiles.length;
            if (!jsVars.multiUpload && filesCount > 1) {
                $.pnotify({title: "File Count Error",text: jsVars.lang_error_just_one_file, type: "error"});
                return false;
            } else if (jsVars.multiUpload && filesCount > jsVars.maxMultiFiles) {
                $.pnotify({title: "File Count Error",text: jsVars.lang_error_max_files, type: "error"});
                return false;
            } else if (sizeErrors.length) {
              if (filesCount > 1) $.pnotify({title: "File Size Error",text: jsVars.lang_error_max_size_multi + sizeErrors.join(", "),type: "error"});
              else $.pnotify({title: "File Size Error",text: jsVars.lang_error_max_size,type: "error"});
              return false;
            } else if (extErrors.length) {
              if (filesCount > 1) $.pnotify({title: "File Extension Error",text: jsVars.lang_error_extension_denied_multi + extErrors.join(", "),type: "error"});
              else $.pnotify({title: "File Extension Error",text: jsVars.lang_error_extension_denied,type: "error"});
              return false;
            } else if (extAllowedErrors.length) {                
              if (filesCount > 1) $.pnotify({title: "File Extension Error",text: jsVars.lang_error_extension_denied_multi + extAllowedErrors.join(", "),type: "error"});
              else $.pnotify({title: "File Extension Error",text: jsVars.lang_error_extension_denied,type: "error"});
              return false;
            } else {
              var uploader = data.submit();
            }
            $('button.cancelUpload').click(function (e) {
              abortCnt++;
              if(typeof uploader != 'undefined') {
                uploader.abort();
                if (!abortCnt) $.pnotify({title: "Upload Aborted",type: "warning"});
                return false;
              }
          });
        },
        start: function (e) {
          $(".fileinput-button").fadeOut(function() { $(".cancelUpload").fadeIn() } );
          $("#uploadInfo").slideUp(function() {$("#progress").fadeIn();});
        },
        dataType: "json",
        progressall: function (e, data) {
            var progress = parseInt(data.loaded / data.total * 100, 10);
            $("#progress .bar").css("width",progress + "%");
            if ($("div.visible-phone").is(":visible")) {
              $("#progress .pct").html(fsize(data.loaded) + " / " + fsize(data.total));
            } else {
              $("#progress .pct").html(progress + "% <small>" + fsize(data.loaded) + " / " + fsize(data.total) + "</small>");
            }
        },
        stop: function () {
          if (!abortCnt) {
            $("#landingInfoRow").fadeOut();
            if (filesCount > 1) {
                $("#singleUploader").fadeOut(function(){$("#multiUploadSucceeded").fadeIn()});
            }
          } else {
            $("#progress,button.cancelUpload").fadeOut( function() { $(".fileinput-button").fadeIn(); $("#uploadInfo").slideDown()});
            abortCnt = 0;
          }
          // $.pnotify({title: "Upload success",text: "all files upped",type: "success"});
        },
        done: function (e, data) { //each file done
          if (!abortCnt) {
            $.each(data.result.files, function (index, file) {
              $.pnotify({title: "Upload success",text: file.realName + " upped",type: "success"});
              var DownLink = jsVars.baseDownloadUrl + file.fileKey + ".html";
              var DelLink = jsVars.baseDeleteUrl + file.delFileKey + ".html";
              if (filesCount == 1) {
                $("#singleUploadSucceeded .susFName").html(file.realName + " <span>" + file.niceSize + "</span>");
                $("#singleUploadSucceeded input[name='susDownloadLink']").val(DownLink);
                $("#singleUploadSucceeded input[name='susDeleteLink']").val(DelLink);                  
                $("#singleUploadSucceeded button.btndown").click( function() { window.open(DownLink); return false; } );
                $("#singleUploadSucceeded button.btndel").click( function() { window.open(DelLink); return false; } );
                $("#singleUploader").fadeOut(function(){$("#singleUploadSucceeded").fadeIn()});
              } else {
                var multiItem = $("#multiUploadSucceeded .multiItem.hide").clone();
                $(multiItem).find(".musFName").html(file.realName + " <span>" + file.niceSize + "</span>");
                $(multiItem).removeClass("hide");
                $(multiItem).find("input[name='musDownloadLink']").val(DownLink);
                $(multiItem).find("input[name='musDeleteLink']").val(DelLink);                  
                $(multiItem).find("button.btndown").click( function() { window.open(DownLink); return false; } );
                $(multiItem).find("button.btndel").click( function() { window.open(DelLink); return false; } );
                $(multiItem).find("input[name='musDownloadLink']").click( function(){ $(this).select(); } );
                $(multiItem).find("input[name='musDeleteLink']").click( function(){ $(this).select(); } );
                $("#multiUploadSucceeded .multiItems").append(multiItem);
              }
            });
          }
        }
      });
      $("#singleUploadSucceeded input[name='susDownloadLink'],#singleUploadSucceeded input[name='susDeleteLink'],#multiUploadSucceeded input[name='musGroupLink']").click( function(){ $(this).select(); } );
      $("#multiUploadSucceeded button.btngrp").click( function() { window.open($("#multiUploadSucceeded input[name='musGroupLink']").val()); return false; } );

      $("#agree2terms").change(function() {
        if ($(this).is(":checked")) {
          $(".sendLinkInfo").attr("disabled",false);
        } else {
          $(".sendLinkInfo").attr("disabled",true);
        }
     });
      $("#agree2termsMulti").change(function() {
        if ($(this).is(":checked")) {
          $(".sendLinkInfoMulti").attr("disabled",false);
        } else {
          $(".sendLinkInfoMulti").attr("disabled",true);
        }
     });

      /****** increase sharing form for MULTI and SINGLE uploads ******/
      $(".addmessage").on("click", function() {
        $(this).fadeOut("fast",
          function() {
            $("textarea[name='message']").fadeIn();
          });
        return false;
      });

      /****** SINGLE Send Linkinfos to sender and receipient ******/
      $(".sendLinkInfo").on("click",function () {
        $("#singleUploadSucceeded .sendLinkMsgs").hide();

        var DownLink = $("#singleUploadSucceeded input[name='susDownloadLink']").val();
        var DelLink = $("#singleUploadSucceeded input[name='susDeleteLink']").val();
        var mailFrom = $("#singleUploadSucceeded input[name='mailFrom']").val();
        var mailTo = $("#singleUploadSucceeded input[name='mailTo']").val();
        var message = $("#singleUploadSucceeded textarea[name='message']").val();

        if (mailTo && mailFrom) {
          $.ajax({
           type: "POST",
           url: "functions.ajax.php",
           data: {"action":"sendFileInfo","DownLink":DownLink,"DelLink":DelLink,"mailFrom":mailFrom,"mailTo":mailTo,"message":message},
           success: function(msg){
            if(msg == "OK") {
              $("#sendLinkInfoForm").append("<div class='alert alert-success hide span8 mt20 successmess'><button type='button' class='close'>&times;</button>" + jsVars.lang_success_info_sent + "</div>");
              $("#sendLinkInfoForm form").fadeOut( function() {
                $("#sendLinkInfoForm .successmess").fadeIn();
              });
              $("#singleUploadSucceeded .close").on("click", function() {
                $("#singleUploadSucceeded input[name='mailFrom']").val("");
                $("#singleUploadSucceeded input[name='mailTo']").val("");
                $("#singleUploadSucceeded textarea[name='message']").val("").hide();
                $("#agree2terms").attr("checked",false);
                $(".sendLinkInfo").attr("disabled",true);
                $(this).parent().fadeOut();
                $(".addmessage").fadeIn();
                $("#sendLinkInfoForm form").fadeIn();
                $(this).parent().remove();
              });
            } else {
              $("#singleUploadSucceeded .sendLinkMsgs").text(msg);
              $("#singleUploadSucceeded .sendLinkMsgs").fadeIn();
            }
          }
         });
        } else {
           $("#singleUploadSucceeded .sendLinkMsgs").text(jsVars.lang_error_both_fields_required);
           $("#singleUploadSucceeded .sendLinkMsgs").fadeIn();
        }
        return false;
      });

      /****** MULTI Send Linkinfos to sender and receipient ******/
      $(".sendLinkInfoMulti").on("click",function () {
        $("#multiUploadSucceeded .sendLinkMsgs").hide();

        var mailFrom = $("#sendLinkInfoFormMulti input[name='mailFrom']").val();
        var mailTo = $("#sendLinkInfoFormMulti input[name='mailTo']").val();
        var message = $("#sendLinkInfoFormMulti textarea[name='message']").val();
        var u_key = $("#sendLinkInfoFormMulti input[name='multi_u_key']").val();

        if (mailTo && mailFrom) {
          $.ajax({
           type: "POST",
           url: "functions.ajax.php",
           data: {"action":"sendMultiFileInfo","u_key":u_key,"mailFrom":mailFrom,"mailTo":mailTo,"message":message},
           success: function(msg){
            if(msg == "OK") {
              $("#sendLinkInfoFormMulti").append("<div class='alert alert-success hide span8 mt20 successmess'><button type='button' class='close'>&times;</button>" + jsVars.lang_success_info_sent + "</div>");
              $("#sendLinkInfoFormMulti form").fadeOut( function() {
                $("#sendLinkInfoFormMulti .successmess").fadeIn();
              });
              $("#multiUploadSucceeded .close").on("click", function() {
                $("#multiUploadSucceeded input[name='mailFrom']").val("");
                $("#multiUploadSucceeded input[name='mailTo']").val("");
                $("#multiUploadSucceeded textarea[name='message']").val("").hide();
                $("#agree2termsMulti").attr("checked",false);
                $(".sendLinkInfoMulti").attr("disabled",true);
                $(this).parent().fadeOut();
                $(".addmessage").fadeIn();
                $("#sendLinkInfoFormMulti form").fadeIn();
                $(this).parent().remove();
              });
            } else {
              $("#multiUploadSucceeded .sendLinkMsgs").text(msg);
              $("#multiUploadSucceeded .sendLinkMsgs").fadeIn();
            }
          }
         });
        } else {
           $("#multiUploadSucceeded .sendLinkMsgs").text(jsVars.lang_error_both_fields_required);
           $("#multiUploadSucceeded .sendLinkMsgs").fadeIn();
        }
        return false;
      });


    });
  }
  /******
   * 5. File uploader [-]
   ******/


  /******
   * 6. Admin-login Autofocus  [+]
   ******/
  if ($("#loginF").length) {
    if (!$("input[name='user']").val()) {
      $("input[name='user']").focus();
    } else {
      $("input[name='pass']").focus();
    }
  }
  /******
   * 6. Admin-login Autofocus  [-]
   ******/


  /******
   * 7. Admin: Datatables  [+]
   ******/
  if ($("table#filesDataTable").length) {
    /****** the datatable ******/
    var oTable = $('#filesDataTable').dataTable( {
        "bProcessing": true,
        "bServerSide": true,
        "sAjaxSource": "files.data.php",
        "aaSorting": [[ 0, "desc" ]],
        "sDom": "<'row'<'span6'l><'span6'f>r>t<'row'<'span6'i><'span6'p>>",
        "sPaginationType": "bootstrap",
        "oLanguage": {
          "sProcessing": "<i class='icon-time'></i> Loading Files Data"
        },
        "aoColumns": [
          { "sWidth": "50px"},
          {  },
          { "sWidth": "120px"},
          { "sWidth": "180px" },
          { "sWidth": "100px"},
          { "sWidth": "125px", "sClass": "tac"},
        ],
        "aoColumnDefs": [
          { "bSearchable": false, "aTargets": [0,2] },
          { "bSortable": false, "aTargets": [0,5] } ],
        "fnDrawCallback": function() {
          $('.dataTables_filter input').attr("placeholder","minlength:3");
          /****** admin function:delete file ******/
          $(".delFile").click( function() {
            var indexOfRow = oTable.fnGetPosition( $(this).closest('tr').get(0) );
            var url = $(this).attr("href");
            var fid = getGetVars(url,"fid");
            var thisTR = $(this).closest('tr');

            $(thisTR).addClass("warning");

            function delFile(fid,indexOfRow) {
              $.ajax({
                 type: "POST",
                 url: "functions.ajax.php",
                 data: {"action":"delFile","fid":fid},
                 success: function(msg) {
                  if(msg == "OK") {
                    $.pnotify({title: "Operations completed",text: "The file was removed successfully.", type: "success"});
                    oTable.fnDeleteRow( indexOfRow );
                  } else {
                    $.pnotify({title: "Errors occurred",text: msg, type: "error"});
                  }
                }
              });
            }
            if ($("#TempbypassConfirming").is(":checked")) {
              delFile(fid,indexOfRow);
              return false;
            }
            bootbox.confirm("<h4>Are you sure to delete this file?</h4><p>This Action cannot be undone!<br /><br /><label class='checkbox'><input type='checkbox' name='bypassConfirming' id='bypassConfirming' value='1' />Don't ask again for this action for the next times.</label></p>", 
              function(stat) {
                if (stat) {
                  if ($("#bypassConfirming").is(":checked")) {
                    $("#TempbypassConfirming").prop("checked",true);
                  }
                  delFile(fid,indexOfRow);
                } else {
                  $(thisTR).removeClass("warning");            
                }
            });
            return false;
          });
        }
      });
    /****** searchform Class ******/
    $.extend( $.fn.dataTableExt.oStdClasses, {
      "sWrapper": "dataTables_wrapper form-inline"
    });
  }
  /******
   * 7. Admin: Datatables  [-]
   ******/


  /******
   * 8. Admin: Flot Charts [+]
   ******/
  if ($(".flot").length) {
    /****** fill jsvars with charts data ******/
    var chartsData;
    $.ajax({
      url: "charts.data.php",
      type: 'get',
      dataType: 'json',
      async: false,
      success: function(data) {
          chartsData = data;
      }
    });
    /****** filetypes - PieDonut Chart ******/
    if (chartsData.pieData != null) {
      $.plot($('#filetypes .flot'), chartsData.pieData, {
        grid : { hoverable : false }, 
        series : { pie: { show: true, radius: 1, tilt: 0.5, innerRadius: 0.5, label: { show: true, background: { color: "#fff", opacity: 0.8 }, formatter: function(label) { return "<div class='flotdescr'>" + label + "</div>"; } } } },
        yaxis: {tickDecimals:0, max: 6214.8}, legend: {noColumns:4,margin:0,backgroundColor:'#efefef'}
      });
    }
   
    /****** Uploads and Sizes - Linegraph ******/
    if (chartsData.lineData != null) {
      $("#updownloads").css("padding","0 25px");
      $.plot($('#updownloads .flot'), chartsData.lineData, { 
            xaxis: {ticks: chartsData.lineXticks,tickDecimals:0 }
      });
    }
    /****** tab hiding of inactive ones, they have to be active for flot printing first ******/
    var cnt = 0;
    $(".SFSCharts div.tab-pane").each( function() {
      if (cnt) {
        $(this).removeClass("active");  
      }
      cnt++;
    });
    /****** tab functionality ******/
    $('#ChartTabs a').click(function (e) {
        e.preventDefault();
        $(this).tab('show');
      });
  }
  /******
   * 8. Admin: Flot Charts [-]
   ******/


  /******
   * 9. Wait X Seconds before download Countdown [+]
   ******/
   if ($(".btn-download #dlCD").length && jsVars.downloadSeconds > 0) {
    $(".btn-download").click(function() {
     if ($(this).hasClass("disabled")) return false;
    });
    var dwnBtn = $(".btn-download");
    var dwnBtnText = $(".btn-download .dwnin");
    $('#dlCD span').countDown({
        startFontSize: 8,
        endFontSize: 17.5,
        startNumber: jsVars.downloadSeconds,
        callBack: function(me) {
          $(dwnBtn).removeClass("disabled");
          $(dwnBtn).find("i").attr("class","icon-chevron-down icon-white");
          $(dwnBtnText).text("Download");
        }
      });
   }
  /******
   * 9. Wait X Seconds before download Countdown [-]
   ******/


  /******
   * 10. SINGLE: Password protect download links [+]
   ******/
  $("input#passwordProtection").change(function() {
    $(".susPassword").removeClass("muted text-error text-info").hide();
    var pwdProtection = $(this).is(":checked");
    var downloadLink = $("input[name='susDownloadLink']").val();
    $.ajax({
       type: "POST",
       url: "functions.ajax.php",
       dataType: 'json',
       async: false,
       data: {"action":"pwdProtection","downloadLink":downloadLink,"protection":pwdProtection},
       success: function(msgObj) {
        if (msgObj.error) {
          $(".susPassword").text(msgObj.error);
          $(".susPassword").addClass("text-error").fadeIn();
        } else {
          $(".susPassword").text(msgObj.statmess);
          if (msgObj.protection == 1) $(".susPassword").addClass("text-info").fadeIn();
          else $(".susPassword").addClass("muted").fadeIn();
        }
      }
     });
  });
  /******
   * 10. SINGLE: Password protect download links [-]
   ******/


  /******
   * 11. Verify password protected download links [+]
   ******/
  $(".btn-download.pwd-protected").click(function() {
    if ($(this).hasClass("disabled")) return false;
    var downloadLink = $(this).attr("href");
    bootbox.dialog("<h4>" + jsVars.lang_password_modal_hl + "</h4>&nbsp;<br /><div class='form-horizontal'>"+
      "<div class='text-center pwdChecker'><div class='alert alert-error hide'></div><input type='password' name='password' placeholder='" + jsVars.lang_password_modal_placeholder + "' required class='superSize-input'/></div></div>",
     [
      {"label" : jsVars.lang_cancel, "class" : "btn", "callback": function() { return true; } },
      {"label" : jsVars.lang_verify_pwd, "class" : "btn-primary submitData", "callback": function() { 

          $(".pwdChecker .alert").hide();

          var proceed = false;
          var pwd = $(".modal-body input[name='password']").val();
          if (!pwd) {
            $('.pwdChecker .alert').text(jsVars.lang_error_enter_password).fadeIn();
          } else {
            $.ajax({
             type: "POST",
             url: relDir + "functions.ajax.php",
             dataType: 'json',
             async: false,
             data: {"action":"verifyPwd","downloadLink":downloadLink,"pwd":pwd},
             success: function(msgObj) {
              if (msgObj.error) {
                $('.pwdChecker .alert').text(msgObj.error).fadeIn();
              } else {
                if (msgObj.verified) {
                  window.location.href=downloadLink;
                  proceed = true;
                } else {
                  $('.pwdChecker .alert').text("something went wrong?!?").fadeIn();
                }
              }
            }
           });
          }
          return proceed;
        } 
      }
     ]);
    return false;
  });
  /******
   * 11. Verify password protected download links [-]
   ******/


  /******
   * 12. Abuse form [+]
   ******/
  $("form#abusef").submit(function() {
    $("#cnote").slideUp();
    var str = $(this).serialize();
    $.ajax({
      type: "POST",
      url: "functions.ajax.php",
      data: str,
      success: function(msg){ 
        if(msg == 'OK') {
          $("#cnote").html('<div class="alert alert-success">' + jsVars.lang_success_mess_sent + '<\/div>');
          $("#cnote").slideDown();
          $("form#abusef").fadeOut();
        } else {
          $("#cnote").html(msg);
          $("#cnote").slideDown();
        }
      }
    });
    return false;
  });
  /******
   * 12. Abuse form [-]
   ******/


  /******
   * 13. MULTI: Password protect download links [+]
   ******/
  $("input#passwordProtectionMulti").change(function() {
    $(".musPassword").removeClass("muted text-error text-info").hide();
    var pwdProtection = $(this).is(":checked");
    var u_key = $("input[name='u_key']").val();
    $.ajax({
       type: "POST",
       url: "functions.ajax.php",
       dataType: 'json',
       async: false,
       data: {"action":"pwdProtectionMulti","u_key":u_key,"protection":pwdProtection},
       success: function(msgObj) {
        if (msgObj.error) {
          $(".musPassword").text(msgObj.error);
          $(".musPassword").addClass("text-error").fadeIn();
        } else {
          $(".musPassword").text(msgObj.statmess);
          if (msgObj.protection == 1) $(".musPassword").addClass("text-info").fadeIn();
          else $(".musPassword").addClass("muted").fadeIn();
        }
      }
     });
  });
  /******
   * 13. MULTI: Password protect download links [-]
   ******/


  /******
   * 14. Filesgroup - options [+]
   ******/
  $(".filesgroup input.gDownloadLink").click( function(){ $(this).select(); } );
  $(".filesgroup button.btndown").click( function() { window.open($(this).parent().find("input.gDownloadLink").val()); return false; } );
  /******
   * 14. Filesgroup - options [-]
   ******/


  /******
   * 15. don't leave site willy-nilly [+]
   ******/
  $(window).bind("beforeunload",function(event) {
     if ($("#singleUploadSucceeded,#multiUploadSucceeded").is(":visible")) return jsVars.lang_leaving_site_info;
  });
  /******
   * 15. don't leave site willy-nilly [-]
   ******/


  /******
   * 16. prevent of re-clicking download button [+]
   ******/
  $(".download-button-wrapper .btn-download").click(function() {
    if ($(this).hasClass("disabled")) return false;
    else {
      $(this).addClass("disabled").html(jsVars.lang_download_has_started).removeClass("btn-success").blur();
      if ($(this).hasClass("pwd-protected")) return true;
      if (jsVars.isMSIE) {
        window.location.href=$(this).attr("href"); 
        return false;
      } else {
        return true;
      }
    }
    return false
  });
  /******
   * 16. prevent of re-clicking download button [-]
   ******/


  /******
   * 17. SINGLE: autodelete after X days or downloads - set by uploader [+]
   ******/
  $(".delXdays,.delXdownloads").fadeTo(0,0.5);

  //days
  $("select[name='delXdays']").change(function() {
    var delXdays = $(this).val();
    var downloadLink = $("input[name='susDownloadLink']").val();
    $(".delXdays").fadeTo("fast",delXdays == -1 ? 0.5 : 1);
    $.ajax({
       type: "POST",
       url: "functions.ajax.php",
       dataType: 'json',
       async: false,
       data: {"action":"setDelXdays","downloadLink":downloadLink,"delXdays":delXdays},
       success: function(msgObj) {
        if (msgObj.error) {
          $(".delXdays").text(msgObj.error);
          $(".delXdays").addClass("text-error").fadeIn();
        }
      }
     });
  });

  //downloads
  $("select[name='delXdownloads']").change(function() {
    var delXdownloads = $(this).val();
    var downloadLink = $("input[name='susDownloadLink']").val();
    $(".delXdownloads").fadeTo("fast",delXdownloads == -1 ? 0.5 : 1);
    $.ajax({
       type: "POST",
       url: "functions.ajax.php",
       dataType: 'json',
       async: false,
       data: {"action":"setDelXdownloads","downloadLink":downloadLink,"delXdownloads":delXdownloads},
       success: function(msgObj) {
        if (msgObj.error) {
          $(".delXdownloads").text(msgObj.error);
          $(".delXdownloads").addClass("text-error").fadeIn();
        }
      }
     });
  });
  /******
   * 17. SINGLE: autodelete after X days or downloads - set by uploader [-]
   ******/


  /******
   * 18. MULTI: autodelete after X days or downloads - set by uploader [+]
   ******/
  $(".delXdaysMulti,.delXdownloadsMulti").fadeTo(0,0.5);

  //days
  $("select[name='delXdaysMulti']").change(function() {
    var delXdays = $(this).val();
    var u_key = $("input[name='u_key']").val();
    $(".delXdaysMulti").fadeTo("fast",delXdays == -1 ? 0.5 : 1);
    $.ajax({
       type: "POST",
       url: "functions.ajax.php",
       dataType: 'json',
       async: false,
       data: {"action":"setDelXdaysMulti","u_key":u_key,"delXdays":delXdays},
       success: function(msgObj) {
        if (msgObj.error) {
          $(".delXdaysMulti").text(msgObj.error);
          $(".delXdaysMulti").addClass("text-error").fadeIn();
        }
      }
     });
  });

  //downloads
  $("select[name='delXdownloadsMulti']").change(function() {
    var delXdownloads = $(this).val();
    var u_key = $("input[name='u_key']").val();
    $(".delXdownloadsMulti").fadeTo("fast",delXdownloads == -1 ? 0.5 : 1);
    $.ajax({
       type: "POST",
       url: "functions.ajax.php",
       dataType: 'json',
       async: false,
       data: {"action":"setDelXdownloadsMulti","u_key":u_key,"delXdownloads":delXdownloads},
       success: function(msgObj) {
        if (msgObj.error) {
          $(".delXdownloadsMulti").text(msgObj.error);
          $(".delXdownloadsMulti").addClass("text-error").fadeIn();
        }
      }
     });
  });  
  /******
   * 18. MULTI: autodelete after X days or downloads - set by uploader [-]
   ******/

});