<?php
  include_once("config.php");
  include_once("functions.php");
  header('Content-Type: text/html; charset=utf-8');
  include_once("lang/" . $config->lang . "/main.lang.php");

  //faqs are used in the footer too
  include("lang/" . $config->lang . "/faqs.lang.php");


?>
<!DOCTYPE html>
<html lang="<?php echo substr($config->lang,0,2); ?>">
  <head>
    <meta charset="utf-8">
    <title><?php echo strip_tags($config->siteName); ?></title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta name="description" content="">
    <meta name="author" content="Mac Winter | http://codecanyon.net/user/themac/">

    <link href="<?php echo $config->instDir; ?>/css/bootstrap.cerulean.min.css" rel="stylesheet">
    <link href="<?php echo $config->instDir; ?>/css/bootstrap-responsive.wo1200.min.css" rel="stylesheet">
    <link href="<?php echo $config->instDir; ?>/css/sfs.min.css" rel="stylesheet">

    <script src="<?php echo $config->instDir; ?>/js/jquery.1.9.1.min.js" type="text/javascript"></script>
    <script src="<?php echo $config->instDir; ?>/js/bootstrap.min.js" type="text/javascript"></script>
    
    <!-- notifications [+] -->
    <script src="<?php echo $config->instDir; ?>/js/jquery.pnotify.min.js" type="text/javascript"></script>
    <link href="<?php echo $config->instDir; ?>/css/jquery.pnotify.default.css" rel="stylesheet">
    <!-- notifications [-] -->

    <?php if ($config->downloadSeconds) { ?>
    <!-- wait seconds for download [+] -->
    <script src="<?php echo $config->instDir; ?>/js/jquery.countDown.min.js" type="text/javascript"></script>    
    <!-- wait seconds for download [+] -->
    <?php } ?>

    <!-- easier modals [+] -->
    <script src='<?php echo $config->instDir; ?>/js/bootbox.3.2.0.min.js' type='text/javascript'></script>
    <!-- easier modals [-] -->

    <script src="<?php echo $config->instDir; ?>/js/sfs.min.js" type="text/javascript"></script>
<?php

  echo $add2header;

  $actMen[$currPage?$currPage:"home"] = " class='active'";


?>
  </head>

  <body>

    <div id="wrapper_main">

    <div class="navbar navbar navbar-static-top">
      <div class="navbar-inner">
        <div class="container">
          <button type="button" class="btn btn-navbar" data-toggle="collapse" data-target=".nav-collapse">
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
            <span class="icon-bar"></span>
          </button>
          <a class="brand" href="<?php echo $config->instDir; ?>/"><?php echo $config->siteName; ?></a>
          <div class="nav-collapse collapse">
            <ul class="nav">
              <li<?php echo $actMen["home"]; ?>><a href="<?php echo $config->instDir; ?>/"><?php echo lang("men_home"); ?></a></li>
              <li<?php echo $actMen["contact"]; ?>><a href="<?php echo $config->instDir; ?>/contact.php"><?php echo lang("men_contact"); ?></a></li>
              <li<?php echo $actMen["faqs"]; ?>><a href="<?php echo $config->instDir; ?>/faqs.php">FAQs</a></li>
            </ul>
<!-- DropDown [+] -->
          <ul class='nav pull-right'>
              <li class="dropdown">
                <a class="dropdown-toggle" href="#" data-toggle="dropdown">Options <strong class="caret"></strong></a>
                <ul class="dropdown-menu">
                  <li class="nav-header">Languages</li>
                  <li><a href="?setLang=en">English</a></li>
                  <li><a href="?setLang=de-Du">Deutsch (Du)</a></li>
                  <li><a href="?setLang=de-Sie">Deutsch (Sie)</a></li>
                </ul>
              </li>
            </ul>
<!-- DropDown [-] -->
          </div>
        </div>
      </div>
    </div>
    <div class="container mt20">