<?php

/**
 * This functions is used to handle all database queries of the project
 * and if an error occurs an usefull email to an administrator will be sent
 * 
 * @param string $sql - the SQL Query
 * 
 * @return the MYSQL result identifier, send's an email on error
 **/ 
function dbquery($sql) {
  //own db debugger
  global $db, $config;

  //reconnect if needed
  if (!mysql_ping($db)) { //reconnect if db connection is lost (huge files)
    mysql_close($db);
    $db = mysql_connect($config->db_host, $config->db_user, $config->db_pass);
    mysql_select_db($config->db_name, $db);
  }


  $res = mysql_query($sql,$db);
  if (mysql_errno($db)) {
    mail($config->admin_mail, strip_tags($config->siteName) . ' DB-Error',$_SERVER['PHP_SELF']."?".$_SERVER['QUERY_STRING']."\n\nMySQL error ".mysql_errno().": ".mysql_error()."\nWhen executing:\n$sql\nHTTP_USER_AGENT: ".$_SERVER['HTTP_USER_AGENT']."\nREMOTE_ADDR: ".$_SERVER['REMOTE_ADDR']."\nHTTP_HOST: ".$config->projecturl);
  }
  return $res;
}

/**
 * quotes and escape quotes of single strings, or returns NULL for the use in mysql queries
 * makes only sense for strings 
 * Attention: the Quotes are part of the output:
 *    dbquote("hallo")    ->    "'hallo'"
 *    dbquote("c'mon")    ->    "'c\'mon'"
 *    dbquote("")         ->    "NULL"  
 *    use
 *      field = " . dbquote($val) . "
 *    don't use 
 *      field = '" . dbquote($val) . "' 
 * 
 * @param string $str - the string to check
 * 
 * @return formated string for the use in sql statements
 **/ 
function dbquote($str) {
  //to get the correct quotes and prevent from musthave of magic quotes
  if (get_magic_quotes_gpc()) { //if slashes added and magic quotes are enabled
      $str = stripslashes($str);
  }
  // quotieren, falls kein integer
  if (!is_numeric($str)) {
      $str = "'" . mysql_real_escape_string($str) . "'";
  }
  return $str;
}


/**
 * to generate the different secret unreproduce-able keys
 * 
 * @param integer $fileId - id (database) of the file
 * 
 * @return array(
 *                string skey         -> secret download key
 *                string deletekey    -> secret deletion key
 *              )
 * used in the sql query on the admin page too
 **/ 
function genFileKeys($fileId) {
  global $config;
  $fileId = intval($fileId);
  if (!$fileId) return false;
  $sql = "select md5(concat(id,'~'," . dbquote($config->secretKey) . ",'##',created)) as skey, md5(concat(id,'DE33LE'," . dbquote($config->secretKey) . ",'}}',uid)) as delkey from `" . $config->tablePrefix . "files` where id = '$fileId'";
  $res = dbquery($sql);
  if (!mysql_num_rows($res)) return false;
  $row = mysql_fetch_object($res);
  return array($row->skey,$row->delkey);
}

/**
 * retrieve some information about download/deletetion file
 * 
 * @param string $key     -> secret download or delete key
 *        string $type    -> what kind of key??? download/delete/file/upload default: download
 * 
 * @return object with file information
 **/
function getFileInfos($key,$type = "download") {
  global $config;
  if (!$key) return false;
  if ($type == "download") {
    $sql = "select *, md5(concat(created,'~',created," . dbquote($config->secretKey) . ",'][',id*3)) as fkey, date_add(" . ($config->delOn=="download"?"last_download":"created") . ", interval " . intval($config->delDays) . " day) as accessible_until, date_add(created, interval del_days day) as accessible_until_by_user, datediff(date_add(" . ($config->delOn=="download"?"last_download":"created") . ", interval " . intval($config->delDays) . " day),now()) as days_remaining, datediff(date_add(created, interval del_days day),now()) as days_remaining_by_user from `" . $config->tablePrefix . "files` where md5(concat(id,'~'," . dbquote($config->secretKey) . ",'##',created)) = " . dbquote($key) . " and status = 1";
  }
  if ($type == "delete") {
    $sql = "select *, md5(concat(created,'~',created," . dbquote($config->secretKey) . ",'][',id*3)) as fkey, date_add(" . ($config->delOn=="download"?"last_download":"created") . ", interval " . intval($config->delDays) . " day) as accessible_until, date_add(created, interval del_days day) as accessible_until_by_user, datediff(date_add(" . ($config->delOn=="download"?"last_download":"created") . ", interval " . intval($config->delDays) . " day),now()) as days_remaining, datediff(date_add(created, interval del_days day),now()) as days_remaining_by_user from `" . $config->tablePrefix . "files` where md5(concat(id,'DE33LE'," . dbquote($config->secretKey) . ",'}}',uid)) = " . dbquote($key) . " and status = 1";
  }
  if ($type == "file") {
    $sql = "select * from `" . $config->tablePrefix . "files` where md5(concat(created,'~',created," . dbquote($config->secretKey) . ",'][',id*3)) = " . dbquote($key) . " and status = 1";
  }
  if ($type == "upload") {
    $sql = "select * from `" . $config->tablePrefix . "files` where u_key = " . dbquote($key) . " and status = 1 limit 1";
  }
  if (!$sql) return false;
  $res = dbquery($sql);
  if (!mysql_num_rows($res)) return false;
  $row = mysql_fetch_object($res);

  if ($row->del_days > -1) {
    $row->days_remaining = $row->days_remaining_by_user;
    $row->accessible_until = $row->accessible_until_by_user;
  }

  $row->downloadFileName = $row->fkey . "." . pathinfo($row->fname, PATHINFO_EXTENSION);
  //add download handler information if file is requested
  $d_ips = $d_sids = array();
  if ($type == "file") {
    $sql = "select * from `" . $config->tablePrefix . "download_handler` where files_id = '" . $row->id . "' order by d_time";
    $res = dbquery($sql);
    while ($rowdh = mysql_fetch_object($res)) {
      $d_ips[] = $rowdh->d_ip;
      $d_sids[] = $rowdh->d_sid;
      //last d_time
      $row->d_time = $rowdh->d_time;
    }
  } 
  $row->d_ips = $d_ips;
  $row->d_sids = $d_sids;
  return $row;
}

/**
 * retrieve some information about download/deletetion links of a group of files
 * 
 * @param string $key     -> upload_key
 * 
 * @return array with objects with file information
 **/
function getMultiFileInfos($key) {
  global $config;
  if (!$key) return false;
  $sql = "select *,md5(concat(id,'~'," . dbquote($config->secretKey) . ",'##',created)) as skey,md5(concat(created,'~',created," . dbquote($config->secretKey) . ",'][',id*3)) as fkey from `" . $config->tablePrefix . "files` where u_key = " . dbquote($key) . " and status = 1";
  $res = dbquery($sql);
  if (!mysql_num_rows($res)) return false;
  while ($row = mysql_fetch_object($res)) {
    $row->downloadFileName = $row->fkey . "." . pathinfo($row->fname, PATHINFO_EXTENSION);
    $files[] = $row;
  }
  return $files;
}

/**
 * the language function, displays correct language strings for activated language
 * the language files can be found in the lang-directory   
 *  
 * @param string $key - the key of the language to display
 * @global boolean $show_lang_keys - can be set in the conf.php - show additional to the language string the appropriate key too
 * 
 * @return correct translated language string if found
 *         if not - the key will be returned width two leading and trailing underscores instead and the $deblang array will be increased
 **/
function lang($key) {
  global $LANG, $deblang, $show_lang_keys;
  if (array_key_exists($key, $LANG)) return $LANG[$key] . ($show_lang_keys ? " [$key]" : "");// . " [$key]";
  else {
    $deblang[] = $key;
    return "__" . $key . "__";
  }
}

/**
 * to inform site administrators if some language keys are not available
 *  
 * @param NONE
 * @global array $deblang - not found language keys - filled with the help of lang()
 * 
 * @return nothing but sends an email to administrator if languages keys not available
 **/
function deblang() {
  //mail notfound language keys to debug mailaddr
  global $config, $deblang;
  if (!$deblang) return false;
  $deblang = array_unique($deblang);
  $included_files = get_included_files();
  foreach ($included_files as $filename) {
    $fname = basename($filename);
    if (preg_match('/lang\.php$/',$fname)) break;
  }
  mail($config->admin_mail, strip_tags($config->siteName) . ' Language-Error',$_SERVER['PHP_SELF']."?".$_SERVER['QUERY_STRING']."\n\nLanguage: " . $config->lang . "\nLanguagefile: " . $config->lang . "/$fname\nMissing Keys:\n\t" . implode("\n\t",$deblang) . "\n");  
}

/**
 * converts bytes in human readable outpts
 *  
 * @param integer $int      -> bytes
 *
 * @return string -> human readable filesize
 **/
function fsize($int) {
  $int = intval($int);
  $kb = 1024;
  $mb = $kb*1024;
  $gb = $mb*1024;
  $tb = $gb*1024;
  $pb = $tb*1024;
  if ($int < $kb) return $int . " B";
  elseif ($int < $mb) return round($int/$kb,2) . " KB";
  elseif ($int < $gb) return round($int/$mb,2) . " MB";
  elseif ($int < $tb) return round($int/$gb,2) . " GB";
  elseif ($int < $pb) return round($int/$tb,2) . " TB";
  else return round($int/$pb,2) . " PB";
}

/**
 * used in is_email() - on Windows machines this function is not available
 * so this function will be used instead 
 * 
 * @param NONE
 * 
 * @return true if it's valid or false if not    
 **/ 
if (!function_exists("checkdnsrr")) {
  function checkdnsrr() {
    return true;
  }
}

/**
 * Checks if email address is valid and host exists
 * 
 * @param string $email - the email to check
 * 
 * @return true if it's valid or false if not    
 **/ 
function is_email($email) {
  $email = trim($email);
  if (!$email) return false;
  if (!preg_match("!^[\w|\.|\-|_]+@\w[\w|\.|\-]+\.[a-zA-Z]{2,6}$!",$email)) return false;
  else {
    list($user, $host) = explode("@", $email);
    if (checkdnsrr($host, "MX") or checkdnsrr($host, "A")) return true;
    else return false;
  }
}

/**
 * recursive removing of directories on server
 * 
 * @param string $location - the path to the directory to delete
 * 
 * @return nothing but removes the directory
 **/
function xrmdir($location){
   $rc=0;
   if (is_dir($location)){
      $dp=opendir("$location");
      while(false !== ($file = readdir($dp))){
         if ($file=="."||$file=="..") continue;
         xrmdir("$location/$file");
      }
      closedir($dp);
      unset($dp);
      $rc=rmdir($location);
      unset($location);
   }
   else{
      $rc=unlink($location);

      unset($location);
   }
   return $rc;
}


/**
 * short for htmlentities($str,ENT_QUOTES) especially for the use in form fields and title and alt tags
 * htmlentities: all characters which have HTML character entity equivalents are translated into these entities 
 * ENT_QUOTES converts both double and single quotes
 *  
 * @param string $str - the string to convert
 * 
 * @return converted string
 **/
function he($str) {
  $str = htmlentities($str, ENT_QUOTES, "UTF-8");
  return $str;
}


/**
 * removes files upped more than the days defined in the config before ($config->delDays)
 *  
 * @param none
 * 
 * @return nothing
**/
function cleanUp() {  
  global $config;
  $delDays = intval($config->delDays);
  if ($delDays < 0 && !$config->delSettingsByUploader) return false;

  //days set???
  if ($delDays > -1) {
    if ($config->delOn == "download") {
      $add2sql[] = "datediff(now(), last_download) > $delDays";
    } else {
      $add2sql[] = "datediff(now(), created) > $delDays";
    }
  }

  //user set deletion information
  if ($config->delSettingsByUploader) {
    //days
    if ($delDays > 1) {
      $add2sql[] = "(del_days > -1 and datediff(now(), created) > del_days)";
    }
    //downloads
    $add2sql[] = "(del_downloads > 0 and downloads = del_downloads)";
  }

  if (!$add2sql) return false;

  $sql = "select id, uid from `" . $config->tablePrefix . "files` where uid = 0 and " . implode(" or ",$add2sql);
  $res = dbquery($sql);
  while ($row = mysql_fetch_object($res)) {
    //delete from filesystem
    $file_path = $config->uploadDir . $row->uid . "/" . $row->id;
    if (file_exists($file_path)) xrmdir($file_path);
  }
  //delete from database
  $sql = "delete from `" . $config->tablePrefix . "files` where uid = 0 and " . implode(" or ",$add2sql);
  dbquery($sql);
  //delete orphan download_handler entries
  $sql = "delete from `" . $config->tablePrefix . "download_handler` where datediff(now(), d_time) > 1";
  dbquery($sql);
  //delete orphan database entries
  $sql = "select id, uid from `" . $config->tablePrefix . "files`";
  $res = dbquery($sql);
  while ($row = mysql_fetch_object($res)) {
    $file_path = $config->uploadDir . $row->uid . "/" . $row->id;
    if (!file_exists($file_path)) {
      dbquery("delete from `" . $config->tablePrefix . "files` where id = '" . $row->id . "'");
    }
  }
}


/**
 * check if it's a image, when it's not toooo big
 *  
 * @param $imgPath .... full path to image
 * 
 * @return boolean ... true if it's an image, false if not
**/
function is_image($imgPath) {
  if (filesize($imgPath) > 10*1024*1024) return false;
  list($w, $h) = getimagesize($imgPath);
  if (!$w || !$h) return false;
  return true;
}

/**
 * generate password for password protected files
 *  
 * @param $length .... length of the password (default: 9)
 *        $strength .. which characters should be used, the higer the stronger
 * 
 * @return string ... the password
**/
function genPWD($length=9, $strength=0) {
  $vowels = 'aeuy';
  $consonants = 'bdghjmnpqrstvz';
  if ($strength & 1) $consonants .= 'BDGHJLMNPQRSTVWXZ';
  if ($strength & 2) $vowels .= "AEUY";
  if ($strength & 4) $consonants .= '23456789';
  if ($strength & 8) $consonants .= '@#$%';
  $password = '';
  $alt = time() % 2;
  for ($i = 0; $i < $length; $i++) {
      if ($alt == 1) {
          $password .= $consonants[(rand() % strlen($consonants))];
          $alt = 0;
      } else {
          $password .= $vowels[(rand() % strlen($vowels))];
          $alt = 1;
      }
  }
  return $password;
}

/**
 * to calculate the microseconds for the bandwidth throtteling
 *  
 * @param none
 * 
 * @return int ... number of microseconds to wait between 8MB blocks during the download
 *         disables $config->XSendFile if seconds are calculated
**/
function calcBW() {
  global $config;
  $kbps = intval($config->kbps);
  if (!$kbps || $kbps < 0) return false;
  $config->XSendFile = false;
  return intval(3500000/$kbps);
}

/**
 * to enable UTF-8 encoded subjects
 *  
 * @param $subject
 * 
 * @return UTF-8 spelling for the encoded subjects
**/
function UTF8subject($subject) {
  if (!$subject) return false;
  $subject = strip_tags($subject);
  return '=?UTF-8?B?'.base64_encode($subject).'?=';
}

/**
 * used for downloads on android devices (usage on download.php and files.php)
 * just to fix the double calls by android browsers
 *
 * @param $todo
 *          "init" to set counter on adroid devices
 *          "countDown" to reduce counter to enable downlad on second call
 * 
 * @return nothing
 **/
function androidDoubleCallFix($todo = "init") {
  if(
    stripos($_SERVER['HTTP_USER_AGENT'],'android') !== false
    // || (preg_match('/AppleWebKit/',$_SERVER['HTTP_USER_AGENT']) && !preg_match('/(ipad)|(iphone)|(blackberry)|(macintosh)/i',$_SERVER['HTTP_USER_AGENT']))  //because some andoid browsers on some android devices doesn't send an "ANDROID" string    
  ) {
    if ($todo == "init") {
      $_SESSION["androCount"] = 2;
    }
    elseif ($todo == "countDown") {
      $_SESSION["androCount"]--;
    }
  }
}

?>