<?php
include_once("config.php");
include_once("functions.php");

include_once("lang/" . $config->lang . "/main.lang.php");

$action = $_REQUEST["action"];

/****
* SINGLE: send download information after upload [+]
****/
if ($action == "sendFileInfo") {
    $DownLink = $_REQUEST["DownLink"];
    $DelLink = $_REQUEST["DelLink"];
    $mailFrom = $_REQUEST["mailFrom"];
    $mailTo = $_REQUEST["mailTo"];
    $message = $_REQUEST["message"];

    //filechecks - prevent from spaming
    $pinfo = pathinfo($DownLink);
    $finfo = getFileInfos($pinfo["filename"]);
    if (!$finfo) exit(lang("error_file_failure"));
   	
    if (!is_email($mailFrom)) exit(lang("error_from_address_failure"));
    if (!is_email($mailTo)) exit(lang("error_to_address_failure"));

    //Password protected file
    if ($finfo->pwd_protected && $finfo->pwd) $PasswordLine = sprintf(lang("password_line_mailings"),$finfo->pwd);

    $toSenderBody = file_get_contents("lang/" . $config->lang . "/to.sender.mail.txt");
    $toRcptBody = file_get_contents("lang/" . $config->lang . "/to.receipient.mail.txt");

    if ($message) $message = "-----\n" . $message;

    $find = array("[mailFrom]","[mailTo]","[fileName]","[fileSize]","[DownLink]","[DelLink]","[siteName]","[PasswordLine]","[message]","[delDays]");
    $repl = array($mailFrom,$mailTo,$finfo->descr,fsize($finfo->fsize),$DownLink,$DelLink,strip_tags($config->siteName),$PasswordLine,$message,$config->delDays);
    $toSenderBody = str_replace($find,$repl,$toSenderBody);
    $toRcptBody = str_replace($find,$repl,$toRcptBody);

    mail($mailFrom,UTF8subject(sprintf(lang("subject_upload_information"),$config->siteName)),$toSenderBody,$config->mailHeaders);
    mail($mailTo,UTF8subject(sprintf(lang("subject_download_information"),$config->siteName)),$toRcptBody,$config->mailHeaders);
  
    exit("OK");
  }
/****
* SINGLE: send download information after upload [-]
****/

/****
* MULTI: send download information after upload [+]
****/
if ($action == "sendMultiFileInfo") {
    $u_key = $_REQUEST["u_key"];
    $mailFrom = $_REQUEST["mailFrom"];
    $mailTo = $_REQUEST["mailTo"];
    $message = $_REQUEST["message"];

    //filechecks - prevent from spaming
    $fileInfos = getFileInfos($u_key,"upload");
    if (!$fileInfos) exit(lang("error_file_failure"));
    
    if (!is_email($mailFrom)) exit(lang("error_from_address_failure"));
    if (!is_email($mailTo)) exit(lang("error_to_address_failure"));

    //Password protected file
    if ($fileInfos->pwd_protected && $fileInfos->pwd) $PasswordLine = sprintf(lang("password_line_mailings"),$fileInfos->pwd);

    $toSenderBody = file_get_contents("lang/" . $config->lang . "/to.sender.multi.mail.txt");
    $toRcptBody = file_get_contents("lang/" . $config->lang . "/to.receipient.multi.mail.txt");

    preg_match_all('/\[filesList\](.*)\[\/filesList\]/s',$toRcptBody,$flistArr);
    $flistBlockR = $flistArr[1][0];
    preg_match_all('/\[filesList\](.*)\[\/filesList\]/s',$toSenderBody,$flistArr);
    $flistBlockS = $flistArr[1][0];

    //get all files
    $i=0;
    $sql = "select * from `" . $config->tablePrefix . "files` where u_key = " . dbquote($u_key);
    $res = dbquery($sql);
    $numFiles = mysql_num_rows($res);
    while ($row = mysql_fetch_object($res)) {
      list($fileKey,$delFileKey) = genFileKeys($row->id);
      $find = array("[Number]","[Name]","[Size]","[DownLink]","[DelLink]");
      $repl = array(++$i,$row->descr,fsize($row->fsize),$config->baseDownloadUrl . $fileKey . ".html",$config->baseDeleteUrl . $delFileKey . ".html");
      $filesListR .= str_replace($find,$repl,$flistBlockR);
      $filesListS .= str_replace($find,$repl,$flistBlockS);
    }

    $toRcptBody = preg_replace('/\[filesList\].*\[\/filesList\]/s',$filesListR,$toRcptBody);
    $toSenderBody = preg_replace('/\[filesList\].*\[\/filesList\]/s',$filesListS,$toSenderBody);

    if ($message) $message = "-----\n" . $message;

    $find = array("[mailFrom]","[mailTo]","[numFiles]","[siteName]","[PasswordLine]","[message]","[delDays]","[groupLink]");
    $repl = array($mailFrom,$mailTo,$numFiles,strip_tags($config->siteName),$PasswordLine,$message,$config->delDays,$config->baseGroupUrl . $u_key . ".html");
    $toSenderBody = str_replace($find,$repl,$toSenderBody);
    $toRcptBody = str_replace($find,$repl,$toRcptBody);

    mail($mailFrom,UTF8subject(sprintf(lang("subject_upload_information"),$config->siteName)),$toSenderBody,$config->mailHeaders);
    mail($mailTo,UTF8subject(sprintf(lang("subject_download_information_multi"),$numFiles,$config->siteName)),$toRcptBody,$config->mailHeaders);
  
    exit("OK");
  }
/****
* MULTI: send download information after upload [-]
****/


/****
* Contact [+]
****/
if ($action == "contact") {
    $name = trim(stripslashes($_POST['name']));
    $email = trim(strtolower($_POST['email']));
    $tel = trim(stripslashes($_POST['tel']));
    $message = trim(stripslashes($_POST['message']));
    $captchacode = trim($_REQUEST["captchacode"]);

    $error = array();
    if(!$name) $error[] = lang("error_noname");
    if(!$email) $error[] = lang("error_noemail");
    elseif (!is_email($email)) $error[] = lang("error_email_failure");
    if(!$message) $error[] = lang("error_nomessage");
    if (!$captchacode) $error[] = lang("error_no_captcha");
    else {
      include("cap1/securimage.php");
      $cap_img = new Securimage();
      if(!$cap_img->check($captchacode)) $error[] = lang("error_wrong_captcha");
    }
    if(!$error) {
      $mailmess = "Name: $name\nEmail: $email\nTel: $tel\nIP: " . $_SERVER["REMOTE_ADDR"] . "\n\n--\n$message";
      mail($config->contact_mail, strip_tags($config->siteName) . " WebForm", $mailmess,
         "From: ".$name." <".$email.">\r\n"
        ."Reply-To: ".$email."\r\n"
        ."Content-Type: text/plain; charset=utf-8\r\n"
        ."X-Mailer: PHP/" . phpversion());
      if (!$in_site) echo "OK";
      $success = lang("success_mess_sent");
    } else {
      $error = '<div class="alert alert-error">' . implode("<br />",$error) . '</div>';
      if (!$in_site) echo $error;
    }
}
/****
* Contact [-]
****/


/****
* Report File [+]
****/
if ($action == "abuse") {
    $name = trim(stripslashes($_POST['name']));
    $email = trim(strtolower($_POST['email']));
    $message = trim(stripslashes($_POST['message']));
    $key = trim(stripslashes($_POST['dk']));
    $captchacode = trim($_REQUEST["captchacode"]);

    $error = array();
    if(!$name) $error[] = lang("error_noname");
    if(!$email) $error[] = lang("error_noemail");
    elseif (!is_email($email)) $error[] = lang("error_email_failure");
    if(!$message) $error[] = lang("error_nomessage");
    $finfo = getFileInfos($key);
    if (!$finfo) exit(lang("error_file_failure"));
    if (!$captchacode) $error[] = lang("error_no_captcha");
    else {
      include("cap1/securimage.php");
      $cap_img = new Securimage();
      if(!$cap_img->check($captchacode)) $error[] = lang("error_wrong_captcha");
    }
    if(!$error) {
      list($fkey,$delkey) = genFileKeys($finfo->id);
      $mailmess = "Name: $name\nEmail: $email\n\nIP: " . $_SERVER["REMOTE_ADDR"] . "\n" .
        "File Name: " . $finfo->descr . "\nFile Size: " . fsize($finfo->fsize) . "\nDownload URL: " . $config->baseDownloadUrl . $key . ".html\n" .
        "Delete URL: " . $config->baseDeleteUrl . $delkey . ".html\n\n--\n$message";
      mail($config->contact_mail, strip_tags($config->siteName) . " - File reported", $mailmess,
         "From: ".$name." <".$email.">\r\n"
        ."Reply-To: ".$email."\r\n"
        ."Content-Type: text/plain; charset=utf-8\r\n"
        ."X-Mailer: PHP/" . phpversion());
      if (!$in_site) echo "OK";
      $success = lang("success_mess_sent");
    } else {
      $error = '<div class="alert alert-error">' . implode("<br />",$error) . '</div>';
      if (!$in_site) echo $error;
    }
}
/****
* Report File [-]
****/


/****
* Authenticated Admins only [+]
****/

if ($sfs_auth) {

  //delete file
  if ($action == "delFile") {
    $fid = intval($_REQUEST["fid"]);
    if (!$fid) $error = "Insufficient data provided.";
    if (!$error) {
      $sql = "select * from `" . $config->tablePrefix . "files` where id = '$fid' and uid = '0'";
      $res = dbquery($sql);
      if (!mysql_num_rows($res)) $error = "File cannot be found.";
    }
    if (!$error) {  
      $row = mysql_fetch_object($res);
      $sql = "delete from `" . $config->tablePrefix . "files` where id = '$fid' and uid = '0'";
      dbquery($sql);
      $file_path = $config->uploadDir . $row->uid . "/" . $fid;
      if (file_exists($file_path)) xrmdir($file_path);
      $success = "The file was removed successfully.";
    }
    if (!$in_site) exit ($error?$error:"OK");
  }


}
/****
* Admins only [-]
****/


/****
* SINGLE: Password protect shared files [+]
****/
if ($action == "pwdProtection") {
  $downloadLink = $_REQUEST["downloadLink"];
  $pwd_protected = $_REQUEST["protection"]=="true"?1:0;
  preg_match('/^.*\/([0-9a-z]+)\.html$/',$downloadLink,$d_data);
  $key = $d_data[1];
  $fileInfos = getFileInfos($key);
  if (!$fileInfos) $error = lang("error_file_failure");
  if (!$error) {
    if (!$fileInfos->pwd) {
      $pwd = $pwd = genPwd(8,1);
      $sql = "update `" . $config->tablePrefix . "files` set pwd = " . dbquote($pwd) . ", pwd_protected = '$pwd_protected' where id = '" . $fileInfos->id . "'";
      dbquery($sql);
    } else {
      $pwd = $fileInfos->pwd;
      $sql = "update `" . $config->tablePrefix . "files` set pwd_protected = '$pwd_protected' where id = '" . $fileInfos->id . "'";
      dbquery($sql);
    }    
    if ($pwd_protected) $statmess = sprintf(lang("password_protection_ON"),$pwd);
    else $statmess = lang("password_protection_OFF");
  }

  echo json_encode(array("protection" => $pwd_protected, "statmess" => $statmess, "error" => $error));

}
/****
* SINGLE: Password protect shared files [-]
****/

/****
* MULTI: Password protect shared files [+]
****/
if ($action == "pwdProtectionMulti") {
  $u_key = $_REQUEST["u_key"];
  $pwd_protected = $_REQUEST["protection"]=="true"?1:0;
  $fileInfos = getFileInfos($u_key,"upload");
  if (!$fileInfos) $error = lang("error_file_failure");
  if (!$error) {
    if (!$fileInfos->pwd) {
      $pwd = $pwd = genPwd(8,1);
      $sql = "update `" . $config->tablePrefix . "files` set pwd = " . dbquote($pwd) . ", pwd_protected = '$pwd_protected' where u_key = " . dbquote($u_key);
      dbquery($sql);
    } else {
      $pwd = $fileInfos->pwd;
      $sql = "update `" . $config->tablePrefix . "files` set pwd_protected = '$pwd_protected' where u_key = " . dbquote($u_key);
      dbquery($sql);
    }    
    if ($pwd_protected) $statmess = sprintf(lang("password_protection_ON"),$pwd);
    else $statmess = lang("password_protection_OFF");
  }

  echo json_encode(array("protection" => $pwd_protected, "statmess" => $statmess, "error" => $error));

}
/****
* MULTI: Password protect shared files [-]
****/


/****
* SINGLE: set autodelete after x days by uploader [+]
****/
if ($action == "setDelXdays") {
  $downloadLink = $_REQUEST["downloadLink"];
  $delXdays = intval($_REQUEST["delXdays"]);
  if ($delXdays > $config->delDays || $delXdays < -1) $delXdays = -1;
  preg_match('/^.*\/([0-9a-z]+)\.html$/',$downloadLink,$d_data);
  $key = $d_data[1];
  $fileInfos = getFileInfos($key);
  if (!$fileInfos) $error = lang("error_file_failure");
  if (!$error) {
    $sql = "update `" . $config->tablePrefix . "files` set del_days = '$delXdays' where id = '" . $fileInfos->id . "'";
    dbquery($sql);
  }
  echo json_encode(array("statmess" => $statmess, "error" => $error));

}
/****
* SINGLE: set autodelete after x days by uploader  [-]
****/


/****
* MULTI: set autodelete after x days by uploader [+]
****/
if ($action == "setDelXdaysMulti") {
  $u_key = $_REQUEST["u_key"];
  $delXdays = intval($_REQUEST["delXdays"]);
  if ($delXdays > $config->delDays || $delXdays < -1) $delXdays = -1;
  $fileInfos = getFileInfos($u_key,"upload");
  if (!$fileInfos) $error = lang("error_file_failure");
  if (!$error) {
    $sql = "update `" . $config->tablePrefix . "files` set del_days = '$delXdays' where u_key = " . dbquote($u_key);
    dbquery($sql);
  }
  echo json_encode(array("statmess" => $statmess, "error" => $error));

}
/****
* MULTI: set autodelete after x days by uploader [-]
****/


/****
* SINGLE: set autodelete after x downloads by uploader [+]
****/
if ($action == "setDelXdownloads") {
  $downloadLink = $_REQUEST["downloadLink"];
  $delXdownloads = intval($_REQUEST["delXdownloads"]);
  preg_match('/^.*\/([0-9a-z]+)\.html$/',$downloadLink,$d_data);
  $key = $d_data[1];
  $fileInfos = getFileInfos($key);
  if (!$fileInfos) $error = lang("error_file_failure");
  if (!$error) {
    $sql = "update `" . $config->tablePrefix . "files` set del_downloads = '$delXdownloads' where id = '" . $fileInfos->id . "'";
    dbquery($sql);
  }
  echo json_encode(array("statmess" => $statmess, "error" => $error));
}
/****
* SINGLE: set autodelete after x downloads by uploader  [-]
****/


/****
* MULTI: set autodelete after x downloads by uploader [+]
****/
if ($action == "setDelXdownloadsMulti") {
  $u_key = $_REQUEST["u_key"];
  $delXdownloads = intval($_REQUEST["delXdownloads"]);
  $fileInfos = getFileInfos($u_key,"upload");
  if (!$fileInfos) $error = lang("error_file_failure");
  if (!$error) {
    $sql = "update `" . $config->tablePrefix . "files` set del_downloads = '$delXdownloads' where u_key = " . dbquote($u_key);
    dbquery($sql);
  }
  echo json_encode(array("statmess" => $statmess, "error" => $error));

}
/****
* MULTI: set autodelete after x downloads by uploader [-]
****/


/****
* Password verification [+]
****/
if ($action == "verifyPwd") {
  $error = $verified = false;
  $downloadLink = $_REQUEST["downloadLink"];
  $pwd = $_REQUEST["pwd"];
  preg_match('/^.*\/([0-9a-z]+)\..*$/',$downloadLink,$d_data);
  $downloadLink = print_r($d_data,true);
  $key = $d_data[1];
  $fileInfos = getFileInfos($key,"file");
  if (!$fileInfos) $error = lang("error_file_failure");
  //protected????
  if (!$error && $config->passwordProtection && $fileInfos->pwd_protected && $fileInfos->pwd) {
    $sql = "select id from `" . $config->tablePrefix . "files` where pwd = " . dbquote($pwd) . " and id = '" . $fileInfos->id . "'";
    $res = dbquery($sql);
    if (!mysql_num_rows($res)) $error = lang("error_wrong_password");
    else $_SESSION["pwdVerified"][$fileInfos->id] = true;
  }
  echo json_encode(array("error" => $error, "verified" => $error?0:1));

}
/****
* Password verification [-]
****/


?>