<?php
error_reporting(E_ALL ^ E_NOTICE);

//List of supported Timezones: http://www.php.net/manual/en/timezones.php
date_default_timezone_set('Europe/Vienna');

$config = new stdClass();

//absoulute installation directory
$config->instDir = dirname($_SERVER["SCRIPT_NAME"]);
if ($config->instDir == "/") unset($config->instDir);

//in the installation directory
$config->uploadDir = dirname(__FILE__) . "/data/";

//I suggest to use a directory outside the www-directory's root path
//absolute with trailng slash, smthg. like: /home/mac/www/files.envato.net/data/
//$config->uploadDir = "..........";

$config->projecturl = "http://" . $_SERVER["HTTP_HOST"];

//URLPrefixes...will be calculated autmatically
$config->baseDownloadUrl = $config->projecturl . $config->instDir . "/download/";
$config->baseDeleteUrl = $config->projecturl . $config->instDir . "/delete/";
$config->baseFilesUrl = $config->projecturl . $config->instDir . "/files/";
$config->baseGroupUrl = $config->projecturl . $config->instDir . "/filesgroup/";

//database settings
$config->db_host = "localhost";                             //change!!
$config->db_user = "DBUSER";                               //change!!
$config->db_pass = "DBPASS";                               //change!!
$config->db_name = "DBNAME";                               //change!!
//prefix for the genereated tables
$config->tablePrefix = "SFS163_";
//$config->tablePrefix = "";

//name of your project
$config->siteName = "Simple<wbr />File<wbr />Sharer";

//some mail and web addresses
$config->admin_mail = "admin@yourdomain.com";     		//administrator's mail for Debug messages (DB-Errors, not existing language keys)
$config->automaileraddr = "no-reply@yourdomain.com";	
$config->contact_mail = "office@yourdomain.com";

//secret key for crypting/enrypting the URLs
$config->secretKey = "TGZlAhwB0fGR7Y0L";

//maximum file size in MB
//will be recalculated depending on post_max_size and upload_max_filesize ... see a few lines below
$config->maxFileSize = 15;

/**
 * recalculations of maximum upload size [+]
 **/
$pms = ini_get("post_max_size");
if (preg_match('/g$/i',$pms)) $pms = intval($pms) * 1024;
else $pms = intval($pms);
if ($config->maxFileSize > $pms) $config->maxFileSize = $pms - 1;
$umf = ini_get("upload_max_filesize");
if (preg_match('/g$/i',$umf)) $umf = intval($umf) * 1024;
else $umf = intval($umf);
if ($config->maxFileSize > $umf) $config->maxFileSize = $umf - 1;
/**
 * recalculations of maximum upload size [-]
 **/

//multiple uploads
//if enabled users will be able to upload mor files by drag and drop or file select button
//true ... enabled
//false ... disabled
$config->multiUpload = true;

//maximum number of allowed files to upload at once, has to be a positive integer
$config->maxMultiFiles = 3;

//expiration days (int)
//if set to 0 it's approximately within one day
//if set to -1 files won't be deleted automatically
$config->delDays = 14;

//deletion depending on 
//download ... datetime of last download
//upload ..... datetime of upload (default)
$config->delOn = "download";	//download/upload

//enable deletion settings by uploader
//two options (number of downloads, age of uploaded file ... as long as the values are lower than the $config->delDays
//if $config->delDays are set to a value lower 2 the deletion days cannot be set by the uploader 
//true ... enabled
//false ... disabled
$config->delSettingsByUploader = true;
//a list (array) of possible values for the maximum amount of downloads before autodeletion happens
$config->delDownloadsNumbers = array_merge(range(1,10),array(15,20,30,50,100));

//mailheaders
$config->mailHeaders = "From: " . strip_tags($config->siteName) . " <" . $config->automaileraddr . ">\n";
$config->mailHeaders .= "X-Sender:  " . strip_tags($config->siteName) . " <" . $config->automaileraddr . ">\n"; 
$config->mailHeaders .= "X-Mailer: PHP\n";
$config->mailHeaders .= "Return-Path: <" . $config->automaileraddr . ">\n";
$config->mailHeaders .= "Mime-Version: 1.0\n";
$config->mailHeaders .= "Content-Type: text/plain; charset=UTF-8\n";
$config->mailHeaders .= "Content-Transfer-Encoding: 8bit\n";


//direct download protection (false, "IP", "SESSION")
$config->downloadProtection = false;
// $config->downloadProtection = "IP";
// $config->downloadProtection = "SESSION";

//enable password protected files
//if enabled, the downloaderswill be prompted to give the correct password
//the password will be set automatically
$config->passwordProtection = true;	

//extensions denied to upload - has to be an array
$config->extDenied = array("exe");
//$config->extDenied = array();	//no extension denied

//extensions allowed to upload, if set only these extensions are allowed to upload
$config->extAllowed = array();
//$config->extAllowed = array("jpeg","jpg","png","gif"); //just image extensions
//$config->extAllowed = array(); //all extensions

//seconds before download should be possible after calling download link?
//disabled if empty, 0 or false
$config->downloadSeconds = 10;

//auto preview of uploaded images (GD Library required)
//true .... enabled
//false ... disabled
$config->imagePreview = true;
//width and height of the preview image
$config->prevWidth = 400;
$config->prevHeight = 300;

//using XSendFile if apache module is enabled
//possibility to turn of if it's not configured well
//if you got an earlier version of XSendFile (<=0.9) you could add XSendFileAllowAbove On into your .htaccess
//in versions 0.10++ yiu have to set the XSendFilePath in the config of your virtual host (can't be done in the .htaccess)
//more information here: https://tn123.org/mod_xsendfile/
//set this value to true if it works and downloadsize is higher than 0 bytes
//will be disabled if bandwidth throtteling is enabled
//!!!!! you have to uncomment the setenv line in the .htaccess too to enable XSendFile
$config->XSendFile = false;

//bandwidth throtteling
//if the value is higher as 0 this value will be used as kilobyte per second
//0, false disables bandwidth throtteling
//the calculation result is not exact and can be different from server to server, you've to play around to get the values for your server,
$config->kbps = 0;

//admin credentials
$config->user = "admin";
$config->pass = "pass";

$config->version = "1.72";

$LANG = array();
$faqs = array();


/*****
 * auto setup block [+]
 * can be removed after setup succeeded
 *****/
if (preg_match('~/setup\.php$~',$_SERVER["SCRIPT_NAME"])) $onSetupPage = true;
if (file_exists("setup.php") && !$onSetupPage) {
  header("location: " . $config->instDir . "/setup.php");
  exit;
}
/*****
 * auto setup block [-]
 * can be removed after setup succeeded
 *****/

//reset multiupload 
// - for Safari on Windows platforms
// - files lower than 2
if ($config->multiUpload && ($config->maxMultiFiles < 2 || (stripos($_SERVER["HTTP_USER_AGENT"],"chrome") === false && preg_match('/windows.*safari/i',$_SERVER["HTTP_USER_AGENT"])))) $config->multiUpload = false;

//drag and dropable? just for displaying informations
$config->dragndrop = true;
if (preg_match_all('/msie\s+(\d+)/i',$_SERVER["HTTP_USER_AGENT"],$ddarr)){
	if (is_numeric($ddarr[1][0]) && $ddarr[1][0] < 10) $config->dragndrop = false;
}

ini_set("session.gc_maxlifetime",84600);
@session_start();
$sfs_auth = $_SESSION["sfs_auth"];

$db = @mysql_connect($config->db_host, $config->db_user, $config->db_pass) or $error[] = "<b>Database-connection failed</b>,<br>please use the correct data for your database in the config.php.";
if (!$error) {
  @mysql_select_db($config->db_name, $db) or $error[] = "Database $db_name not found or no rights for access.";
}


/**** Language switcher [+] ****/
$config->lang = $_SESSION["sfsLang"];
//if you add another language you have to increase the array below
if ($_REQUEST["setLang"] && in_array($_REQUEST["setLang"],array("en","de-Sie","de-Du"))) {
	$config->lang = $_SESSION["sfsLang"] = $_REQUEST["setLang"];
}
if (!$config->lang) $config->lang = "en";	//default language
/**** Language switcher [-] ****/


?>