/**************
 *
 * SFS V2.23.01
 *  February 6th 2015
 *
 * TOC
 *  1. some helperlies
 *  2. Get Variables-Values-Parser
 *  3. some essential PHP-Values into JS Variables
 *  4. Contact form
 *  5. File uploader
 *  6. Admin-login Autofocus
 *  7. Admin: Datatables
 *  8. Admin: Flot Charts
 *  9. Wait X Seconds before download Countdowner
 * 10. SINGLE: Password protect download links
 * 11. Verify password protected download links 
 * 12. Abuse form
 * 13. MULTI: Password protect download links
 * 14. Filesgroup options
 * 15. don't leave site willy-nilly
 * 16. prevent of re-clicking download button
 * 17. SINGLE: autodelete after X days - set by uploader
 * 18. MULTI: autodelete after X days - set by uploader
 * 19. CAPTCHA: just to reload the image 
 * 20. optical correction for superlong filenames on download and deletion pages 
 * 21. optical correction for superlong filenames on admin dashboard's "The Last File"-section 
 * 22. add files to current upload session
 * 23. back to the uploaded file(s)
 * 24. SINGLE: handle file descriptions
 * 25. MULTI: handle file descriptions
 *
 **************/


 $(document).ready(function() { 

   /******
   * 1. Some helperlies [+]
   ******/ 

    //object dumper
    function dump(obj) {
      var op = '';
      for (var i in obj) {
          op += i + ": " + obj[i] + "\n";
      }
     alert(op);
    }
    //checks if value in array
    function in_array(needle,arr) {
      for(i=0;i<arr.length;i++) {
        if (needle == arr[i]) {
          return true;
        }
      }
      return false;
    }


  //http://upshots.org/javascript/jquery-copy-style-copycss
  //out-commented modification to run just with bootstrap-tagsinput
   $.fn.copyCSS = function(source){
      var dom = $(source).get(0);
      var style;
      var dest = {};
      if(window.getComputedStyle){
          var camelize = function(a,b){
              return b.toUpperCase();
          };
          style = window.getComputedStyle(dom, null);
          for(var i = 0, l = style.length; i < l; i++){
              var prop = style[i];
              // if (!prop.match(/^border/) && !prop.match(/^padding/) && !prop.match(/^margin/) && !prop.match(/^font/)) {
                // continue;
              // }
              var camel = prop.replace(/\-([a-z])/g, camelize);
              var val = style.getPropertyValue(prop);
              dest[camel] = val;
          };
          return this.css(dest);
      };
      if(style = dom.currentStyle){
          for(var prop in style){
              dest[prop] = style[prop];
          };
          return this.css(dest);
     };
     if(style = dom.style){
        for(var prop in style){
          if(typeof style[prop] != 'function'){
            dest[prop] = style[prop];
          };
        };
      };
      return this.css(dest);
    };


    //get JS working directory (relative to installation directory)
    function dirname(path) {
      if (!path) return false;
      return path.replace(/\\/g,'/').replace(/\/[^\/]*$/, '');;
    }
    function basename(path) {
      if (!path) return false;
      return path.replace(/\\/g,'/').replace( /.*\//, '' );
    }
    function setRelDir(cwd) {
      if (!cwd) return "";
      if (cwd == "download" || cwd == "filesgroup" || cwd == "pro") return "../";
      return "";
    }
    var relDir = setRelDir(basename(dirname(document.location.pathname)));

    //get human readable filesizes
    function fsize(size) {
      size = parseInt(size);
      kb = 1024;
      mb = kb*1024;
      gb = mb*1024;
      tb = gb*1024;
      pb = tb*1024;
      if (size < kb) return size + " B";
      else if (size < mb) return Math.round(100*size/kb)/100 + " KB";
      else if (size < gb) return Math.round(100*size/mb)/100 + " MB";
      else if (size < tb) return Math.round(100*size/gb)/100 + " GB";
      else if (size < pb) return Math.round(100*size/tb)/100 + " TB";
      else return Math.round(100*size/pb)/100 + " PB";
    }

    //add leading zero if needed
    function addZero(int) {
      if (int < 10) return "0"+int;
      else return int;
    }

    //seconds to minutes and hours if needed
    function secConv(sec) {
      if (sec < 60) return "00:" + addZero(sec);
      else if (sec < 3600) {
        return addZero(parseInt(sec/60)) + ":" + addZero(parseInt(sec%60));
      } else {
        return parseInt(sec/3600) + ":" + addZero(parseInt((sec%3600)/60)) + ":" + addZero(parseInt(sec%60));
      }
    }

    //for responsive purpose
    var smallDevice = false;
    if ($(document).width() < 768) {
      smallDevice = true;
    }

    //randomizer (phpjs)
    function mt_rand(min, max) {
      var argc = arguments.length;
      if (argc === 0) {
        min = 0;
        max = 2147483647;
      } else if (argc === 1) {
        throw new Error('Warning: mt_rand() expects exactly 2 parameters, 1 given');
      } else {
        min = parseInt(min, 10);
        max = parseInt(max, 10);
      }
      return Math.floor(Math.random() * (max - min + 1)) + min;
    }

   /******
   * 1. Some helperlies [-]
   ******/ 

  /******
   * 2. Get Variables-Values-Parser [+]
   ******/
  function getGetVars(url,varName){
    var urlA = url.split("?"); 
    var vars = urlA[1].split("&"); 
    for (var i=0;i<vars.length;i++) {   
          var pair = vars[i].split("=");
          //remove anchor
          if(pair[0] == varName) {
            return pair[1].replace(/#.*$/,'');
          }
     }
  }
  /******
   * 2. Get Variables-Values-Parser [-]
   ******/

  
  /******
   * 3. some essential PHP-Values into JS Variables [+]
   ******/
  var jsVars
  $.ajax({
    url: relDir + "js.vars.php",
    type: 'post',
    data:{"return":"json"},
    dataType: 'json',
    async: false,
    success: function(data) {
        jsVars = data;
    }
  });

 /******
  * 3. some essential PHP-Values into JS Variables [-]
  ******/


  /******
   * 4. Contact form [+]
   ******/
  $("form#contactf").submit(function() {
    $("#cnote").slideUp();
    var str = $(this).serialize();
    $.ajax({
      type: "POST",
      url: "functions.ajax.php",
      data: str,
      success: function(msg){ 
        if(msg == 'OK') {
          $("#cnote").html('<div class="alert alert-success">' + jsVars.lang_success_mess_sent + '<\/div>');
          $("#cnote").slideDown();
          $("form#contactf").fadeOut();
        } else {
          $("#cnote").html(msg);
          $("#cnote").slideDown();
        }
      }
    });
    return false;
  });
  /******
   * 4. Contact form [-]
   ******/


  /******
   * 5. File uploader [+]
   ******/

  if ($("#fileupload").length) {

    if (jsVars.isMSIE && jsVars.MSIE_version < 9) {
      $(".fileinput-button input").fadeTo(0,1);
      $(".fileinput-button span").text("");
    }


    if (jsVars.maxRcpt > 1) {


      $("input.js-tagsinput").tagsinput({
        // tagClass: 'label label-primary',
        tagClass: function(item) {
          var tagClass = 'label label-primary';
          $.ajax({
            type: "POST",
            url: "functions.ajax.php",
            dataType: 'json',
            async: false,
            data: {"action":"validateEmail","email":item},
            success: function(msgObj) {
              if (msgObj.isValid) {
                tagClass = 'label label-primary';
              } else {
                tagClass = 'label label-danger';
              }
            }
          });
          return tagClass;
        },
        confirmKeys: [13, 44, 32],
        maxTags: jsVars.maxRcpt
      });
      //style corrections
      if (!jsVars.isMSIE) {
        $('.bootstrap-tagsinput').copyCSS($("input[name='mailFrom']")).css({"min-height":$("input[name='mailFrom']").css("height"),"height":"auto"});
      }
      // $('.bootstrap-tagsinput input').focus(function() {
      //   $('.bootstrap-tagsinput').addClass("bootstrap-tagsinput-focus");
      // }).blur(function() {
      //   $('.bootstrap-tagsinput').removeClass("bootstrap-tagsinput-focus");
      // });

      $(".bootstrap-tagsinput input").on("keydown",function() {
        $(this).css("width",$(this).val().length +"em");
      });
    }

    //for the dropdowns [+]
    $.fn.followLink = function() {
      var URL = $(this).closest("div").parent().find("input").val();
      $(this).closest('.dropdown-menu').dropdown("toggle");
      window.open(URL);
      return false;
    }

    $.fn.generateQRCode = function() {
      var URL = $(this).closest("div").parent().find("input").val();
      bootbox.alert({title: jsVars.lang_hl_qr_code,message: '<p class="text-center"><img src="http://' + mt_rand(0,9) + '.chart.apis.google.com/chart?chs=150&amp;cht=qr&amp;chl=' + encodeURI(URL) + '&amp;choe=UTF-8&amp;chld=|0" alt="' + URL + '" />'});
      $(this).closest('.dropdown-menu').dropdown("toggle");
      return false;
    }

    $.fn.shortenURL = function() {
      if ($(this).hasClass("js-URL-shortened")) {
        return false;
      }
      $(this).addClass("js-URL-shortened"); 
      var URL = $(this).closest("div").parent().find("input").val();
      var INPUT = $(this).closest("div").parent().find("input");
      var LINK = $(this);
      $.ajax({
        type: "POST",
        url: "functions.ajax.php",
        dataType: 'json',
        async: false,
        data: {"action":"shortenURL","url":URL},
        success: function(msgObj) {
          if (msgObj.error) {
            new PNotify({title: jsVars.lang_errors_occurred,text: msgObj.error, type: "error"});
          } else {
            $(INPUT).val(msgObj.shortURL);
            $(LINK).html("<s class='text-muted'>" + $(LINK).html() + "</s>");
          }
        }
      });
      $(this).closest('.dropdown-menu').dropdown("toggle");
      return false;
    }

    $.fn.ENcopy2Clipboard = function() {
      if (jsVars.isMSIE && jsVars.MSIE_version < 9) {
        return false;
      }
      ZeroClipboard.destroy();
      ZeroClipboard.config( { swfPath: "js/ZeroClipboard.swf" } );
      var client = new ZeroClipboard($(".js-copy-URL"));
      $(".js-copy-URL").click(function() {
        return false;
      });
      client.on( 'ready', function(event) {
        $(".js-copy-URL").parent("li").removeClass("js-hide");
        client.on( 'copy', function(event) {
          var URL = $(event.target).closest("div").parent().find("input").val();
          event.clipboardData.setData('text/plain', URL);
          new PNotify({title: "Copy success",text: 'successfully added <code>' + URL + '</code> to your clipboard',type: "success",width:"auto"});
        });
      });
    }

    $.fn.shareOnFacebook = function() {
      var URL = $(this).closest("div").parent().find("input").val();
      var sharingURL = 'https://www.facebook.com/sharer.php?u=' + URL;
      window.open(sharingURL, (jsVars.isMSIE && jsVars.MSIE_version < 9) ? '' : 'SFS-FB-Sharing', 'left=100,top=100,width=600,height=400,personalbar=0,toolbar=0,scrollbars=1,resizable=1');
      $(this).closest('.dropdown-menu').dropdown("toggle");
      return false;
    }

    $.fn.shareOnTwitter = function() {
      var URL = $(this).closest("div").parent().find("input").val();
      var sharingURL = 'http://twitter.com/home?status=' + encodeURI("Check out my new upload on " + URL);
      window.open(sharingURL, (jsVars.isMSIE && jsVars.MSIE_version < 9) ? '' : 'SFS-Twitter-Sharing', 'left=100,top=100,width=600,height=400,personalbar=0,toolbar=0,scrollbars=1,resizable=1');
      $(this).closest('.dropdown-menu').dropdown("toggle");
      return false;
    }

    $.fn.shareOnGoogle = function() {
      var URL = $(this).closest("div").parent().find("input").val();
      var sharingURL = 'https://plus.google.com/share?url=' + URL;
      window.open(sharingURL, (jsVars.isMSIE && jsVars.MSIE_version < 9) ? '' : 'SFS-Google-Sharing', 'left=100,top=100,width=600,height=400,personalbar=0,toolbar=0,scrollbars=1,resizable=1');
      $(this).closest('.dropdown-menu').dropdown("toggle");
      return false;
    }

    //for the dropdowns [-]

    $(document).bind('drop dragover', function (e) {
        e.preventDefault();
    });
    $(function () {
      var DownLink; var DelLink; var abortCnt = 0; var initTime; var thisTime; var speed; var timeElapsed = 0; var filesUpped;
      $("#fileupload").fileupload({
        formData: {u_key: $("input[name='u_key']").val()},
        add: function (e, data) {
            var extErrors = new Array(); var sizeErrors = new Array(); var extAllowedErrors = new Array(); 
            $.each(data.originalFiles, function (index, file) {
                //extensions check - for all
                var ext = file.name.split(".").pop().toLowerCase();
                if (jsVars.extDenied.length && ext && in_array(ext,jsVars.extDenied)) {
                  extErrors.push(file.name);
                }
                if (jsVars.extAllowed.length && ext && !in_array(ext,jsVars.extAllowed)) {    
                  extAllowedErrors.push(file.name);
                }
                //filesize check for all
                if (file.size > jsVars.maxFileSizeB) {
                 sizeErrors.push(file.name);
              }
            });
            if ($("#singleUploader").is(":hidden")) {
              //allowed to add files to current upload session
              if (jsVars.addAnotherFiles) {
                $("#singleUploadSucceeded,#multiUploadSucceeded").slideUp(function() {
                  $("#singleUploader").slideDown();
                  $(".js-btn-backto").fadeIn();
                  $(".cancelUpload,.progress,.speedIndicator").hide();
                  $(".fileinput-button,#uploadInfo").show();
                });
              } 
              //NOT allowed to add files to current upload session
              else {
                new PNotify({title: "Upload Error",text: jsVars.lang_error_continue_session, type: "error"});
                return false;                
              }
            }
            filesCount = data.originalFiles.length;
            if (!jsVars.multiUpload && filesCount > 1) {
              new PNotify({title: "File Count Error",text: jsVars.lang_error_just_one_file, type: "error"});
              if (filesUpped == 1) $(".js-btn-backto").fadeIn();
              return false;
            } else if (jsVars.multiUpload && filesCount > jsVars.maxMultiFiles) {
              new PNotify({title: "File Count Error",text: jsVars.lang_error_max_files, type: "error"});
              if (filesUpped == 1) $(".js-btn-backto").fadeIn();
              return false;
            } else if (sizeErrors.length) {
              if (filesCount > 1) new PNotify({title: "File Size Error",text: jsVars.lang_error_max_size_multi + sizeErrors.join(", "),type: "error"});
              else new PNotify({title: "File Size Error",text: jsVars.lang_error_max_size,type: "error"});
              if (filesUpped == 1) $(".js-btn-backto").fadeIn();
              return false;
            } else if (extErrors.length) {
              if (filesCount > 1) new PNotify({title: "File Extension Error",text: jsVars.lang_error_extension_denied_multi + extErrors.join(", "),type: "error"});
              else new PNotify({title: "File Extension Error",text: jsVars.lang_error_extension_denied,type: "error"});
              if (filesUpped == 1) $(".js-btn-backto").fadeIn();
              return false;
            } else if (extAllowedErrors.length) {                
              if (filesCount > 1) new PNotify({title: "File Extension Error",text: jsVars.lang_error_extension_denied_multi + extAllowedErrors.join(", "),type: "error"});
              else new PNotify({title: "File Extension Error",text: jsVars.lang_error_extension_denied,type: "error"});
              if (filesUpped == 1) $(".js-btn-backto").fadeIn();
              return false;
            } else {
              var uploader = data.submit();
            }
            $('button.cancelUpload').click(function (e) {
              abortCnt++;
              if (filesUpped == 1) {
                $(".js-btn-backto").fadeIn();
              }
              if(typeof uploader != 'undefined') {
                uploader.abort();
                if (!abortCnt) new PNotify({title: "Upload Aborted",type: "warning"});
                return false;
              }
          });
        },
        start: function (e) {
          filesUpped = parseInt($("input[name='filesUpped']").val());
          initTime = new Date().getTime();
          $(".js-btn-backto").fadeOut();
          $(".fileinput-button").fadeOut(function() { $(".cancelUpload").fadeIn() } );
          $("#uploadInfo").slideUp(function() {$(".progress,.speedIndicator").fadeIn();});
        },
        dataType: "json",
        progressall: function (e, data) {
            var progress = parseInt(data.loaded / data.total * 100, 10);
            $(".progress .progress-bar").css("width",progress + "%");
            if (progress < 20) {
              $(".progress .progress-bar").not(".progress-bar-danger").addClass("progress-bar-danger");            
            } else if (progress < 40) {
              $(".progress .progress-bar").not(".progress-bar-warning").addClass("progress-bar-warning").removeClass("progress-bar-danger");            
            } else if (progress < 60) {
              $(".progress .progress-bar").not(".progress-bar-info").addClass("progress-bar-info").removeClass("progress-bar-warning");            
            } else if (progress < 80) {
              $(".progress .progress-bar").not(".progress-bar-primary").addClass("progress-bar-primary").removeClass("progress-bar-info");            
            } else {
              $(".progress .progress-bar").not(".progress-bar-success").addClass("progress-bar-success").removeClass("progress-bar-primary");
            }
            var thisTime = new Date().getTime();
            var timeElapsed = (thisTime- initTime) / 1000;
            var timeTotal = parseInt(data.total / (data.loaded / timeElapsed));
            var speed = fsize(data.loaded / timeElapsed) + "/s";
            if (progress < 99) {
              if ($("div.visible-xs").is(":visible")) {
                $(".progress .pct").html(fsize(data.loaded) + " / " + fsize(data.total));
              } else {
                $(".progress .pct").html(progress + "% <small>" + fsize(data.loaded) + " / " + fsize(data.total) + " </small>");
              }
            } else {
              //99 and 100% ... great jump - but okay :)
              $(".progress .pct").html(jsVars.lang_descr_finishing_upload);
              $(".progress .progress-bar").css("width","100%");
            }
            $(".speedIndicator span.upload-speed").text(speed);
            $(".speedIndicator span.upload-time").text(secConv(parseInt(timeElapsed)) + " / " + secConv(timeTotal));
        },
        stop: function () {
          if (!abortCnt) {
            $("#landingInfoRow").fadeOut();
            if (filesCount > 1 || filesUpped > 0) {
                $("#singleUploader").fadeOut(function(){$("#multiUploadSucceeded").fadeIn()});
            }
            $("input[name='filesUpped']").val(1);
            $(document).ENcopy2Clipboard();
          } else {
            $(".progress,button.cancelUpload,.speedIndicator").fadeOut( function() { $(".fileinput-button").fadeIn(); $("#uploadInfo").slideDown()});
            abortCnt = 0;
          }
          // new PNotify({title: "Upload success",text: "all files upped",type: "success"});
        },
        done: function (e, data) { //each file done
          if (!abortCnt) {
            $.each(data.result.files, function (index, file) {
              if (file.error) {
                new PNotify({title: "Upload API error",text: file.error,type: "error"});
                // $(".cancelUpload").fadeOut(function() { $(".fileinput-button").fadeIn() } );
                // $(".progress,.speedIndicator").fadeOut(function() {$("#uploadInfo").slideDown();});
                $(".cancelUpload").trigger("click");
              } else {
                new PNotify({title: "Upload success",text: file.realName + " upped",type: "success"});
                var DownLink = jsVars.baseDownloadUrl + file.fileKey + ".html";
                var DelLink = jsVars.baseDeleteUrl + file.delFileKey + ".html";
                if (filesUpped == 0 && filesCount == 1) {
                  $("#singleUploadSucceeded .susFName .js-susDataHeadline").html(file.realName + ' <i class="small">' + file.niceSize + '</i>');
                  $("#singleUploadSucceeded input[name='susDownloadLink']").val(DownLink);
                  $("#singleUploadSucceeded input[name='susDeleteLink']").val(DelLink);                  
                  $("#singleUploadSucceeded button.btndown").click( function() { window.open(DownLink); return false; } );
                  $("#singleUploadSucceeded button.btndel").click( function() { window.open(DelLink); return false; } );
                  $("#singleUploadSucceeded .js-follow-link").click(function(){ return $(this).followLink(); });
                  $("#singleUploadSucceeded .js-generate-QR").click(function(){ return $(this).generateQRCode(); });
                  $("#singleUploadSucceeded .js-shorten-URL").click(function(){ return $(this).shortenURL(); });
                  $("#singleUploadSucceeded .js-share-facebook").click(function() { return $(this).shareOnFacebook(); });
                  $("#singleUploadSucceeded .js-share-twitter").click(function() { return $(this).shareOnTwitter(); });
                  $("#singleUploadSucceeded .js-share-google").click(function() { return $(this).shareOnGoogle(); });                
                  if (smallDevice) $("#singleUploadSucceeded .input-group").removeClass("input-group-lg");
                  $("#singleUploader").fadeOut(function(){$("#singleUploadSucceeded").fadeIn()});
                }
                //for multiple files now on single uploads too - because of the possibility to add files to current upload sessions
                var multiItem = $("#multiUploadSucceeded .multiItem.js-hide").clone();
                $(multiItem).find(".musFName .js-musDataHeadline").html(file.realName + ' <i class="small">' + file.niceSize + '</i>');
                $(multiItem).removeClass("js-hide");
                $(multiItem).find("input[name='musDownloadLink']").val(DownLink);
                $(multiItem).find("input[name='musDeleteLink']").val(DelLink);
                $(multiItem).find("button.btndown").click( function() { window.open(DownLink); return false; } );
                $(multiItem).find("button.btndel").click( function() { window.open(DelLink); return false; } );
                $(multiItem).find("input[name='musDownloadLink']").click( function(){ $(this).select(); } );
                $(multiItem).find("input[name='musDeleteLink']").click( function(){ $(this).select(); } );
                $(multiItem).find(".js-follow-link").click(function(){ return $(this).followLink(); });
                $(multiItem).find(".js-generate-QR").click(function(){ return $(this).generateQRCode(); });
                $(multiItem).find(".js-shorten-URL").click(function(){ return $(this).shortenURL(); });
                $(multiItem).find(".js-share-facebook").click(function() { return $(this).shareOnFacebook(); });
                $(multiItem).find(".js-share-twitter").click(function() { return $(this).shareOnTwitter(); });
                $(multiItem).find(".js-share-google").click(function() { return $(this).shareOnGoogle(); });
                if (!$("#multiUploadSucceeded .multiItem.multiItemFirst").length) {
                  $(multiItem).addClass("multiItemFirst");
                }
                $("#multiUploadSucceeded .multiItems").append(multiItem);
                if (smallDevice) $("#multiUploadSucceeded .input-group").removeClass("input-group-lg");
              }
            });
          }
        }
      });
      $("#singleUploadSucceeded input[name='susDownloadLink'],#singleUploadSucceeded input[name='susDeleteLink'],#multiUploadSucceeded input[name='musGroupLink']").click( function(){ $(this).select(); } );
      $("#multiUploadSucceeded button.btngrp").click( function() { window.open($("#multiUploadSucceeded input[name='musGroupLink']").val()); return false; } );
      $("#multiUploadSucceeded .js-follow-link").click(function(){ return $(this).followLink() });
      $("#multiUploadSucceeded .js-generate-QR").click(function(){ return $(this).generateQRCode() });
      $("#multiUploadSucceeded .js-shorten-URL").click(function(){ return $(this).shortenURL() });
      $("#multiUploadSucceeded .js-share-facebook").click(function() { return $(this).shareOnFacebook(); });
      $("#multiUploadSucceeded .js-share-twitter").click(function() { return $(this).shareOnTwitter(); });
      $("#multiUploadSucceeded .js-share-google").click(function() { return $(this).shareOnGoogle(); });  
      $("#multiUploadSucceeded .js-shorten-URL-all").click(function() {
        $("#multiUploadSucceeded .js-shorten-URL").each(function() {
          $(this).trigger("click");
        })
        return false;
      });


      $("#agree2terms").change(function() {
        if ($(this).is(":checked")) {
          $(".sendLinkInfo").attr("disabled",false);
        } else {
          $(".sendLinkInfo").attr("disabled",true);
        }
     });
      $("#agree2termsMulti").change(function() {
        if ($(this).is(":checked")) {
          $(".sendLinkInfoMulti").attr("disabled",false);
        } else {
          $(".sendLinkInfoMulti").attr("disabled",true);
        }
     });
     $("a[href='#terms']").click(function() { 
      bootbox.dialog({"message":$("#terms").html(),
        buttons: {"cancel": { className: "btn-default", label: "OK", callback: function() { bootbox.hideAll(); } }
      }});
      return false;
     });


      /****** increase sharing form for MULTI and SINGLE uploads ******/
      $(".addmessage").on("click", function() {
        $(this).fadeOut("fast",
          function() {
            $(this).closest(".row").find(".js-message-wrapper").fadeIn();
          });
        return false;
      });


      /****** SINGLE Send Linkinfos to sender and receipient ******/
      $(".sendLinkInfo").on("click",function () {

        var thisSendBtn = $(this);

        $("#singleUploadSucceeded .sendLinkMsgs").hide();

        var DownLink = $("#singleUploadSucceeded input[name='susDownloadLink']").val();
        var DelLink = $("#singleUploadSucceeded input[name='susDeleteLink']").val();
        var mailFrom = $("#singleUploadSucceeded input[name='mailFrom']").val();
        var mailTo = $("#singleUploadSucceeded input[name='mailTo']").val();
        var message = $("#singleUploadSucceeded textarea[name='message']").val();
        var u_key = $("input[name='u_key']").val();
        var show_message = $("#singleUploadSucceeded input[name='show_message']").is(":checked")?1:0;

        if (mailTo && mailFrom) {

          $(thisSendBtn).attr("disabled",true);
          $(thisSendBtn).find("i").removeClass("fa-send").addClass("fa-circle-o-notch fa-spin");

          $.ajax({
           type: "POST",
           url: "functions.ajax.php",
           data: {"action":"sendFileInfo","DownLink":DownLink,"DelLink":DelLink,"mailFrom":mailFrom,"mailTo":mailTo,"message":message,"show_message":show_message,"u_key":u_key},
           success: function(msg){

            $(thisSendBtn).attr("disabled",false);
            $(thisSendBtn).find("i").addClass("fa-send").removeClass("fa-circle-o-notch fa-spin");

            if(msg == "OK") {
              $("#sendLinkInfoForm").append("<div class='alert alert-success js-hide span8 mt20 successmess'><button type='button' class='close'>&times;</button>" + jsVars.lang_success_info_sent + "</div>");
              $("#sendLinkInfoForm form").fadeOut( function() {
                $("#sendLinkInfoForm .successmess").fadeIn();
              });
              $("#singleUploadSucceeded .close").on("click", function() {
                $("#singleUploadSucceeded input[name='mailFrom'],#singleUploadSucceeded input[name='mailTo'],#singleUploadSucceeded textarea[name='message']").val("");
                $("#singleUploadSucceeded .js-message-wrapper").fadeOut();
                $("#singleUploadSucceeded #agree2terms, #singleUploadSucceeded input[name='show_message']").attr("checked",false);
                $("#singleUploadSucceeded .sendLinkInfo").attr("disabled",true);
                $(this).parent().fadeOut();
                $("#singleUploadSucceeded .addmessage").fadeIn();
                $("#sendLinkInfoForm form").fadeIn();
                $(this).parent().remove();
              });
              if (jsVars.maxRcpt > 1) {
                $("input.js-tagsinput").tagsinput('removeAll');
              }
            } else {
              $("#singleUploadSucceeded .sendLinkMsgs").text(msg);
              $("#singleUploadSucceeded .sendLinkMsgs").fadeIn();
            }
          }
         });
        } else {
           $("#singleUploadSucceeded .sendLinkMsgs").text(jsVars.lang_error_both_fields_required);
           $("#singleUploadSucceeded .sendLinkMsgs").fadeIn();
        }
        return false;
      });

      /****** MULTI Send Linkinfos to sender and receipient ******/
      $(".sendLinkInfoMulti").on("click",function () {

        var thisSendBtn = $(this);

        $("#multiUploadSucceeded .sendLinkMsgs").hide();

        var mailFrom = $("#sendLinkInfoFormMulti input[name='mailFrom']").val();
        var mailTo = $("#sendLinkInfoFormMulti input[name='mailTo']").val();
        var message = $("#sendLinkInfoFormMulti textarea[name='message']").val();
        var u_key = $("#sendLinkInfoFormMulti input[name='multi_u_key']").val();
        var show_message = $("#sendLinkInfoFormMulti input[name='show_message']").is(":checked")?1:0;

        if (mailTo && mailFrom) {
          
          $(thisSendBtn).attr("disabled",true);
          $(thisSendBtn).find("i").removeClass("fa-send").addClass("fa-circle-o-notch fa-spin");

          $.ajax({
           type: "POST",
           url: "functions.ajax.php",
           data: {"action":"sendMultiFileInfo","u_key":u_key,"mailFrom":mailFrom,"mailTo":mailTo,"message":message,"show_message": show_message},
           success: function(msg){

            $(thisSendBtn).attr("disabled",false);
            $(thisSendBtn).find("i").addClass("fa-send").removeClass("fa-circle-o-notch fa-spin");

            if(msg == "OK") {
              $("#sendLinkInfoFormMulti").append("<div class='alert alert-success js-hide span8 mt20 successmess'><button type='button' class='close'>&times;</button>" + jsVars.lang_success_info_sent + "</div>");
              $("#sendLinkInfoFormMulti form").fadeOut( function() {
                $("#sendLinkInfoFormMulti .successmess").fadeIn();
              });
              $("#multiUploadSucceeded .close").on("click", function() {
                $("#multiUploadSucceeded input[name='mailFrom'],#multiUploadSucceeded input[name='mailTo'],#multiUploadSucceeded textarea[name='message']").val("");
                $("#multiUploadSucceeded .js-message-wrapper").fadeOut();
                $("#agree2termsMulti, #multiUploadSucceeded input[name='show_message']").attr("checked",false);
                $(".sendLinkInfoMulti").attr("disabled",true);
                $(this).parent().fadeOut();
                $("#multiUploadSucceeded .addmessage").fadeIn();
                $("#sendLinkInfoFormMulti form").fadeIn();
                $(this).parent().remove();
              });
              if (jsVars.maxRcpt > 1) {
                $("input.js-tagsinput").tagsinput('removeAll');
              }
            } else {
              $("#multiUploadSucceeded .sendLinkMsgs").text(msg);
              $("#multiUploadSucceeded .sendLinkMsgs").fadeIn();
            }
          }
         });
        } else {
           $("#multiUploadSucceeded .sendLinkMsgs").text(jsVars.lang_error_both_fields_required);
           $("#multiUploadSucceeded .sendLinkMsgs").fadeIn();
        }
        return false;
      });


    });

  }
  /******
   * 5. File uploader [-]
   ******/


  /******
   * 6. Admin-login Autofocus  [+]
   ******/
  if ($("#loginF").length) {
    if (!$("input[name='user']").val()) {
      $("input[name='user']").focus();
    } else {
      $("input[name='pass']").focus();
    }
  }
  /******
   * 6. Admin-login Autofocus  [-]
   ******/


  /******
   * 7. Admin: Datatables  [+]
   ******/
  if ($("table#filesDataTable").length) {
    /** paginginfo plugin **/
    $.fn.dataTableExt.oApi.fnPagingInfo = function ( oSettings ) {
      return {
        "iStart":         oSettings._iDisplayStart,
        "iEnd":           oSettings.fnDisplayEnd(),
        "iLength":        oSettings._iDisplayLength,
        "iTotal":         oSettings.fnRecordsTotal(),
        "iFilteredTotal": oSettings.fnRecordsDisplay(),
        "iPage":          oSettings._iDisplayLength === -1 ? 0 : Math.ceil( oSettings._iDisplayStart / oSettings._iDisplayLength ),
        "iTotalPages":    oSettings._iDisplayLength === -1 ? 0 : Math.ceil( oSettings.fnRecordsDisplay() / oSettings._iDisplayLength )
      };
    };
    /****** the datatable ******/
    var toolsCellWidth = "135px";
    if ($("body#BS-cosmo,body#BS-journal,body#BS-readable,body#BS-superhero").length) toolsCellWidth = "145px";
    else if ($("body#BS-yeti").length) toolsCellWidth = "155px";

    var oTable = $('#filesDataTable').dataTable( {
        "bProcessing": true,
        "bServerSide": true,
        "sAjaxSource": "admin.files.data.php",
        "aaSorting": [[ 0, "desc" ]],
        "sDom": "<'row mb20'<'col-sm-6'l><'col-sm-6'f>r>t<'row'<'col-sm-6'i><'col-sm-6'p>>",
        "sPaginationType": "bootstrap",
        "oLanguage": {
          "sProcessing": "<i class='fa fa-clock-o'></i> Loading Files Data"
        },
        "aoColumns": [
          { "sWidth": "50px"},
          {  },
          { "sWidth": "120px"},
          { "sWidth": "180px" },
          { "sWidth": "100px"},
          { "sWidth": toolsCellWidth, "sClass": "tac"},
        ],
        "aoColumnDefs": [
          { "bSearchable": false, "aTargets": [0,2] },
          { "bSortable": false, "aTargets": [0,5] } ],
        "fnDrawCallback": function() {

          /** tooltips [+] **/
          $('#filesDataTable tr>td:first-child + td').each( function() {
            $(this).attr("title",$(this).find("span").html());
          });
          $('#filesDataTable tr>td:first-child + td').tooltip({container:"body",html:true});
          /** tooltips [-] **/

          $('.dataTables_filter input').attr("placeholder","minlength:3");
          /****** admin function:delete file ******/
          $(".delFile").click( function() {
            var indexOfRow = oTable.fnGetPosition( $(this).closest('tr').get(0) );
            var url = $(this).attr("href");
            var fid = getGetVars(url,"fid");
            var thisTR = $(this).closest('tr');

            $(thisTR).addClass("warning");

            function delFile(fid,indexOfRow) {
              $.ajax({
                 type: "POST",
                 url: "functions.ajax.php",
                 data: {"action":"delFile","fid":fid},
                 success: function(msg) {
                  if(msg == "OK") {
                    new PNotify({title: "Operations completed",text: "The file was removed successfully.", type: "success"});
                    var page = oTable.fnPagingInfo().iPage;
                    oTable.fnDeleteRow(indexOfRow, function(){oTable.fnPageChange(page);}, false);
                  } else {
                    new PNotify({title: jsVars.lang_errors_occurred,text: msg, type: "error"});
                  }
                }
              });
            }
            if ($("#TempbypassConfirming").is(":checked")) {
              delFile(fid,indexOfRow);
              return false;
            }
            bootbox.confirm("<h4>Are you sure to delete this file?</h4><p>This Action cannot be undone!<br /><div class='checkbox'><label class='checkbox'><input type='checkbox' name='bypassConfirming' id='bypassConfirming' value='1' />Don't ask again for this action for the next times.</label></div></p>", 
              function(stat) {
                if (stat) {
                  if ($("#bypassConfirming").is(":checked")) {
                    $("#TempbypassConfirming").prop("checked",true);
                  }
                  delFile(fid,indexOfRow);
                } else {
                  $(thisTR).removeClass("warning");            
                }
            });
            return false;
          });
          $(".js-btn-lockFile").click( function() {
            var indexOfRow = oTable.fnGetPosition( $(this).closest('tr').get(0) );
            var url = $(this).attr("href");
            var fid = getGetVars(url,"fid");
            var action = getGetVars(url,"action");
            var thisTR = $(this).closest('tr');

            var thisBtn = this;

            $(thisTR).addClass("warning");

            $.ajax({
              type: "POST",
              url: "functions.ajax.php",
              data: {"action":"handleFileLock","lockAction":action,"fid":fid},
              success: function(msg) {
                if(msg == "OK") {
                  new PNotify({title: "Operations completed",text: action == "lockFile" ? "The file was locked successfully." : "The file was unlocked successfully.", type: "success",before_close: function() { $(thisTR).removeClass("warning"); } });
                  if (action == "lockFile") {
                    $(thisBtn).addClass("btn-warning").removeClass("btn-default").attr({"href":url.replace("=lockFile","=unlockFile"),"title":"PROTECTED: click to enable autodeletion of this file"});
                    $(thisBtn).find("i").addClass("fa-unlock").removeClass("fa-lock");
                  } else if (action == "unlockFile") {
                    $(thisBtn).addClass("btn-default").removeClass("btn-warning").attr({"href":url.replace("=unlockFile","=lockFile"),"title":"NOT PROTECTED: click to protect from autodeleting this file"});
                    $(thisBtn).find("i").addClass("fa-lock").removeClass("fa-unlock");
                  }
                } else {
                  new PNotify({title: jsVars.lang_errors_occurred,text: msg, type: "error"});
                }
              }
            });
            return false;
          });
        }
      });
    /****** searchform Class ******/
    // $.extend( $.fn.dataTableExt.oStdClasses, {
    //   "sWrapper": "dataTables_wrapper form-inline"
    // });
      $('div.dataTables_filter input,div.dataTables_wrapper select').addClass('form-control input-sm');
  }
  /******
   * 7. Admin: Datatables  [-]
   ******/


  /******
   * 8. Admin: Flot Charts [+]
   ******/
  if ($(".flot").length) {
    /****** fill jsvars with charts data ******/
    var chartsData;
    $.ajax({
      url: "admin.charts.data.php",
      type: 'get',
      dataType: 'json',
      async: false,
      success: function(data) {
          chartsData = data;
      }
    });
    /****** filetypes - PieDonut Chart ******/
    if (chartsData.pieData != null) {
      $.plot($('#filetypes .flot'), chartsData.pieData, {
        grid : { hoverable : false }, 
        series : { pie: { show: true, radius: 1, tilt: 0.5, innerRadius: 0.5, label: { show: true, background: { color: "#fff", opacity: 0.8 }, formatter: function(label) { return "<div class='flotdescr'>" + label + "</div>"; } } } },
        yaxis: {tickDecimals:0, max: 6214.8}, legend: {noColumns:4,margin:0,backgroundColor:'#efefef'}
      });
    }
   
    /****** Uploads and Sizes - Linegraph ******/
    if (chartsData.lineData != null) {
      $("#updownloads").css("padding","0 25px");
      $.plot($('#updownloads .flot'), chartsData.lineData, { 
            xaxis: {ticks: chartsData.lineXticks,tickDecimals:0 }
      });
    }

    /****** panel hiding of inactive ones, they have to be active for flot printing first ******/
    var cnt = 0;
    $(".SFSCharts div.panel-collapse").each( function() {
      if (cnt) {
        $(this).removeClass("in");  
      }
      cnt++;
    });
  }
  /******
   * 8. Admin: Flot Charts [-]
   ******/


  /******
   * 9. Wait X Seconds before download Countdown [+]
   ******/
   if ($(".btn-download #dlCD").length && jsVars.downloadSeconds > 0) {
    $(".btn-download").click(function() {
     if ($(this).hasClass("disabled")) return false;
    });
    var dwnBtn = $(".btn-download");
    var dwnBtnText = $(".btn-download .dwnin");
    $('#dlCD span').countDown({
        startFontSize: 8,
        endFontSize: 17.5,
        startNumber: jsVars.downloadSeconds,
        callBack: function(me) {
          $(dwnBtn).removeClass("disabled").addClass("btn-success").removeClass("btn-warning");
          $(dwnBtn).find("i").attr("class","fa fa-download fa-fw");
          $(dwnBtnText).text("Download");
        }
      });
   }
  /******
   * 9. Wait X Seconds before download Countdown [-]
   ******/


  /******
   * 10. SINGLE: Password protect download links [+]
   ******/
  $("input#passwordProtection").change(function() {
    $(".susPassword").removeClass("muted text-info text-danger").hide();
    var pwdProtection = $(this).is(":checked");
    var downloadLink = $("input[name='susDownloadLink']").val();
    $.ajax({
       type: "POST",
       url: "functions.ajax.php",
       dataType: 'json',
       async: false,
       data: {"action":"pwdProtection","downloadLink":downloadLink,"protection":pwdProtection},
       success: function(msgObj) {
        if (msgObj.error) {
          $(".susPassword").text(msgObj.error);
          $(".susPassword").addClass("text-danger").fadeIn();
        } else {
          $(".susPassword").text(msgObj.statmess);
          if (msgObj.protection == 1) $(".susPassword").addClass("text-info").fadeIn();
          else $(".susPassword").addClass("muted").fadeIn();
        }
      }
     });
  });
  /******
   * 10. SINGLE: Password protect download links [-]
   ******/


  /******
   * 11. Verify password protected download links [+]
   ******/
  $(".btn-download.pwd-protected").click(function() {
    if ($(this).hasClass("disabled")) return false;
    var downloadLink = $(this).attr("href");
    bootbox.dialog({
      title: jsVars.lang_password_modal_hl,
      message: "<div class='form-inline'>"+
        "<div class='text-center pwdChecker'><div class='alert alert-danger js-hide'></div><input type='password' name='password' placeholder='" + jsVars.lang_password_modal_placeholder + "' required class='form-control input-lg'/></div></div>",
     buttons: {
        "cancel" : { label: jsVars.lang_cancel, className : "btn-default", callback: function() { bootbox.hideAll(); } },
        "verify" : { label: jsVars.lang_verify_pwd, className : "btn-primary submitData", callback: function() { 
            $(".pwdChecker .alert").hide();

            var proceed = false;
            var pwd = $(".modal-body input[name='password']").val();
            if (!pwd) {
              $('.pwdChecker .alert').text(jsVars.lang_error_enter_password).fadeIn();
            } else {
              $.ajax({
               type: "POST",
               url: relDir + "functions.ajax.php",
               dataType: 'json',
               async: false,
               data: {"action":"verifyPwd","downloadLink":downloadLink,"pwd":pwd},
               success: function(msgObj) {
                if (msgObj.error) {
                  $('.pwdChecker .alert').text(msgObj.error).fadeIn();
                } else {
                  if (msgObj.verified) {
                    window.location.href=downloadLink;
                    proceed = true;
                  } else {
                    $('.pwdChecker .alert').text("something went wrong?!?").fadeIn();
                  }
                }
              }
             });
            }
            return proceed;
          } 
        }
      }
     });
    return false;
  });
  /******
   * 11. Verify password protected download links [-]
   ******/


  /******
   * 12. Abuse form [+]
   ******/
  $("form#abusef").submit(function() {
    $("#cnote").slideUp();
    var str = $(this).serialize();
    $.ajax({
      type: "POST",
      url: "functions.ajax.php",
      data: str,
      success: function(msg){ 
        if(msg == 'OK') {
          $("#cnote").html('<div class="alert alert-success">' + jsVars.lang_success_mess_sent + '<\/div>');
          $("#cnote").slideDown();
          $("form#abusef").fadeOut();
        } else {
          $("#cnote").html(msg);
          $("#cnote").slideDown();
        }
      }
    });
    return false;
  });
  /******
   * 12. Abuse form [-]
   ******/


  /******
   * 13. MULTI: Password protect download links [+]
   ******/
  $("input#passwordProtectionMulti").change(function() {
    $(".musPassword").removeClass("muted text-danger text-info").hide();
    var pwdProtection = $(this).is(":checked");
    var u_key = $("input[name='u_key']").val();
    $.ajax({
       type: "POST",
       url: "functions.ajax.php",
       dataType: 'json',
       async: false,
       data: {"action":"pwdProtectionMulti","u_key":u_key,"protection":pwdProtection},
       success: function(msgObj) {
        if (msgObj.error) {
          $(".musPassword").text(msgObj.error);
          $(".musPassword").addClass("text-danger").fadeIn();
        } else {
          $(".musPassword").text(msgObj.statmess);
          if (msgObj.protection == 1) $(".musPassword").addClass("text-info").fadeIn();
          else $(".musPassword").addClass("muted").fadeIn();
        }
      }
     });
  });
  /******
   * 13. MULTI: Password protect download links [-]
   ******/


  /******
   * 14. Filesgroup - options [+]
   ******/
  $(".filesgroup input.gDownloadLink").click( function(){ $(this).select(); } );
  $(".filesgroup button.btndown").click( function() {
    var URL = $(this).closest("div").parent().find("input").val();
    $(this).closest('.dropdown-menu').dropdown("toggle");
    window.open(URL);
    return false;
  });
  /******
   * 14. Filesgroup - options [-]
   ******/


  /******
   * 15. don't leave site willy-nilly [+]
   ******/
  $(window).bind("beforeunload",function(event) {
     if ($("#singleUploadSucceeded,#multiUploadSucceeded").is(":visible")) return jsVars.lang_leaving_site_info;
  });
  /******
   * 15. don't leave site willy-nilly [-]
   ******/


  /******
   * 16. prevent of re-clicking download button [+]
   ******/
  $(".download-button-wrapper .btn-download").click(function() {
    if ($(this).hasClass("disabled")) return false;
    else {
      $(this).addClass("disabled btn-default").html(jsVars.lang_download_has_started).removeClass("btn-success").blur();
      if ($(this).hasClass("pwd-protected")) return true;
      if (jsVars.isMSIE) {
        window.location.href=$(this).attr("href"); 
        return false;
      } else {
        return true;
      }
    }
    return false
  });
  /******
   * 16. prevent of re-clicking download button [-]
   ******/


  /******
   * 17. SINGLE: autodelete after X days or downloads - set by uploader [+]
   ******/
  $(".delXdays,.delXdownloads").fadeTo(0,0.5);

  //days
  $("select[name='delXdays']").change(function() {
    var delXdays = $(this).val();
    var downloadLink = $("input[name='susDownloadLink']").val();
    $(".delXdays").fadeTo("fast",delXdays == -1 ? 0.5 : 1);
    $.ajax({
       type: "POST",
       url: "functions.ajax.php",
       dataType: 'json',
       async: false,
       data: {"action":"setDelXdays","downloadLink":downloadLink,"delXdays":delXdays},
       success: function(msgObj) {
        if (msgObj.error) {
          $(".delXdays").text(msgObj.error);
          $(".delXdays").addClass("text-danger").fadeIn();
        }
      }
     });
  });

  //downloads
  $("select[name='delXdownloads']").change(function() {
    var delXdownloads = $(this).val();
    var downloadLink = $("input[name='susDownloadLink']").val();
    $(".delXdownloads").fadeTo("fast",delXdownloads == -1 ? 0.5 : 1);
    $.ajax({
       type: "POST",
       url: "functions.ajax.php",
       dataType: 'json',
       async: false,
       data: {"action":"setDelXdownloads","downloadLink":downloadLink,"delXdownloads":delXdownloads},
       success: function(msgObj) {
        if (msgObj.error) {
          $(".delXdownloads").text(msgObj.error);
          $(".delXdownloads").addClass("text-danger").fadeIn();
        }
      }
     });
  });
  /******
   * 17. SINGLE: autodelete after X days or downloads - set by uploader [-]
   ******/


  /******
   * 18. MULTI: autodelete after X days or downloads - set by uploader [+]
   ******/
  $(".delXdaysMulti,.delXdownloadsMulti").fadeTo(0,0.5);

  //days
  $("select[name='delXdaysMulti']").change(function() {
    var delXdays = $(this).val();
    var u_key = $("input[name='u_key']").val();
    $(".delXdaysMulti").fadeTo("fast",delXdays == -1 ? 0.5 : 1);
    $.ajax({
       type: "POST",
       url: "functions.ajax.php",
       dataType: 'json',
       async: false,
       data: {"action":"setDelXdaysMulti","u_key":u_key,"delXdays":delXdays},
       success: function(msgObj) {
        if (msgObj.error) {
          $(".delXdaysMulti").text(msgObj.error);
          $(".delXdaysMulti").addClass("text-danger").fadeIn();
        }
      }
     });
  });

  //downloads
  $("select[name='delXdownloadsMulti']").change(function() {
    var delXdownloads = $(this).val();
    var u_key = $("input[name='u_key']").val();
    $(".delXdownloadsMulti").fadeTo("fast",delXdownloads == -1 ? 0.5 : 1);
    $.ajax({
       type: "POST",
       url: "functions.ajax.php",
       dataType: 'json',
       async: false,
       data: {"action":"setDelXdownloadsMulti","u_key":u_key,"delXdownloads":delXdownloads},
       success: function(msgObj) {
        if (msgObj.error) {
          $(".delXdownloadsMulti").text(msgObj.error);
          $(".delXdownloadsMulti").addClass("text-danger").fadeIn();
        }
      }
     });
  });  
  /******
   * 18. MULTI: autodelete after X days or downloads - set by uploader [-]
   ******/


 
  /******
   * 19. CAPTCHA: just to reload the image [+]
   ******/
   $(".btn-captcha-refresh").click(function() {
    if ($(".img-captcha").length) {
      var imgSrc = $(".img-captcha").attr("src").replace(/\?.*$/,'');
      $(".img-captcha").fadeTo(500,0,function() {
        $(".img-captcha").attr("src",imgSrc + "?" + new Date().getTime()).load(function() { 
          $(".img-captcha").fadeTo(500,1);
        });
      });
    }
   });

  /******
   * 19. CAPTCHA: just to reload the image [-]
   ******/


  /******
   * 20. optical correction for superlong filenames on download and deletion pages [+]
   ******/

  $.fn.reStyleDFNAME = function() {
    var w = $(".dfname").closest("div[class^=col-]").width()-40;
    var ext = $(".dfname").html().replace(/<small.*$/,'').split(".").pop().toLowerCase();
    $(".dfname").attr("style","text-overflow:'..."+ext+"';max-width:"+w+"px;");
  }
  if ($(".dfname").length) {
    $(".dfname").reStyleDFNAME();
    $(window).resize(function () { 
      $(".dfname").reStyleDFNAME();
    });
  }

  /******
   * 20. optical correction for superlong filenames on download and deletion pages  [-]
   ******/


  /******
   * 21. optical correction for superlong filenames on admin dashboard's "The Last File"-section [+]
   ******/

  if ($(".js-truncate-width").length) {
    $(window).on("load resize",function(e) {
      $(".filename-truncate strong").fadeOut(0, function() {
          $(".filename-truncate strong").width($(".js-truncate-width").width()).fadeIn();
        });
    });
  }

  /******
   * 21. optical correction for superlong filenames on admin dashboard's "The Last File"-section [-]
   ******/


  /******
   * 22. add files to current upload session [+]
   ******/
   $("#multiUploadSucceeded .js-btn-add-files").click(function(){
      $("#multiUploadSucceeded").fadeOut(function(){$("#singleUploader").fadeIn()});
      $(".cancelUpload").fadeOut(function() { $(".fileinput-button").fadeIn() } );
      $(".progress,.speedIndicator").fadeOut(function() {$("#uploadInfo").slideDown();});
      $("input[name='backto']").val("multi");
      $(".js-btn-backto").fadeIn();
      return false;
   });

   $("#singleUploadSucceeded .js-btn-add-files").click(function(){
      $("#singleUploadSucceeded").fadeOut(function(){$("#singleUploader").fadeIn()});
      $(".cancelUpload").fadeOut(function() { $(".fileinput-button").fadeIn() } );
      $(".progress,.speedIndicator").fadeOut(function() {$("#uploadInfo").slideDown();});
      $("input[name='backto']").val("single");
      $(".js-btn-backto").fadeIn();
      return false;
   });

  /******
   * 22. add files to current upload session [-]
   ******/


  /******
   * 23. back to the uploaded file(s) [+]
   ******/
  $(".js-btn-backto").click(function() {
    $("#singleUploader").fadeOut(
      function() {
        if ($("input[name='backto']").val() == "single") {
          $("#singleUploadSucceeded").fadeIn();
        } else {
          $("#multiUploadSucceeded").fadeIn();          
        }
      });
  });
  /******
   * 23. back to the uploaded file(s) [-]
   ******/


  /******
   * 24. SINGLE: handle file descriptions [+]
   ******/

  /****** show file description field /hide field/ remove file description ******/
  $("#singleUploadSucceeded .js-btn-add-file-description").on("click", function() {
    var thisBtn = this;
    /** show field **/
    if ($(this).hasClass("btn-primary")) {
      $("#singleUploadSucceeded .js-file-description-wrapper").slideDown(400,function() {
        $(thisBtn).find("span").text(jsVars.lang_remove_file_description);
        $(thisBtn).removeClass("btn-primary").addClass("btn-default");
        $("#singleUploadSucceeded input[name='susFileDescription']").focus();
      });
    } else
    /** remove description/hide field **/
    if ($(this).hasClass("btn-default")) {
      var cnt=0;
      $(".js-file-description-wrapper").slideUp(400,function() {
        $("#singleUploadSucceeded input[name='susFileDescription']").val("");
        $(".js-btn-save-file-description").addClass("disabled btn-default").removeClass("btn-primary");
        $(thisBtn).find("span").text(jsVars.lang_add_file_description);
        $(thisBtn).addClass("btn-primary").removeClass("btn-default");
        var downloadLink = $("input[name='susDownloadLink']").val();
        if (!cnt++) {
          $.ajax({
            type: "POST",
            url: "functions.ajax.php",
            dataType: 'json',
            async: false,
            data: {"action":"updateFileDescription","downloadLink":downloadLink,"fileDescription":""},
            success: function(msgObj) {
              if (msgObj.error) {
                new PNotify({title: jsVars.lang_errors_occurred,text: msgObj.error, type: "error"});
              } else {
                new PNotify({text: jsVars.lang_success_removed_file_description, type: "success"});
                //update for the first multi item [+]
                $("#multiUploadSucceeded .multiItem.multiItemFirst input[name='musFileDescription']").val("");
                $("#multiUploadSucceeded .multiItem.multiItemFirst .js-file-description-wrapper").addClass("js-hide");
                $("#multiUploadSucceeded .multiItem.multiItemFirst .js-btn-add-file-description").find("span").text(jsVars.lang_add_file_description);
                $("#multiUploadSucceeded .multiItem.multiItemFirst .js-btn-add-file-description").removeClass("btn-default").addClass("btn-primary");
                //update for the first multi item [-]
              }
            }
          });
        }
      });
    }
    return false;
  });

  /** field observation **/
  $("#singleUploadSucceeded input[name='susFileDescription']").on("input", function() {
    if ($("#singleUploadSucceeded .js-btn-save-file-description").hasClass("disabled")) {
      $("#singleUploadSucceeded .js-btn-save-file-description").removeClass("disabled btn-default").addClass("btn-primary");
    }
  });

  /** update file description on pressing enter triggering click event some lines below **/
  $("#singleUploadSucceeded input[name='susFileDescription']").on("keydown",function(e) {
    if (!$("#singleUploadSucceeded .js-btn-save-file-description").hasClass("disabled") && e.keyCode == 13) { //Enter Key
       $('#singleUploadSucceeded .js-btn-save-file-description').trigger('click');
    }
  });
  /** update file description itself **/
  $("#singleUploadSucceeded .js-btn-save-file-description").on("click", function() {
    var fileDescription = $("#singleUploadSucceeded input[name='susFileDescription']").val();
    var downloadLink = $("input[name='susDownloadLink']").val();
    $.ajax({
       type: "POST",
       url: "functions.ajax.php",
       dataType: 'json',
       async: false,
       data: {"action":"updateFileDescription","downloadLink":downloadLink,"fileDescription":fileDescription},
       success: function(msgObj) {
        if (msgObj.error) {
          new PNotify({title: jsVars.lang_errors_occurred,text: msgObj.error, type: "error"});
        } else {
          new PNotify({text: jsVars.lang_success_updated_file_description, type: "success"});
          //update for the first multi item [+]
          $("#multiUploadSucceeded .multiItem.multiItemFirst input[name='musFileDescription']").val(msgObj.descr_long);
          $("#multiUploadSucceeded .multiItem.multiItemFirst .js-file-description-wrapper").removeClass("js-hide");
          $("#multiUploadSucceeded .multiItem.multiItemFirst .js-btn-add-file-description").find("span").text(jsVars.lang_remove_file_description);
          $("#multiUploadSucceeded .multiItem.multiItemFirst .js-btn-add-file-description").removeClass("btn-primary").addClass("btn-default");
          //update for the first multi item [-]
          $("#singleUploadSucceeded .js-btn-save-file-description").removeClass("btn-primary").addClass("btn-success");
          $("#singleUploadSucceeded .js-btn-save-file-description i").removeClass("fa-save").addClass("fa-check");
          setTimeout(function() {
            $("#singleUploadSucceeded .js-btn-save-file-description").addClass("disabled btn-default").removeClass("btn-success");
            $("#singleUploadSucceeded .js-btn-save-file-description i").addClass("fa-save").removeClass("fa-check");
          }, 750);
        }
      }
     });
    return false;
  });

  /******
   * 24. SINGLE: handle file descriptions [-]
   ******/



  /******
   * 25. MULTI: handle file descriptions [+]
   ******/

  /****** show file description field /hide field/ remove file description ******/
  $("#multiUploadSucceeded").on("click",".js-btn-add-file-description", function() {
    var thisBtn = this;
    var thisMutliItem = $(this).closest(".multiItem");
    /** show field **/
    if ($(this).hasClass("btn-primary")) {
      $(thisMutliItem).find(".js-file-description-wrapper").slideDown(400,function() {
        $(thisBtn).find("span").text(jsVars.lang_remove_file_description);
        $(thisBtn).removeClass("btn-primary").addClass("btn-default");
        $(thisMutliItem).find("input[name='musFileDescription']").focus();
      });
    }
    /** remove description/hide field **/
    if ($(this).hasClass("btn-default")) {
      $(thisMutliItem).find(".js-file-description-wrapper").slideUp(400,function() {
        $(thisMutliItem).find("input[name='musFileDescription']").val("");
        $(thisMutliItem).find(".js-btn-save-file-description").addClass("disabled btn-default").removeClass("btn-primary");
        $(thisBtn).find("span").text(jsVars.lang_add_file_description);
        $(thisBtn).addClass("btn-primary").removeClass("btn-default");
        var downloadLink = $(thisMutliItem).find("input[name='musDownloadLink']").val();
        $.ajax({
          type: "POST",
          url: "functions.ajax.php",
          dataType: 'json',
          async: false,
          data: {"action":"updateFileDescription","downloadLink":downloadLink,"fileDescription":""},
          success: function(msgObj) {
            if (msgObj.error) {
              new PNotify({title: jsVars.lang_errors_occurred,text: msgObj.error, type: "error"});
            } else {
              new PNotify({text: jsVars.lang_success_removed_file_description, type: "success"});
            }
          }
        });
      });
    }
    return false;
  });

  /** field observation **/
  $("#multiUploadSucceeded").on("input", "input[name='musFileDescription']", function() {
    var saveButton = $(this).parent().find(".js-btn-save-file-description");
    if ($(saveButton).hasClass("disabled")) {
      $(saveButton).removeClass("disabled btn-default").addClass("btn-primary");
    }
  });

  /** update file description on pressing enter triggering click event some lines below **/
  $("#multiUploadSucceeded").on("keydown", "input[name='musFileDescription']", function(e) {
    var saveButton = $(this).parent().find(".js-btn-save-file-description");
    if (!$(saveButton).hasClass("disabled") && e.keyCode == 13) { //Enter Key
       $(saveButton).trigger('click');
    }
  });
  /** update file description itself **/
  $("#multiUploadSucceeded").on("click", ".js-btn-save-file-description", function() {
    var thisBtn = this;
    var thisMutliItem = $(this).closest(".multiItem");
    var fileDescription = $(thisMutliItem).find("input[name='musFileDescription']").val();
    var downloadLink = $(thisMutliItem).find("input[name='musDownloadLink']").val();
    $.ajax({
       type: "POST",
       url: "functions.ajax.php",
       dataType: 'json',
       async: false,
       data: {"action":"updateFileDescription","downloadLink":downloadLink,"fileDescription":fileDescription},
       success: function(msgObj) {
        if (msgObj.error) {
          new PNotify({title: jsVars.lang_errors_occurred,text: msgObj.error, type: "error"});
        } else {
          new PNotify({text: jsVars.lang_success_updated_file_description, type: "success"});
          $(thisBtn).removeClass("btn-primary").addClass("btn-success");
          $(thisBtn).find("i").removeClass("fa-save").addClass("fa-check");
          setTimeout(function() {
            $(thisBtn).addClass("disabled btn-default").removeClass("btn-success");
            $(thisBtn).find("i").addClass("fa-save").removeClass("fa-check");
          }, 750);
        }
      }
     });
    return false;
  });

  /******
   * 25. MULTI: handle file descriptions [-]
   ******/


});