<?php

mysqlTimezoneFix();

/**
 * This functions is used to handle all database queries of the project
 * and if an error occurs an usefull email to an administrator will be sent
 * 
 * @param string $sql - the SQL Query
 * 
 * @return the MYSQL result identifier, send's an email on error
 **/ 
function dbquery($sql) {
  //own db debugger
  global $db, $config;

  //reconnect if needed
  if (!mysqli_ping($db)) { //reconnect if db connection is lost (huge files)
    mysqli_close($db);
    $db = mysqli_connect($config->db_host, $config->db_user, $config->db_pass);
    mysqli_select_db($db,$config->db_name);
  }


  $res = mysqli_query($db,$sql);
  if (mysqli_errno($db)) {
    mail($config->admin_mail, strip_tags($config->siteName) . ' DB-Error',$_SERVER['PHP_SELF']."?".$_SERVER['QUERY_STRING']."\n\nMySQL error ".mysqli_errno().": ".mysqli_error()."\nWhen executing:\n$sql\nHTTP_USER_AGENT: ".$_SERVER['HTTP_USER_AGENT']."\nREMOTE_ADDR: ".$_SERVER['REMOTE_ADDR']."\nHTTP_HOST: ".$config->projecturl);
  }
  return $res;
}



/**
 * quotes and escape quotes of single strings, or returns NULL for the use in mysql queries
 * makes only sense for strings 
 * Attention: the Quotes are part of the output:
 *    dbquote("hallo")    ->    "'hallo'"
 *    dbquote("c'mon")    ->    "'c\'mon'"
 *    dbquote("")         ->    "NULL"  
 *    use
 *      field = " . dbquote($val) . "
 *    don't use 
 *      field = '" . dbquote($val) . "' 
 * 
 * @param string $str - the string to check
 * 
 * @return formated string for the use in sql statements
 **/ 
function dbquote($str) {
  global $db;
  //to get the correct quotes and prevent from musthave of magic quotes
  if (get_magic_quotes_gpc()) { //if slashes added and magic quotes are enabled
      $str = stripslashes($str);
  }
  // quotieren, falls kein integer
  if (!is_numeric($str)) {
      $str = "'" . mysqli_real_escape_string($db,$str) . "'";
  }
  return $str;
}



/**
 * to generate the different secret unreproduce-able keys
 * 
 * @param integer $fileId - id (database) of the file
 * 
 * @return array(
 *                string skey         -> secret download key
 *                string deletekey    -> secret deletion key
 *              )
 * used in the sql query on the admin page too
 **/ 
function genFileKeys($fileId) {
  global $config;
  $fileId = intval($fileId);
  if (!$fileId) return false;
  $sql = "select md5(concat(id,'~'," . dbquote($config->secretKey) . ",'##',created)) as skey, md5(concat(id,'DE33LE'," . dbquote($config->secretKey) . ",'}}',uid)) as delkey from `" . $config->tablePrefix . "files` where id = '$fileId'";
  $res = dbquery($sql);
  if (!mysqli_num_rows($res)) return false;
  $row = mysqli_fetch_object($res);
  return array($row->skey,$row->delkey);
}

/**
 * retrieve some information about download/deletetion file
 * 
 * @param string $key     -> secret download or delete key
 *        string $type    -> what kind of key??? download/delete/file/upload default: download
 *        string $return  -> which information do we need exactly???
 * 
 * @return object with file information
 **/
function getFileInfos($key,$type = "download",$return = false) {
  global $config;
  if (!$key) return false;
  if ($type == "download") {
    $sql = "select *, md5(concat(created,'~',created," . dbquote($config->secretKey) . ",'][',id*3)) as fkey, date_add(" . ($config->delOn=="download"?"last_download":"created") . ", interval " . intval($config->delDays) . " day) as accessible_until, date_add(created, interval del_days day) as accessible_until_by_user, datediff(date_add(" . ($config->delOn=="download"?"last_download":"created") . ", interval " . intval($config->delDays) . " day),now()) as days_remaining, datediff(date_add(created, interval del_days day),now()) as days_remaining_by_user from `" . $config->tablePrefix . "files` where md5(concat(id,'~'," . dbquote($config->secretKey) . ",'##',created)) = " . dbquote($key) . " and status = 1";
  }
  if ($type == "delete") {
    $sql = "select *, md5(concat(created,'~',created," . dbquote($config->secretKey) . ",'][',id*3)) as fkey, date_add(" . ($config->delOn=="download"?"last_download":"created") . ", interval " . intval($config->delDays) . " day) as accessible_until, date_add(created, interval del_days day) as accessible_until_by_user, datediff(date_add(" . ($config->delOn=="download"?"last_download":"created") . ", interval " . intval($config->delDays) . " day),now()) as days_remaining, datediff(date_add(created, interval del_days day),now()) as days_remaining_by_user from `" . $config->tablePrefix . "files` where md5(concat(id,'DE33LE'," . dbquote($config->secretKey) . ",'}}',uid)) = " . dbquote($key) . " and status = 1";
  }
  if ($type == "file") {
    $sql = "select * from `" . $config->tablePrefix . "files` where md5(concat(created,'~',created," . dbquote($config->secretKey) . ",'][',id*3)) = " . dbquote($key) . " and status = 1";
  }
  if ($type == "upload") {
    $sql = "select * from `" . $config->tablePrefix . "files` where u_key = " . dbquote($key) . " and status = 1 limit 1";
  }
  if (!$sql) return false;
  $res = dbquery($sql);
  if (!mysqli_num_rows($res)) return false;
  $row = mysqli_fetch_object($res);

  if ($row->del_days > -1) {
    $row->days_remaining = $row->days_remaining_by_user;
    $row->accessible_until = $row->accessible_until_by_user;
  }

  $row->downloadFileName = $row->fkey . "." . pathinfo($row->fname, PATHINFO_EXTENSION);
  //add download handler information if file is requested
  $d_ips = $d_sids = array();
  if ($type == "file") {
    $sql = "select * from `" . $config->tablePrefix . "download_handler` where files_id = '" . $row->id . "' order by d_time";
    $res = dbquery($sql);
    while ($rowdh = mysqli_fetch_object($res)) {
      $d_ips[] = $rowdh->d_ip;
      $d_sids[] = $rowdh->d_sid;
      //last d_time
      $row->d_time = $rowdh->d_time;
    }
  } 
  $row->d_ips = $d_ips;
  $row->d_sids = $d_sids;

  //any message to display?
  $sql = "select message from `" . $config->tablePrefix . "messages` where u_key = " . dbquote($row->u_key);
  $res = dbquery($sql);
  $rowmess = mysqli_fetch_object($res);
  $row->message = $rowmess->message;

  if ($return == "descr") return $row->descr;
  //or not that nice :)
  // if ($return) return $row->{$return};
  
  return $row;
}

/**
 * retrieve some information about download/deletetion links of a group of files
 * 
 * @param string $key     -> upload_key
 * 
 * @return array with message and array with objects with file information
 **/
function getMultiFileInfos($key) {
  global $config;
  $message = false;
  if (!$key) return false;
  $sql = "select *,md5(concat(id,'~'," . dbquote($config->secretKey) . ",'##',created)) as skey,md5(concat(created,'~',created," . dbquote($config->secretKey) . ",'][',id*3)) as fkey from `" . $config->tablePrefix . "files` where u_key = " . dbquote($key) . " and status = 1";
  $res = dbquery($sql);
  if (!mysqli_num_rows($res)) return false;
  while ($row = mysqli_fetch_object($res)) {
    $row->downloadFileName = $row->fkey . "." . pathinfo($row->fname, PATHINFO_EXTENSION);
    $files[] = $row;
  }

  //any message to display?
  $sql = "select message from `" . $config->tablePrefix . "messages` where u_key = " . dbquote($key);
  $res = dbquery($sql);
  $row = mysqli_fetch_object($res);
  $message = $row->message;

  return array($files,$message);
}

/**
 * the language function, displays correct language strings for activated language
 * the language files can be found in the lang-directory   
 *  
 * @param string $key - the key of the language to display
 * @global boolean $show_lang_keys - can be set in the conf.php - show additional to the language string the appropriate key too
 * 
 * @return correct translated language string if found
 *         if not - the key will be returned width two leading and trailing underscores instead and the $deblang array will be increased
 **/
function lang($key) {
  global $LANG, $deblang, $show_lang_keys;
  if (array_key_exists($key, $LANG)) return $LANG[$key] . ($show_lang_keys ? " [$key]" : "");// . " [$key]";
  else {
    $deblang[] = $key;
    return "__" . $key . "__";
  }
}

/**
 * to inform site administrators if some language keys are not available
 *  
 * @param NONE
 * @global array $deblang - not found language keys - filled with the help of lang()
 * 
 * @return nothing but sends an email to administrator if languages keys not available
 **/
function deblang() {
  //mail notfound language keys to debug mailaddr
  global $config, $deblang;
  if (!$deblang) return false;
  $deblang = array_unique($deblang);
  $included_files = get_included_files();
  foreach ($included_files as $filename) {
    $fname = basename($filename);
    if (preg_match('/lang\.php$/',$fname)) break;
  }
  mail($config->admin_mail, strip_tags($config->siteName) . ' Language-Error',$_SERVER['PHP_SELF']."?".$_SERVER['QUERY_STRING']."\n\nLanguage: " . $config->lang . "\nLanguagefile: " . $config->lang . "/$fname\nMissing Keys:\n\t" . implode("\n\t",$deblang) . "\n");  
}

/**
 * converts bytes in human readable outpts
 *  
 * @param integer $int      -> bytes
 *
 * @return string -> human readable filesize
 **/
function fsize($int) {
  $int = intval($int);
  $kb = 1024;
  $mb = $kb*1024;
  $gb = $mb*1024;
  $tb = $gb*1024;
  $pb = $tb*1024;
  if ($int < $kb) return $int . " B";
  elseif ($int < $mb) return round($int/$kb,2) . " KB";
  elseif ($int < $gb) return round($int/$mb,2) . " MB";
  elseif ($int < $tb) return round($int/$gb,2) . " GB";
  elseif ($int < $pb) return round($int/$tb,2) . " TB";
  else return round($int/$pb,2) . " PB";
}

/**
 * used in is_email() - on Windows machines this function is not available
 * so this function will be used instead 
 * 
 * @param NONE
 * 
 * @return true if it's valid or false if not    
 **/ 
if (!function_exists("checkdnsrr")) {
  function checkdnsrr() {
    return true;
  }
}

/**
 * Checks if email address is valid and host exists
 * 
 * @param string $email - the email to check
 * 
 * @return true if it's valid or false if not    
 **/ 
function is_email($email) {
  $email = trim($email);
  if (!$email) return false;
  if (!preg_match("!^[\w|\.|\-|_]+@\w[\w|\.|\-]+\.[a-zA-Z]{2,6}$!",$email)) return false;
  else {
    list($user, $host) = explode("@", $email);
    if (checkdnsrr($host, "MX") or checkdnsrr($host, "A")) return true;
    else return false;
  }
}

/**
 * recursive removing of directories on server
 * 
 * @param string $location - the path to the directory to delete
 * 
 * @return nothing but removes the directory
 **/
function xrmdir($location){
   $rc=0;
   if (is_dir($location)){
      $dp=opendir("$location");
      while(false !== ($file = readdir($dp))){
         if ($file=="."||$file=="..") continue;
         xrmdir("$location/$file");
      }
      closedir($dp);
      unset($dp);
      $rc=rmdir($location);
      unset($location);
   }
   else{
      $rc=unlink($location);

      unset($location);
   }
   return $rc;
}


/**
 * short for htmlentities($str,ENT_QUOTES) especially for the use in form fields and title and alt tags
 * htmlentities: all characters which have HTML character entity equivalents are translated into these entities 
 * ENT_QUOTES converts both double and single quotes
 *  
 * @param string $str - the string to convert
 * 
 * @return converted string
 **/
function he($str) {
  $str = htmlentities($str, ENT_QUOTES, "UTF-8");
  return $str;
}


/**
 * removes files upped more than the days defined in the config before ($config->delDays)
 *  
 * @param none
 * 
 * @return nothing
**/
function cleanUp() {  
  global $config;
  $delDays = intval($config->delDays);
  if ($delDays < 0 && !$config->delSettingsByUploader) return false;

  //days set???
  if ($delDays > -1) {
    if ($config->delOn == "download") {
      $add2sql[] = "datediff(now(), last_download) > $delDays";
    } else {
      $add2sql[] = "datediff(now(), created) > $delDays";
    }
  }

  //user set deletion information
  if ($config->delSettingsByUploader) {
    //days
    if ($delDays > 1) {
      $add2sql[] = "(del_days > -1 and datediff(now(), created) > del_days)";
    }
    //downloads
    $add2sql[] = "(del_downloads > 0 and downloads = del_downloads)";
  }

  if (!$add2sql) return false;

  $sql = "select id, uid from `" . $config->tablePrefix . "files` where uid = 0 and locked = 0 and (" . implode(" or ",$add2sql) . ")";
  $res = dbquery($sql);
  while ($row = mysqli_fetch_object($res)) {
    //delete from filesystem
    $file_path = $config->uploadDir . $row->uid . "/" . $row->id;
    if (file_exists($file_path)) xrmdir($file_path);
  }
  //delete from database
  $sql = "delete from `" . $config->tablePrefix . "files` where uid = 0 and locked = 0 and (" . implode(" or ",$add2sql) . ")";
  dbquery($sql);
  //delete orphan download_handler entries
  $sql = "delete from `" . $config->tablePrefix . "download_handler` where datediff(now(), d_time) > 1";
  dbquery($sql);
  //delete orphan messages
  $sql = "delete from `" . $config->tablePrefix . "messages` where u_key not in (select u_key from `" . $config->tablePrefix . "files` group by u_key)";
  dbquery($sql); 
  //delete orphan database entries
  $sql = "select id, uid from `" . $config->tablePrefix . "files`";
  $res = dbquery($sql);
  while ($row = mysqli_fetch_object($res)) {
    $file_path = $config->uploadDir . $row->uid . "/" . $row->id;
    if (!file_exists($file_path)) {
      dbquery("delete from `" . $config->tablePrefix . "files` where id = '" . $row->id . "'");
    }
  }
}


/**
 * check if it's a image, when it's not toooo big
 *  
 * @param $imgPath .... full path to image
 * 
 * @return boolean ... true if it's an image, false if not
**/
function is_image($imgPath) {
  if (filesize($imgPath) > 10*1024*1024) return false;
  list($w, $h) = getimagesize($imgPath);
  if (!$w || !$h) return false;
  return true;
}

/**
 * generate password for password protected files
 *  
 * @param $length .... length of the password (default: 9)
 *        $strength .. which characters should be used, the higer the stronger
 * 
 * @return string ... the password
**/
function genPWD($length=9, $strength=0) {
  $vowels = 'aeuy';
  $consonants = 'bdghjmnpqrstvz';
  if ($strength & 1) $consonants .= 'BDGHJLMNPQRSTVWXZ';
  if ($strength & 2) $vowels .= "AEUY";
  if ($strength & 4) $consonants .= '23456789';
  if ($strength & 8) $consonants .= '@#$%';
  $password = '';
  $alt = time() % 2;
  for ($i = 0; $i < $length; $i++) {
      if ($alt == 1) {
          $password .= $consonants[(rand() % strlen($consonants))];
          $alt = 0;
      } else {
          $password .= $vowels[(rand() % strlen($vowels))];
          $alt = 1;
      }
  }
  return $password;
}

/**
 * to calculate the microseconds for the bandwidth throtteling
 *  
 * @param none
 * 
 * @return int ... number of microseconds to wait between 8MB blocks during the download
 *         disables $config->XSendFile if seconds are calculated
**/
function calcBW() {
  global $config;
  $kbps = intval($config->kbps);
  if (!$kbps || $kbps < 0) return false;
  $config->XSendFile = false;
  return intval(3500000/$kbps);
}

/**
 * to enable UTF-8 encoded subjects
 *  
 * @param $subject
 * 
 * @return UTF-8 spelling for the encoded subjects
**/
function UTF8subject($subject) {
  if (!$subject) return false;
  $subject = strip_tags($subject);
  return '=?UTF-8?B?'.base64_encode($subject).'?=';
}


/**
 * Bitly URL shortener/expander
 *  
 * @param $url (bitly or long url)
 * @param $todo (shorten or expand)
 * 
 * @return long or short url
**/
function BitlyShortener($url,$todo="shorten") {
  global $config;
  if (!$url) return false;

  if (!$config->bitlyUser || !$config->bitlyKey) $bitly_error[] = "Needed Bitly User and/or Bitly API Key not set in the config.";
  //getter method
  if (!$bitly_error) {
    //method checker
    if ((!ini_get("allow_url_fopen") || strtolower(ini_get("allow_url_fopen") == "off") || strtolower(ini_get("allow_url_fopen")) == "false") && !function_exists("curl_init")) {
      $bitly_error[] = "Neither allow_url_fopen is not activated nor CURL is enabled. Please enable allow_url_fopen or CURL (php.ini).";
    } elseif ((!ini_get("allow_url_fopen") || strtolower(ini_get("allow_url_fopen") == "off") || strtolower(ini_get("allow_url_fopen")) == "false") && $config->connectionMethod == "url_fopen") {
      $bitly_error[] = "allow_url_fopen is not activated. Please use CURL instead, set \$config->connectionMethod to curl or auto.";
    } elseif (!function_exists("curl_init") && $config->connectionMethod == "curl") {
      $bitly_error[] = "CURL is not enabled. Please set \$config->connectionMethod to url_fopen or auto.";
    }
    //method setter - if needed
    if (!$bitly_error) {
      switch ($config->connectionMethod) {
        case "curl": $method = "curl"; break;
        case "url_fopen": $method = "url_fopen"; break;
        default:
          if (function_exists('curl_init')) $method = "curl";
          else $method = "url_fopen";        
          break;
      }
    }
  }
  if (!$bitly_error) {
    $baseUrl = urlencode($url);
    if ($todo == "shorten") {
      $bitlyUrl = 'http://api.bit.ly/v3/shorten?login=' . $config->bitlyUser . '&apiKey=' . $config->bitlyKey . '&uri=' . $baseUrl . '&format=txt';
    } elseif ($todo == "expand") {
      $bitlyUrl = 'http://api.bit.ly/v3/expand?login=' . $config->bitlyUser . '&apiKey=' . $config->bitlyKey . '&shortUrl=' . $baseUrl . '&format=txt';
    }
    //curl
    if ($method == "curl") {
      $ch = curl_init();
      curl_setopt($ch,CURLOPT_URL, $bitlyUrl);
      curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
      curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,5);
      $result = curl_exec($ch);
      curl_close($ch);
      $shortURL = trim($result);
    } 
    //url_fopen
    elseif ($method == "url_fopen") {
      $result = file_get_contents($bitlyUrl);
      $shortURL = trim($result);
    }
  }
  if (!$shortURL) $bitly_error[] = "No valid response from bitly - no URL generated.";
  if ($bitly_error) {
    mail($config->admin_mail, strip_tags($config->siteName) . ' bitly URL shortener Troubles',$_SERVER['PHP_SELF']."?".$_SERVER['QUERY_STRING']."\n\n- " . implode("<br />- ",$bitly_error) . "\n\n$result\n\nHTTP_USER_AGENT: ".$_SERVER['HTTP_USER_AGENT']."\nREMOTE_ADDR: ".$_SERVER['REMOTE_ADDR']."\nHTTP_HOST: ".$config->projecturl);
    return false;
  } else {
    return $shortURL;
  }
}


/**
 * Adfly URL shortener/expander
 *  
 * @param $url (adfly or long url)
 * @param $todo (shorten or expand)
 * 
 * @return long or short url
**/
function AdflyShortener($url,$todo="shorten") {
  global $config;
  if (!$url) return false;

  if (!$config->adflyUid || !$config->adflyKey) $adfly_error[] = "Needed Adfly UID and/or Adfly API Key not set in the config.";
  //getter method
  if (!$adfly_error) {
    //method checker
    if ((!ini_get("allow_url_fopen") || strtolower(ini_get("allow_url_fopen") == "off") || strtolower(ini_get("allow_url_fopen")) == "false") && !function_exists("curl_init")) {
      $adfly_error[] = "Neither allow_url_fopen is not activated nor CURL is enabled. Please enable allow_url_fopen or CURL (php.ini).";
    } elseif ((!ini_get("allow_url_fopen") || strtolower(ini_get("allow_url_fopen") == "off") || strtolower(ini_get("allow_url_fopen")) == "false") && $config->connectionMethod == "url_fopen") {
      $adfly_error[] = "allow_url_fopen is not activated. Please use CURL instead, set \$config->connectionMethod to curl or auto.";
    } elseif (!function_exists("curl_init") && $config->connectionMethod == "curl") {
      $adfly_error[] = "CURL is not enabled. Please set \$config->connectionMethod to url_fopen or auto.";
    }
    //method setter - if needed
    if (!$adfly_error) {
      switch ($config->connectionMethod) {
        case "curl": $method = "curl"; break;
        case "url_fopen": $method = "url_fopen"; break;
        default:
          if (function_exists('curl_init')) $method = "curl";
          else $method = "url_fopen";        
          break;
      }
    }
  }
  if (!$adfly_error) {
    $baseUrl = urlencode($url);
    if ($todo == "shorten") {
      $adflyUrl = 'http://api.adf.ly/api.php?key=' . $config->adflyKey . '&uid=' . $config->adflyUid . '&advert_type=' . $config->adflyAdvertType . '&domain=adf.ly&url=' . $baseUrl;

      //curl
      if ($method == "curl") {
        $ch = curl_init();
        curl_setopt($ch,CURLOPT_URL, $adflyUrl);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,5);
        $result = curl_exec($ch);
        curl_close($ch);
        $shortURL = trim($result);
      } 
      //url_fopen
      elseif ($method == "url_fopen") {
        $result = file_get_contents($adflyUrl);
        $shortURL = trim($result);
      }

      if (!$shortURL) $adfly_error[] = "No valid response from adfly - no URL generated.";
      else {
        //is not an URL??
        if (!preg_match('|^https?://|', $shortURL)) {
          $resArr = json_decode($shortURL);
          $adfly_error[] = $resArr->errors[0]->msg;
        }
      }

      if ($adfly_error) {
        mail($config->admin_mail, strip_tags($config->siteName) . ' adfly URL shortener Troubles',$_SERVER['PHP_SELF']."?".$_SERVER['QUERY_STRING']."\n\n- " . implode("<br />- ",$adfly_error) . "\n\n$result\n\nHTTP_USER_AGENT: ".$_SERVER['HTTP_USER_AGENT']."\nREMOTE_ADDR: ".$_SERVER['REMOTE_ADDR']."\nHTTP_HOST: ".$config->projecturl);
        return false;
      } else {
        preg_match('/^.*\/([0-9a-z]+)\.html$/',$url,$d_data);
        $key = $d_data[1];
        //download
        $sql = "update `" . $config->tablePrefix . "files` set adfly_down = " . dbquote($shortURL) . " where md5(concat(id,'~'," . dbquote($config->secretKey) . ",'##',created)) = " . dbquote($key);
        dbquery($sql);
        //delete
        $sql = "update `" . $config->tablePrefix . "files` set adfly_dele = " . dbquote($shortURL) . " where md5(concat(id,'DE33LE'," . dbquote($config->secretKey) . ",'}}',uid)) = " . dbquote($key);
        dbquery($sql);

        return $shortURL;
      }



    } elseif ($todo == "expand") {
      $sql = "select adfly_dele, adfly_down, md5(concat(id,'~'," . dbquote($config->secretKey) . ",'##',created)) as skey, 
        md5(concat(id,'DE33LE'," . dbquote($config->secretKey) . ",'}}',uid)) as delkey 
        from `" . $config->tablePrefix . "files` where adfly_down = " . dbquote($url) . " or adfly_dele = " . dbquote($url);
      $res = dbquery($sql);
      $row = mysqli_fetch_object($res);
      if ($url == $row->adfly_down) {
        $longUrl = $config->baseDownloadUrl . $row->skey . ".html";
      } else {
        $longUrl = $config->baseDeleteUrl . $row->delkey . ".html";
      }
      return $longUrl;
    }
  }
}


/**
 * GOOGLE URL shortener/expander
 *  
 * @param $url (goo.gl or long url)
 * @param $todo (shorten or expand)
 * 
 * @return long or short url
**/
function GoogleShortener($url,$todo="shorten") {
  global $config;
  if (!$url) return false;

  if (!$config->googleApiKey) $google_error[] = "Needed Google API Key not set in the config.";
  //getter method
  if (!$google_error) {
    //method checker
    if (!function_exists("curl_init")) {
      $google_error[] = "CURL is not enabled. Please use another shortener or activate CURL.";
    }
  }
  if (!$google_error) {
    $apiUrl = "https://www.googleapis.com/urlshortener/v1/url?key=".$config->googleApiKey;
    $ch = curl_init();
    if ($todo == "shorten") {
      curl_setopt($ch,CURLOPT_URL,$apiUrl);
      curl_setopt($ch,CURLOPT_POST,1);
      curl_setopt($ch,CURLOPT_POSTFIELDS,json_encode(array("longUrl" => $url)));
    } else {
      curl_setopt($ch,CURLOPT_URL,$apiUrl."&shortUrl=$url");
    }
    curl_setopt($ch,CURLOPT_HTTPHEADER,array("Content-Type: application/json"));
    curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
    curl_setopt($ch,CURLOPT_CONNECTTIMEOUT,5);
    $result = curl_exec($ch);
    curl_close($ch);

    $resArr = json_decode($result);

    $shortURL = $resArr->id;
    $longURL = $resArr->longUrl;
  }
  if (!$shortURL && !$longUrl) $google_error[] = "No valid response from google - no URL generated.";
  if ($google_error) {
    mail($config->admin_mail, strip_tags($config->siteName) . ' Google URL shortener Troubles',$_SERVER['PHP_SELF']."?".$_SERVER['QUERY_STRING']."\n\n- " . implode("<br />- ",$google_error) . "\n\n$result\n\nHTTP_USER_AGENT: ".$_SERVER['HTTP_USER_AGENT']."\nREMOTE_ADDR: ".$_SERVER['REMOTE_ADDR']."\nHTTP_HOST: ".$config->projecturl);
    return false;
  } else {
    return $todo == "shorten" ? $shortURL : $longURL;
  }
}


/**
 * used for downloads on android devices (usage on download.php and files.php)
 * just to fix the double calls by android browsers
 *
 * @param $todo
 *          "init" to set counter on adroid devices
 *          "countDown" to reduce counter to enable downlad on second call
 * 
 * @return nothing
 **/
function androidDoubleCallFix($todo = "init") {
  if(
    stripos($_SERVER['HTTP_USER_AGENT'],'android') !== false
    // || (preg_match('/AppleWebKit/',$_SERVER['HTTP_USER_AGENT']) && !preg_match('/(ipad)|(iphone)|(macintosh)|(blackberry)/i',$_SERVER['HTTP_USER_AGENT']))  //because some andoid browsers on some android devices doesn't send an "ANDROID" string and shouldn't be a Apple Device
    ) {
    if ($todo == "init") {
      $_SESSION["androCount"] = 2;
    }
    elseif ($todo == "countDown") {
      $_SESSION["androCount"]--;
    }
  }
}

/**
 * used to equalize webserver time and database time
 * called ONLY if needed directly on functions.php
 *
 * @param none
 *
 * @return nothing
 **/
function mysqlTimezoneFix() {
  global $config;
  if ($config->db_timezoneCorrection) {
    dbquery("SET time_zone = " . dbquote($config->db_timezoneCorrection));
  }
}

?>