<?php

    header('Content-Type: text/html; charset=utf-8');
    @ini_set('safe_mode_gid', false);
    
    
    $base64Inline = array(
        'folder' => 'data:image/png;base64,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',
        'settings' => 'data:image/png;base64,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',
        'database' => 'data:image/png;base64,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',
        'files' => 'data:image/png;base64,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',
        'finish' => 'data:image/png;base64,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',
        'globe' => 'data:image/png;base64,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'
    );
    
    $base64Files = array(
        'lib/shoutbox.class.php' => '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',
        'media/css/main.css' => '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',
        'media/css/mobile.css' => 'Ym9keSB7DQogICAgb3ZlcmZsb3c6IGhpZGRlbjsNCn0NCg0KaDEgew0KICAgIHBhZGRpbmc6IDVweCAwOw0KICAgIG1hcmdpbjogMCAwIDAgMTRweDsNCn0NCg0KaDEgaW1nIHsNCiAgICBtYXJnaW4tdG9wOiAycHg7DQogICAgdmVydGljYWwtYWxpZ246IHRvcDsNCn0NCg0KI3dyYXBwZXIgew0KICAgIHdpZHRoOiAxMDAlICFpbXBvcnRhbnQ7DQp9DQoNCiNzaG91dGJveC1ib3gtd3JhcHBlciB7DQogICAgd2lkdGg6IGF1dG87DQogICAgaGVpZ2h0OiBhdXRvOw0KICAgIG1hcmdpbjogMHB4IDEwcHggMTBweCAxMHB4Ow0KICAgIC13ZWJraXQtYm9yZGVyLXJhZGl1czogMDsNCiAgICAtbW96LWJvcmRlci1yYWRpdXM6IDA7DQogICAgYm9yZGVyLXJhZGl1czogMDsNCiAgICAtd2Via2l0LWJveC1zaGFkb3c6IG5vbmU7DQogICAgLW1vei1ib3gtc2hhZG93OiBub25lOw0KICAgIGJveC1zaGFkb3c6IG5vbmU7DQp9DQoNCiNzaG91dGJveC1lbnRlci1uYW1lIHsNCiAgICBtYXJnaW46IDQwcHggMDsNCn0NCg0KI3Nob3V0Ym94LWxvYWRlciB7DQogICAgbWFyZ2luOiA4MHB4IDA7DQp9DQoNCiNzaG91dGJveC1ib3ggew0KICAgIHdpZHRoOiAxMDAlOw0KICAgIGhlaWdodDogMjIwcHg7DQogICAgLXdlYmtpdC1ib3gtc2l6aW5nOiBib3JkZXItYm94Ow0KCS1tb3otYm94LXNpemluZzogYm9yZGVyLWJveDsNCglib3gtc2l6aW5nOiBib3JkZXItYm94Ow0KfQ0KDQojc2hvdXRib3gtbWVzc2FnZSB7DQogICAgd2lkdGg6IDEwMCU7DQogICAgaGVpZ2h0OiA2MHB4Ow0KICAgIHBhZGRpbmc6IDA7DQogICAgYm9yZGVyLWJvdHRvbTogMDsNCiAgICAtd2Via2l0LWJvcmRlci1yYWRpdXM6IDA7DQogICAgLW1vei1ib3JkZXItcmFkaXVzOiAwOw0KICAgIGJvcmRlci1yYWRpdXM6IDA7DQogICAgLXdlYmtpdC1ib3gtc2l6aW5nOiBib3JkZXItYm94Ow0KCS1tb3otYm94LXNpemluZzogYm9yZGVyLWJveDsNCglib3gtc2l6aW5nOiBib3JkZXItYm94Ow0KfQ0KDQojc2hvdXRib3gtbWVzc2FnZTpmb2N1cywNCiNzaG91dGJveC1tZXNzYWdlOmhvdmVyIHsNCiAgICBib3JkZXItYm90dG9tOiAwOw0KfQ0KDQojc2hvdXRib3gtc3VibWl0IHsNCiAgICB3aWR0aDogMTAwJTsNCiAgICBoZWlnaHQ6IDUwcHg7DQogICAgcGFkZGluZzogMCAycHg7DQogICAgLXdlYmtpdC1ib3JkZXItcmFkaXVzOiAwOw0KICAgIC1tb3otYm9yZGVyLXJhZGl1czogMDsNCiAgICBib3JkZXItcmFkaXVzOiAwOw0KfQ0KDQojc2hvdXRib3gtbWVzc2FnZS1jb3VudGVyIHsNCiAgICBkaXNwbGF5OiBub25lOw0KfQ==',
        'media/images/favicon.png' => 'iVBORw0KGgoAAAANSUhEUgAAACAAAAAgBAMAAACBVGfHAAAAFVBMVEUAAAD///8oQoLL0eE8adwyUKA8ZMhoi8x1AAAAAXRSTlMAQObYZgAAAERJREFUKM9jwAQuKICBgSUNBQQwsCQpIQOsAoqCCEBNAWFjKMApIARzBm4BqrsUbiBOAWWYM4kXoNxhhCOKIRQFYCYGALrERzoUaQpPAAAAAElFTkSuQmCC',
        'media/images/icon-shoutbox.png' => 'iVBORw0KGgoAAAANSUhEUgAAAEAAAABACAMAAACdt4HsAAACjlBMVEUAAAABBAgHECEFDBgCBg4DCBACBQwCBg0AAQQAAAEBBAkAAQMAAQIBAwcAAAIqT5wTLVQTMGMOHz0UM2gAAQIjVIgfPHQgSHgNHzwsZ6EhT4I1fbUzda4xa6YVMmYbPmsVMFoNHjwJFC0vdKsZOmwUL1oPJUUMGzYRN3QKGC8WOHYXOG8WOnNtfZwYM34ZM3MQJkgRK1UpYJcdO3gTLl8WOHMAAAAWO3s3hLuJlbIjRncUM2xhc5QpUpkxTYIqXpMUMmsDDhw2c7E7UH9+i6ceOYFPZowiPoOnsMKdqL0kQ5FCW4cnTownSnxJXo4+XY4KHjYLLG0PNXJVhb1HdK2hzOKayeKUxN+izuO/1eieyeFBeLKey+KDuNnZ4u0/j8Pi5+9YlcWbxN+NvtyHutptp9B3rtRRmsvs8PRkn8y20eaXxt+RwNyfvNt/tdedtNZoocxhnMk9bq3o7PLG1+kePZD5+vzF0+WtzeSRrdNyqNDJ2uqmy+OfxuCPwd58stUzX6XS3+zR3Oqxz+WiyeGnyOFzrNJemMhGisHd5e650udppM9Fh8M+isBQiL4/hrtNg7tckcZUj8JPjcFHfbcwWaLO2unT2+iwy+OJvdyHsNVam8tplspJj8RJhrwtVaDW3um8z+N7s9dPksdZi8FFgrk/f7Y2ZagmSJn09ffM1+emwd6vvtipu9g+gr61yOCuw97DzN2EqtI3fbs3aqw4T5O2zePCz+K8yd6Wv9yVutqJtteRtdfAx9SwuMs2hsFOfbmOutp9rNKInshggblMZ6i1w9p+o85zn8xFba9XaZf//v6tx+GHpc+QpcxDlcgsRIzc3+a5v816msh1kMGTn7p3iLLV2N9jdac3Z82pYnjZAAAAVXRSTlMADgMKFAYfKhgkGz1MMVH+aY5TUDa5sadK4bD58uqoj34xJumbc2M/PjgxGRD8+tdbIdXLmV9CKfz7m4fs68vIvWb9/Pbs3t79+/Pj24X+vn91bu3c2GMJ6gAACGFJREFUWMPMkD1v2kAYgFsIyhrrJLeT1VZEvfqzFliWwUJIdlwQChH8AMujdwSe481/gK50tOXFA7IX3+jBXcCSIT+nBzQNadN8bHmm0716nvd0b14tlUqVZURZpjGyyDBstVZ5UaDGijSEAEgYACCkZYZ9UUGG0rhN1OskSVJUk2iPxgAyz3w8K9NAumxdXRmGqnIYVTWMTudd61KCNFN9MsDCEUF2DFVX+j1UpJgC9fqKrg4aXYoA8hO2DMetzpDTe8XWsv3Zzz0z315vUZ/LNY1sA5p9JECPqMZAL4tojXV/dovv27a1TZHCDYRuG/53vSgR3zSuTNf+QTrC33e2hZJrfPNMfPgnPp53hVxHePtkYtuT+9i7G2ud9jhN6J59ekBnPjeFZV6mlmWZi8XCND3P+oPnmftLfETKcCUQp/++ATSFi1xJne8H9gXvTsf+YRChzZAXzk//3g8ofpWXWeBEUewEc9e9NjEe5rfuuvPdMHICtFmuhA8ntfv76xf8coOyKEkSHAjmc/caJ27Z6diPYzyOwv7Nkm98PTnS336h+OnqpszCMMySOHZwAhfu2OmB48Q/kizEKPl0Sr4/+oZfXNTvS+JwHAfwMqq74Fh20PUovLgu4qAj6tlR3JMI5J5mOe3BrR+gZavh0FnjxqkJPggNB2MIMhAc2FDG6eGPB/5MBZWgiPtz7vOdqdy9QXCD92ufz9g2adhaecg8d+8U5e4+JUm/XU7nJQwBxk8I1C8vnU7UT90rkOqfDP3ZsNpfQje6uEavZOpVhiQVJZ1KZSXJhYhhUN0lSalU+k4hSbL7XH+AJab6CyzNb9F0plbtkqRDSWuC2WU2O1Ggq8VslqQsAIoDgOpTPUPT+sn+A/TFSNN0HQAGhGQ6LWSzUtD8X4L2rNBOJ6HPMD3g68zLDnOzMk3LGsCQDhDagpAN/isEUV+AvgP6XQAwml6bHtVBfXzUsC3LMtaqPXYAQEISBK/dbg/2A/+zXqHdTiZRv9N5fKrztLy9/n5MB3dw+QMAWAyABsMU8wjwIwGIYbxeQfD7YYAeUGvxsrw1//YTABMfN40YxnOtUvRRFZFAEH6I2+32DgIHcIpwOPJFRu00nmotDsOMa9OrupHx14ZvcH0uAUBTVcViHgTW5/dfXbmHQXUfS0C/KKqNRrRGcTHMuL24MA4PoR76fIKylOLRhiqCkMsRLMv6fFfD+H0+liVy+WJBVNVGM16iEnwM29BPArC0jsEAVCsCQLMhioXyQNjZ6Sk+qKN+rlwURbXSjA6AN2MjU3OzsRjPwQCheDjqqYiFQvk0RxAsziLAiuM4/FiCIHKn5XIB+p5oOBShKA4E/fLoyMQMANoGN/Gw7fy6IgKwSxAmnMU1AMUE/V3UL1QqHhggFLEMgIWZWZ7nEpYIDBC+sHmOzwoHPQAHYMdqtWrAye7pweHh2Q/o28LxUMlCJTgerYAm4DjulyUCAwQuzj3XZ/saAPWXWLUJELAP/SNbIBy/CfUAA3zZXs2947gEBcDt94CtD5yYcCsq7+3tIcFkOukBx0fnF4HwrQYkNjan4Y3+23zZ/CYNx2FcaC1vYrBSS6G14z1LPCAxC5kxRK5qNNG4xEkI2cAQDRked9g8IQktdeBlcXAAqbdeyp2rt539b3x+bSf1Bb36OdAeeD7fl5aS0vnMuy8LW9Bp9bvN9r4jQBzAgrwlwATdlWCxuHeD3IlU8q6wqDiCg0b3uLpeULUF9SGWCMHDTPIW7sRUtiju7l4ImsfV0yPkn7+w8n8coT5yBBtBLx5H9PW4ZMDwYVR/7xYgfyF46RaggcEc368sePYSwAzbgqFDMMASLQEmeI0J1goGk4+7u3pFkjedJ2KEMzUdNwJmwBKdHbyEwSXY2dk7rbab3X6nPpzMdV03pXiMdp6pse2KBsN8VO+ghXb1dG9n57lzHe04GjiyLsLhQac+mnzUdc0s3sVP0eZ2gRNVTZ9PYOgfHrf3sQWyBnQBrDjy1gB9bBANaGpCkmOrv5WkXDRUbT5xtoAhYIAC2PE3R84ALZKfa6oqcQXm0oqYLCTU3mQyGn5qNbpT9LB3BIcD0vvV6hT1Sf8kXhLjEdrrEqTYuGDUxj0M8anfaE6xh9M9OAiII9+eNg9Rf4h8raaK5ewmFrDCS7NyUdS0SW/2ivTQnE6rYJ+AY/u42UUc8/d6tVotkY5nUxRibkMqtl0WdaU3JoY+UYA2YTptkjjWPyT581pJ4CKbyP+CJx/hJIMYiKLV7zcajUNCo9E/aOH+rc/GKK+W0sVrBQb9/wad3ChD0BujiVevPnU6rdYBoUXSqD4en5+jfSkusz7k/0SMNxWlp9gSOGxgm83G45pVXeAyBTzG1pDnDUVRDAMKCFyck9rLkihwfJb10ZfWwXLKbKSYpqGimqbhE5DTUimRThfLvJyLMSi/lmx5djKYm+YS5URJSIsJCzEtCUUuLm/kYkmGWh+nrz9+enYyMMzlcpku85lrGT4OuDjPZxBmN3000n8h+ejp2dcTBXEzzckFli3kIha5AhvLJ1O0x/u3uCf16NnZ2ed5RcSmt3N5yuOhg0EGBP20h8J1+wepiPDh5MNbMi2/kQszHoqCA+Dk8l9fl7xe72WQl79JDx7ileLOk1wobFUO+v1+GngcEYALNuAyIk7azWf5GzeRfnL//tWtUBSEgc/nCwQCkBGb4yIWt+AyRWFaJsrm7oOrV69eWbG1tRWC7IcIGiKB4TdBIBy6cgVpYB0cEQSWwVHYG0UP7ha8ZAJ/kAn4fOFwNBoCiNlE7erOHBcNeJB3C2AgS6AhYZgAQIBkfAHg2iawV2nt8ZerAAVxwPITtBNzoC7SyP9HfAfEXG3RUYaxdwAAAABJRU5ErkJggg==',
        'media/images/loader.gif' => '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',
        'media/js/jquery.charcounter.js' => 'KGZ1bmN0aW9uKGUpe2UuZm4uY2hhcmNvdW50ZXI9ZnVuY3Rpb24odCxuKXtmdW5jdGlvbiBzKHMsdSl7cz1lKHMpO2lmKHMudmFsKCkubGVuZ3RoPnQpe3MudmFsKHMudmFsKCkuc3Vic3RyaW5nKDAsdCkpO2lmKG4ucHVsc2UmJiFyKXtvKHUsdHJ1ZSl9fWlmKG4uZGVsYXk+MCl7aWYoaSl7d2luZG93LmNsZWFyVGltZW91dChpKX1pPXdpbmRvdy5zZXRUaW1lb3V0KGZ1bmN0aW9uKCl7dS5odG1sKG4uZm9ybWF0LnJlcGxhY2UoLyUxLyx0LXMudmFsKCkubGVuZ3RoKSl9LG4uZGVsYXkpfWVsc2V7dS5odG1sKG4uZm9ybWF0LnJlcGxhY2UoLyUxLyx0LXMudmFsKCkubGVuZ3RoKSl9fWZ1bmN0aW9uIG8odCxuKXtpZihyKXt3aW5kb3cuY2xlYXJUaW1lb3V0KHIpO3I9bnVsbH10LmFuaW1hdGUoe29wYWNpdHk6MX0sMTAwLGZ1bmN0aW9uKCl7ZSh0aGlzKS5hbmltYXRlKHtvcGFjaXR5Oi4wNn0sMTAwKX0pO2lmKG4pe3I9d2luZG93LnNldFRpbWVvdXQoZnVuY3Rpb24oKXtvKHQpfSwyMDApfX10PXR8fDI1NTtuPWUuZXh0ZW5kKHtjb250YWluZXI6IiNzaG91dGJveC1tZXNzYWdlLWNvdW50ZXIiLGNsYXNzbmFtZToiY2hhcmNvdW50ZXIiLGZvcm1hdDoiJTEvMjU1IixwdWxzZTp0cnVlLGRlbGF5OjB9LG4pO3ZhciByLGk7cmV0dXJuIHRoaXMuZWFjaChmdW5jdGlvbigpe3ZhciB0PSFuLmNvbnRhaW5lci5tYXRjaCgvXjwuKz4kLyk/ZShuLmNvbnRhaW5lcik6ZShuLmNvbnRhaW5lcikuaW5zZXJ0QWZ0ZXIodGhpcykuYWRkQ2xhc3Mobi5jbGFzc25hbWUpO2UodGhpcykuYmluZCgia2V5ZG93biIsZnVuY3Rpb24oKXtzKHRoaXMsdCl9KS5iaW5kKCJrZXlwcmVzcyIsZnVuY3Rpb24oKXtzKHRoaXMsdCl9KS5iaW5kKCJrZXl1cCIsZnVuY3Rpb24oKXtzKHRoaXMsdCl9KS5iaW5kKCJmb2N1cyIsZnVuY3Rpb24oKXtzKHRoaXMsdCl9KS5iaW5kKCJtb3VzZW92ZXIiLGZ1bmN0aW9uKCl7cyh0aGlzLHQpfSkuYmluZCgibW91c2VvdXQiLGZ1bmN0aW9uKCl7cyh0aGlzLHQpfSkuYmluZCgicGFzdGUiLGZ1bmN0aW9uKCl7dmFyIGU9dGhpcztzZXRUaW1lb3V0KGZ1bmN0aW9uKCl7cyhlLHQpfSwxMCl9KTtpZih0aGlzLmFkZEV2ZW50TGlzdGVuZXIpe3RoaXMuYWRkRXZlbnRMaXN0ZW5lcigiaW5wdXQiLGZ1bmN0aW9uKCl7cyh0aGlzLHQpfSxmYWxzZSl9cyh0aGlzLHQpfSl9fSkoalF1ZXJ5KTs=',
        'media/js/jquery.placeholder.js' => 'KGZ1bmN0aW9uKGUpe2UuZm4ucGxhY2Vob2xkZXI9ZnVuY3Rpb24odCl7cmV0dXJuIHRoaXMuZWFjaChmdW5jdGlvbigpe2lmKHRoaXMudHlwZSE9InRleHQiJiZ0aGlzLnR5cGUhPSJ0ZXh0YXJlYSIpe3JldHVybn1pZih0aGlzLnZhbHVlPT0iIil7dGhpcy52YWx1ZT10fWUodGhpcykub24oImZvY3VzIixmdW5jdGlvbigpe2lmKHRoaXMudmFsdWU9PXR8fHRoaXMudmFsdWU9PSIifHx0aGlzLnZhbHVlPT0iXG4iKXt0aGlzLnZhbHVlPSIifX0pLm9uKCJibHVyIixmdW5jdGlvbigpe2lmKHRoaXMudmFsdWU9PXR8fHRoaXMudmFsdWU9PSIiKXt0aGlzLnZhbHVlPXR9fSl9KX19KShqUXVlcnkpOw==',
        'media/js/jquery.js' => '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',
        'media/js/shoutbox.js' => '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',
        'media/smilies/1.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAS1BMVEUAAAAAAAD////h4eHLysvu7u7a2tq5uLjz8/PCwsK/v7/+/fvn5+fS0tL39/fPzs/q6uvExMXV1dXIx8ezs7Otrq6mpqb6+vq8vLzvhnRLAAAAAXRSTlMAQObYZgAAAJpJREFUGNNl0EsOwyAMBFCGvwmQkKRN7n/SjlEWrTqIzQPZlo0x+I5RKMO36FzdQggbCKkc6x5dDSHnTKIIvwAb0HvPgXJTYC2WBdfVs8rwsMxCekRUwGMfSRR9t5RZZ/YCUHnZa8rPPJVyJpkD0Wp1jvJKNzyJBueiypkKqe0RMcad8p6kaa2tq8okGYfXHDAPpVJExhDC334+jhMID3PWs5wAAAAASUVORK5CYII=',
        'media/smilies/2.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAS1BMVEUAAAAAAAD////R0dH39/ft7e3Ly8u+vr7Dw8Py8vLn5+e5ubnv8O/q6uve3t7Z2dm0tLSrrKz7+/vz8/Pk5OTh4eHHxsbV1tajo6JrxQChAAAAAXRSTlMAQObYZgAAAIxJREFUGNNl0NsOhCAMRVGO3OTuiOD8/5dOCzFqZj+uNC1BCIFngsF2I0s+fNJaJxAE2+WZm9fRVRcTSFYjkY8Uq1KqRhK7GhQacWrfd+WmyAKvK7C85Z4JLI899600bmmS7fUezxIsrvzRSD6bxTJDy3lIwFUpJwvTHJEUyXcQZ6gOMYnW25Uj+PufHzUbCFMbPkj3AAAAAElFTkSuQmCC',
        'media/smilies/3.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAATlBMVEUAAAAAAAD////BwcHs7Oy8vLzz8/P+/frU09PExMW4uLj39/fLy8vJycni4uLZ2dmmpqXv7+/n5+fd3d3Qz9Czs7P7+/usrK2IiIhDQT+CypK8AAAAAXRSTlMAQObYZgAAAJtJREFUGNNl0N0OgyAMBWAOFQQBGRP/3v9FdzpnYrJDuOBraJoaY/CMUXAxh7rM70EDwiSlB4XmvW8kOEoFBiCl5BuuT7AW44htS/4SWGYkPQU89hYp0LqlXH0mQQfw5vVogwqA3zxaoKwO9jgBnIfFPFP2ifQNYVkor5WdhG9BrTWo7EqaEELvKkpOYik551JgbnIiMUYh/O3nA0FQB2HuvOFYAAAAAElFTkSuQmCC',
        'media/smilies/4.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAVFBMVEUAAAAAAAD////s7OzLy8vz8/Pa2tq+vr7h4eL+/fvCwsK4t7j39/fn5+fExMS7u7vOzs6npqbv7+/S0dKzs7P/AAD6+vre3t7U1NStrq7Ix8e6CgomKOm8AAAAAXRSTlMAQObYZgAAAJhJREFUGNNl0FsOgyAURVEOlYcUkIoo2vnPs+cGP0y6CT8LAgSlFJ4pAZenag+fXhIIb3eVbgmrMWYlYQlTscALiDGadUiF1phn7Hs0InmCZjPpliACDv0QWdcUOWfcBSBxjrsoz/ckyrYElE7yCcl7yslNGHl/WMpnE2rfBsu6yElCaw2111JEBgGTdEHdtDgXQs6B8Pc/P6mqCGgl2srMAAAAAElFTkSuQmCC',
        'media/smilies/5.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAATlBMVEUAAAAAAADZ2dnNzM3T09P39/ft7e2/v7/n5+ff39/y8vLj4+P7+/vv8O/q6uu4t7jz8/PExMTCwsK7u7vJyMizs7Otrq6mpqb/AAC6CgpzSBbNAAAAAXRSTlMAQObYZgAAAJZJREFUGNNl0NsOAiEMBFCGe2FBlmUV//9HbYnGNc7jSTNtqpTCNUog7MZqyrF67ysYbmGw5OhLaqkw4ejDgnItzTnXyhIDTdEnt22bSyJSg+gb8JEucp2RHn3p+e6qa5cX+bknspxHwKIcETOx3HkIWCEiLXIKzeeE5liWhxDmnLDWGiOyCMAwnAH1piOE3ve9Q/3/5wUQJgjjkpLC4gAAAABJRU5ErkJggg==',
        'media/smilies/6.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAS1BMVEUAAAAAAADCwsPz8/P////m5ubS0dK9vb3a2tr39/ft7O3g4ODv8O+4t7j7+/vLy8vJycnq6uuzs7Otra3V1taoqKijo6KIiIhDQT+a7qCKAAAAAXRSTlMAQObYZgAAAJFJREFUGNNl0NsOgyAQBFCGFeWmQGur//+lnaW2IXHe9mQzSzDGYIxRWGyZfXKuxRgbCKut806JWUQyCQsFybUsIQTJXQp0RcK2bUFw1YACTKOMO9rjxx7ewv8WclQBcL0HgKM8FkzHyeE8JrikspK+QUqe8lSynC289zvl1UkzayjvTtbWWkqpFeZHNA3h9j8fZB4Hf9B6OtkAAAAASUVORK5CYII=',
        'media/smilies/7.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAASFBMVEUAAAAAAAD////s7OzEw8Pz8/PLy8v+/fq7u7u4uLj39/fa2tnT09Pn5+e/v7/v7+/i4uLQz9Czs7Otrq6mpqb7+/ve3t7Ix8dBjuOIAAAAAXRSTlMAQObYZgAAAIxJREFUGNNl0FsOgyAURVEOgvJWbIX5z7TnFm1s3ISfBQGCUgr3lEAxc4pty5MEgi+9pkhYrbUrCc7MNQITEEKw65AErbEsOI5gh0CzhXQXcOifdMi6psg54y4AmfO8y/+9J1N2Z3CVt43y8g56hNaiyO5xFWOivIXGlpRqFfmSNLMOdZIrxUiEx/98AP6TBsj12eDBAAAAAElFTkSuQmCC',
        'media/smilies/8.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAS1BMVEUAAAAAAAD////87NC6urry8/PDw8T39/fm5ubt7e21tLT8/PzY2NfLy8vv8O/q6uvf39/S0tK/v7/JycnQz9Ctrq6pqKna2tujo6Lc/h/kAAAAAXRSTlMAQObYZgAAAJZJREFUGNNl0OsOgyAMBWCOs0LlJhfn3v9J1+KMJjuhP/hSaFJjDJ4xCnWJJWzOZWbOEJhr6+FwjhMRpQyRpXUAWcpaSkMi5BGT9fCWTikHwICfbsHogb+k6aicyF7/VNxJLLJWTC94KTnZqczQ2yluE9nXh2yHyFuafoIQgsouNASl9C7yGaSJMbYGc9I617poYP738wVe0gcsmg9RpgAAAABJRU5ErkJggg==',
        'media/smilies/9.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAUVBMVEUAAAAAAADj4+O9vb3a2dnt7e339/fExMTn5+fS0tLLy8vy8vLv8O/BwcG4t7j7+/vz8/Pq6uve3t7JyMinpqbPzs+zs7P/AADV1dWtrq66CgotDG0qAAAAAXRSTlMAQObYZgAAAJZJREFUGNNl0FkOwyAMBFDG7AEKCSUkvf9Ba4qitsp8PnmThRD4jRgg7eLVRm7VWq9geKTaDkVOx1BCZIJMdZSssRhjSsSnCYqgYTKyCVM84HQB8lfGmGDylPucuWu7dukhf/c4ll0mtIOJHBwRy8lFmCHaFMtzH9RfHYpzDDmZ0HuH9761IZOAunAqxEUyJWttgrj/5w0YgQjy6vUXEwAAAABJRU5ErkJggg==',
        'media/smilies/10.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAbFBMVEUAAAAAAADZ2dnt7e3f39/My8vBwcH29/fy8vLv8O/q6uvR0dH7/Pzz8/O7u7vn5+fPzs/KycrDw8O/vr7k5OTT09PIyMfExMS5uLmzs7Otrq7h4eHc3NzV1tb39/e3traoqKjn5uajo6K9vbwurZHaAAAAAXRSTlMAQObYZgAAAK1JREFUGNNl0NcOgzAMBdCYTJJAVglQVmn//x/rgEQr4cej6yETQuC/SIHU865iD6cppRoQBpH9Mk+O1qpRNRK0IhiM6LqRq2zqIpFDxYCCtGClKoJjABxtAKxd1ZnBrp0qaW3J3Of8duljF0XZElz3gHYoYyuui/fHhPLcPn3wXTUzNjE2FxmHhGSWqtSC8ioUM/fGdMZ4lPdBos+Bcx4ykJO2NgkRYxQIt/98AWJ6C7mq/l7yAAAAAElFTkSuQmCC',
        'media/smilies/11.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAXVBMVEUAAAAAAADz8/PLy8vn5+fT09Ps7OzIyMjExMTCwsK/v7/h4eK7u7u4t7j////a2tr39/fv7+/q6uvX19fOzs77+/uzs7Pt7e3e3t6tra3k5OSoqKjQz9Cjo6Kur69ThNbwAAAAAXRSTlMAQObYZgAAAKlJREFUGNNl0EkOwjAMBdD8NHNK0wwdKIX7HxO7AQkJL7x48aQIIfAbgiG4Qdf9UMVspoDgFmyrKSqTpZTZQGD0FhQlU5plvmTQXIJ5WZZZstAYQG0SmEh6DaYJhtNXLL2icOI5fRfAg8C7WPo9ke/ZiiJZqa3ptMdDKXVEktdtdOgR455I7iv1UVWtKaWqSR6dhnZqrc9G8rzIk3FYiA+NIXjvnIf4/583UaMJgMPx1QUAAAAASUVORK5CYII=',
        'media/smilies/12.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAb1BMVEUAAAAAAADd3d3y8/P4+Pjn5+fIyMi4t7jLysvDw8O7u7vs7Oybm5vv7+/Z2djV1dXS0tLBwcG/v7++vr6zs7Otrq7q6uvi4uLExMX////e3t7Pz8/Ozs6oqKj/AADt7e2jo6KqpqFxcG/t7O2/iTQ7ac/oAAAAAXRSTlMAQObYZgAAAKlJREFUGNNl0NsOgyAMBmAqgiBncZ7n5rb3f8a16hKTNdCLL39aAmMMrsUI8qCin3rRmYfpAKFq5ByKXhjHOXcGGNRJRox3eMuSOxKtwE8CeFkS7XIZ/JMC8FA7JUGBdTSaQ7soL6hZZ0gu73lvAqXF9UvYY2J7WZRblbWag4cP9PaQtmoGucQAI1gfUO5EWqolEs0oT6KcBqkUjKsEdlKdm6T1uiL8/c8XHCgJ4bmnZMcAAAAASUVORK5CYII=',
        'media/smilies/13.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAb1BMVEUAAAAAAADY2Njs7O329/fy8vLv8O/R0dHExMS4t7jz8/Pq6uvh4eHe3t7Pzs/IyMjCwsK+vr67u7v7+/vn5+fa2trT09PMy8vKysrBwcGzs7Pn5+bl5eXi4+PV1daurq6pqan39/ft7e2jo6L///9D6jH4AAAAAXRSTlMAQObYZgAAAK9JREFUGNNl0FsSgyAMBVACKFZRUEBQfFTb/a+xwfJRp/k8k+RmQgiB3yIJ+sqPtF1tw07WAMJjUt3mpGVlURclEgw6CNouTVnzg9flV4BKYMANGF4kwTUA9qwB3ua4RHvhZGQFNyb3aHXfk7PWnMWS3O6xKPOATYmWGOMiUfZHD4DkWill61CeM85BJzZKHaVbkj2R8p0QoxAdyuuiqVIh+BAUkExDP2ldVRrh7z8fVBYNG7ZOSNsAAAAASUVORK5CYII=',
        'media/smilies/14.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAb1BMVEUAAAAAAADs7O3Z2NjS0tLCwsK/v7+5ubn29/fy8vLv8O/Ly8vz8/Pq6uvn5+fh4eHExMT6+vrk5OTf397Ix8ezs7PKysq8vLyurq6pqan39/ft7e3n5ubb29vV1tbPzs+3trb9/f3Ozs6jo6KjoqJxdxbNAAAAAXRSTlMAQObYZgAAAKlJREFUGNNl0NcOgzAMBVCckBCyA2GUDe3/f2MdRNVW+PHIuh5ZlsFvZQm4VzmtK2vISAwgFDyuy+wskaUupQEU1qYWI7UYhJYoHVNAHRAQAYIok2AMgB01wL4PpzAMdhMpRQip555zzjq+swjK9rePRWkKFg9INdmpcij91vnrBOfqGeXRFPwSSumSpP9QnufrivI6ifnYKqXamE59Im0F54x5zxBu/3kDaSoK5x4EWmEAAAAASUVORK5CYII=',
        'media/smilies/15.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAYFBMVEUAAAAAAAD////s7OzExMTBwcHv8O/i4uLLy8u4t7j39/fy8vLn5+a7u7vq6uvS0tLQz8/Ix8e+vr6zs7Pz8/Pt7e3e3t7Z2djKysqtrq77+/vc3NzV1tapqKmoqKijo6ID61Q/AAAAAXRSTlMAQObYZgAAAJhJREFUGNNl0FkOgzAMBNAM2SFkK0so0N7/lnVEqaiYSP54imzLjDFcwypkYcI8aef5yD0IrExxW7Xjqhs6xcHQyxIB7RXQtoOqIgyaBryWZ9udAoxUTrn/kSX897nPspd9Ru9IHr1MOOKc1iSLzWi+b5pWkv1hfzLPG8lrIToSQowk70pZilSMMSWBEe1EfZZSCCHB7vf5ABRNCOnqc7gTAAAAAElFTkSuQmCC',
        'media/smilies/16.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAASCAMAAACKJ8VmAAAAZlBMVEUAAAAAAAAAI/nZ2dnn5+fy8vLh4eHe3t3S0tLLy8vDwsK7u7vv8O/s7O3q6uu/v7/7+/v29vbz8/PPz8/KycrExMXk5OTV1dXIyMi5uLmzs7Otrq739/e3traoqKjt7e2jo6L29/aJ8briAAAAAXRSTlMAQObYZgAAAMhJREFUGNNNkFmugzAMRXOdiTAkQBIILby+7n+TtSsh9f5EObKPLStFpO7cH4Ag+b5CkSqR9puJRFMEKTpSy6SdmUZa7RhJYehLp4EILOd7HSEkdICZLDDPi4WioQbAmdd6Mjote6RGNHaZpeb2+C2O63IuX8+RkHcvsyzPmphcCdwm+0wvRMPmx4CWd+3dZgw2x+bnNaAI8s7BazY/HwdqAXYNaL2z508QWgC6rsuZPf+CUl9bCSGUxh4IuoaU+r7WHnIg/EapDzNHCz75yOpzAAAAAElFTkSuQmCC',
        'media/smilies/17.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAbFBMVEUAAAAAAADz8/PZ2dnT0tPs7OzExMS4uLjv7+/KysrCwsK+vr67u7v6+vr29/fq6uvn5+fh4eHf3t/Pzs/My8vV1dXIyMfAwMCzs7P39/ft7e3k5OTc3NzR0dGtra3n5+aoqKj8/f2jo6Kur6+AYaqyAAAAAXRSTlMAQObYZgAAAK1JREFUGNNl0NsSgyAMBFCWiwqKiKh4rbX9/39ssD44Yx7P7GwyYYzhPixBmXVStEvj1KwcCPI4hH71jSo454UCQ2X0RhFXAFPNi79IAIrXFrbmSVKNb2Y+2eOYTjEklAGsTZmrB3BAffU8d+W3e2bXkIxVROhFC+z7vniSL4UQJNYW3rcryWtMBNkLASF6kvdJQxc2KeUWSD4nxWzQutN6ALuoKqMxWWbAnv/5AXL0C4AECA21AAAAAElFTkSuQmCC',
        'media/smilies/18.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAA51BMVEUAAAAAAADt7e2/v7/y8/Pv8O/q6uvLy8vDw8PoAQHn5+fh4eHf397Z2dnT09PQz9C6u7q5uLmzs7OFAgHn5+bIx8iurq7l5eXc3NzV1ta3trZ6IwbRBQDj4+PFxcWoqKijo6LfDBHuEwmSGgfVGQOqEwKVHgB9FgD39/erq6upqKn9mYn9pYj9n3v9n2v9kGr9g2b9d1r9fVJ+S0eOPjJ9My+AJiCWHBqIKReJNBFvNQ5iLA7QIQ7lCQvKLwPFFwJ9NACYLACLJQC5GgB0FwCfFgDcEABgDQC7DABvCgCwBgCpBgCZAADQ9spZAAAAAXRSTlMAQObYZgAAANJJREFUGNNl0NWSwkAQBdDpkRBPyIYASVbwdXfH9f+/h9tvUNyap1PTUi2EoN0IBnVSCQP/2LWklBYBqqoWNRueK43W2oAonoyizrBumeXgfNo3kPndzfph/C+L66vNfe8LUtwuWj/dQn48lu3Z7ydXDb5b5Vsqdadsd180i/20evbRR/f+XrWBYFafZ4HetZGQfG8fF5LEWIjIJ0rTtO5BslzZ5Dj8PM9vQC6SqqIjDgVB0IScZkwOvoRhGEWQMxCIqMKpkQBdZkkeK2VzAAf32QKpYRKMQadpYgAAAABJRU5ErkJggg==',
        'media/smilies/19.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAXVBMVEUAAAAAAAD9/f3t7e3Z2dnLy8vCwsK/v7+5ubnq6uvIyMjExMTi4uLf39/y8vLv7+/n5+fT09PPz8+zs7Otrq739/e8vLzz8/Pn5+a3traoqKjl5OXV1tWjo6LR0ND3hXSDAAAAAXRSTlMAQObYZgAAAKBJREFUGNNl0MkOgzAMBNA4CdkXAmUrtP//mR3DpQgffHgaeaIIIeh/BIONXdM59V4p5QngbBgOnXpVy1KqJ4gJSO++Yk9LhcyGpJSkAJKmwhIfggwRBH6Ju8Sfwne4C4By7FIVZLu9p4eMqB8IROu67gny2ubYgSjnlLNmGZ2NfErzHJA3EwXEWmvfAfI5ycTQ8QQSF23OWmNiNIDH//wAnhIIZELCdf4AAAAASUVORK5CYII=',
        'media/smilies/20.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAaVBMVEUAAAAAAADW6P7z8/PExMTs7O3n5+fZ2djBwcG4uLj39/fq6uvh4eHPzs++vr67u7vv7+/R0dHLy8vf3t7T09PKycrIx8ezs7Otrq7////l5OXc3NzV1dWoqKjt7e3j4+Ojo6JTU1Pa2dpBLX5mAAAAAXRSTlMAQObYZgAAAKlJREFUGNNl0MkSgyAQBFAa2VRcQMG4ZDH//5GZ0VQqqXDowzt0UyOEwPcTDK2Kox3uptY3XYOgdLnZVm90XxRFT4TOpYB9qXvsVVX0LCpygeYgOgQSkGd8ZJ4lB8vZAylRc3DPuQXQFkBbmuXnP4Zk6pAbIr8YYxZPcilbJKJ18N4PK8tEhCZs1j6t3UiuTIotjCE0JI+DnMopxpgyxJu61jmllIP4v88LrMgKYbuueQAAAAAASUVORK5CYII=',
        'media/smilies/21.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAZlBMVEUAAAAAAADz8/Pt7O3BwcHv8O/X19fExMTq6uvn5+fe3t7a2trIyMi+vr7h4eHT09PR0dHPzs/l5eXKysq5uLmzs7P29/bMy8u6urqtrq63trb////39/fj4+P/3tipqKmoqKijo6JoOFj6AAAAAXRSTlMAQObYZgAAAJtJREFUGNNl0EcSgzAMBVB344JrAEMKyf0vmR+GRQAttHjzR9KIEEL/i/yg11NU9mk6znlHATfhs3LBcMkYkyDaRE3Klk6y8TEyCTnVLvfX1na5ZprwhznnXRyyHO4xkKEhFJ0NpRhTAmRGiOaonKUhWAdZh1u/r3FORch7Bmk/5ZRiShny2UhoX+tUq6cEtM7D0nohtNYCcPnPF+NmCWtt4XmRAAAAAElFTkSuQmCC',
        'media/smilies/22.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAXVBMVEUAAAAAAAD////39/ft7e25ubny8vLS0tLv8O/n5+fLy8vExMTBwcHz8/Pq6uvZ2Njf39/JyMm9vb2zs7Otrq7l5eXi4+PPzs/8/Pz6+vrc3NzV1ta3traoqKijo6IKtjQOAAAAAXRSTlMAQObYZgAAAJpJREFUGNNl0OkOgyAQBGCm3Jeg1lv7/o/ZRSRp0vn5ZdkhyxjDb1iBwTudMNtOCNGBQIZ+OXZYGBWVISqiU55gIuc8GjyPshWKb+vG1SOAFRF4rbfIWyahgDrT9nRtT+ui8rtLkJx19fMfSzLKgBY7zSTvc8CrBjnvRUaJlpQOkqtQHdF6WUg+V5tyzvU9WKVTDiF47wPY/32+beQJM4vPr4sAAAAASUVORK5CYII=',
        'media/smilies/23.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAY1BMVEUAAAAAAAD9/f3z8/Pt7O3S0tLLy8vExMTh4eLY2NjIyMjq6uvCwsK7u7v39/fv7+/n5+fPz8+/vr7////f3t7BwcG5uLmzs7Otrq7k5OTb29u3traoqKjm5+ejo6L6+vq9vbyOY+RJAAAAAXRSTlMAQObYZgAAAKpJREFUGNNl0NsOgyAQBFBGUC6ioPVStLb9/6/sAGnSpPOwyZ5AdrNCCPxGZJh119olxV4p1YOwrW6yh4kqSCkDCYN3LZD6AIyjDEU6NA1ULq9RZtFobuwaBlU8BSjlKw5sehZCQJ0FcBbAWYpy1n1M3eei7AMfZUpXjMlQ7udbd/yHxRizHFn2bdaOYu1hbUt5FKK0zDRRnoVW7bocB1HpHObVe6094e8+HzThCaX/DcBpAAAAAElFTkSuQmCC',
        'media/smilies/24.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAYFBMVEUAAAAAAAD////z8/Pm5ubExMTv8O/h4eHa2trS0tLLy8vBwcG4uLj7+/v29/fs7O2+vr67u7vq6uvX19fQz8/IyMezs7P39/fKysqpqane3t6urq7t7e2vsK+jo6KjoqJiQr9IAAAAAXRSTlMAQObYZgAAAKpJREFUGNNl0NsOgyAMBmB/y0kYoBymc257/7dckV2Y7A8X5EtpQ4dhwDVDg1naKe9apHjEBIabqyUbLaIiIsWExW0FEEkBayDVRFoYjYjg4QN1mfjRQasf/XqRSMF7rul9eBT3odD7tFnAOQsgFZvMGNEzIgmW+8K3sR8IzfLiop9A74blcWfqMSbnJk8mWW2ZOKWwfE5ysm7W2q22r74bLbNzUkrH8LefL2DpCUqo0wDzAAAAAElFTkSuQmCC',
        'media/smilies/25.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAYFBMVEUAAAAAAAD////s7OxrIiL39/fS0tK4t7j7+/vj4+PZ2dnLy8u7u7vy8vLf39/Dw8Tv7+/n5+fPzs++vr6zs7Otrq7KysrIx8jCwsLAwMDz8/Pc3NzV1dWoqKjFxcWjo6LqGbvJAAAAAXRSTlMAQObYZgAAAJ5JREFUGNNl0NkOgyAUBFBGxA0RXOre9v//sneQxCbyNid3C0op/D9FGD+2aLq613wQKLdlOA8BuN0FIbTrzBINGGP2QPFs6gWqqjIuyj2XkmoA7e4amQPUOuzGAAHXLnBXADJoSrpHcpahF5laHhRzjroTeZUjrpzn6A7KVMZMaJpT5E0CM4piGES+JDbO1tp5gUrUjtvqvV+hnv/zA0DpCSo2OCJ/AAAAAElFTkSuQmCC',
        'media/smilies/26.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAZlBMVEUAAAAAAADt7e3Ly8vZ2dnT0tPy8vLv8O/q6uvi4uLd3d3IyMj39/fCwsK+vr67u7vz8/Pn5+fExMTBwcG5uLmzs7Otrq78/PzV1tbn5+bk5OXR0dHPz8/Ozs63traoqKjU1NSjo6JzlPC7AAAAAXRSTlMAQObYZgAAAKtJREFUGNNl0MsSwiAMBVBCoZTyKNBW6VP9/5/0gl3omEUWZy4JE8YYfRcr4FMjRa9jxznvCDCNZs8ArtrQKhANzmyC1k4FsjaoKo3EAN6i3W1bJBWJPAAgV0aUjK2Zaw4edAqtzKm7jkw6grCLQ86f/0TIPCD0BK3Lsqwacjs9NTuo16T7vsg8eTKHzIKEEBnyqFRKSrntkFelMZmmlCH2oXPwo3MpOcDffd6XbwpOUKwTjAAAAABJRU5ErkJggg==',
        'media/smilies/27.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAXVBMVEUAAAAAAAD////Z2dnS0tLLy8vh4eHExMTy8/PBwcG4t7jn5+fPzs++vr67u7vt7O3f397V1dXIx8f39/fv7+/q6uvc3Nyzs7Otrq7l5OXj4+OpqKmoqKijo6KztLP5sU3OAAAAAXRSTlMAQObYZgAAAKBJREFUGNN10NsOwiAQBFCmIJRCC6XQi63+/2c6WDUmxnk8GdjNCiHwHVGhNxcl49WVEEIBobPJjzNcyG3bZhIGywq2AkyY2lzFULRD06AhfYTA/BWbOOp8BP7znnWWkEOV1z5gQnGUZaglGfXmnNs0ZWUJpDlqreNM2ZeuB7waJaSUI+VY76QapZT3lNuxPlvpUpMgSDtp6K01xljCz30eCoAIyBxk7tMAAAAASUVORK5CYII=',
        'media/smilies/28.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAV1BMVEUAAAAAAAD9/f3z8/Pm5ubExMTa2tnBwcHe3t64t7jv7+/s7O3q6uvi4uLS0tLPzs++vr67u7vMy8vIyMjV1dXKycqzs7P39/etrq7t7e2pqKmoqKijo6KFQO1FAAAAAXRSTlMAQObYZgAAAJ5JREFUGNNl0IsOgyAMBVAqz/GQCSLq9v/fuVuiicluCCEnhTYIIegZwfDWZTYuqRiOEAnwsjWvJqngpZQeRIttqFbRy9679CyapmmiQJwuWQDItd9yrVvsuBWJg3dGLxzvXoHlMc8RFWRbeCAmToLsKGpMziXnDOTcBs0rkTFmhXx2plryjOQM+Q6yurZSSqskQCdoeVurtbaAv//5AYvvCLxrNKL5AAAAAElFTkSuQmCC',
        'media/smilies/29.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAbFBMVEUAAAAAAADS0tLt7e3n5+fZ2dny8vLExMTq6uvv8O/Pzs/KysrCwsK+vr67u7v6+vr29/bz8/PMy8u1tbXh4eHf39/IyMfAwMC4uLj39/fk5OTe3t7c3NzV1tatra2xsrGoqKj9/f3U09Sjo6IM/tRiAAAAAXRSTlMAQObYZgAAAK9JREFUGNNl0OkOwiAQBGCmQEuB3hy9a/X939Et0ahxf34ZZskyxvA97IKq6DO5zEJxzhUIxhj0tjrBy7zLSyLU1mTwUOgwtV35EgnBczRN0+aXUA0cOCac55TEUrGnTJsy71d+VmXXpp7PLpV2cZLh5z/ikjpC3+UCCCFmR3JQiAirh/PLSrIfIxGyTUpIuZHc9oEo9Dqj0ZrkkSgWwZjemACW6BjqKlpbFBbs/z5PgFgLuL+M/7AAAAAASUVORK5CYII=',
        'media/smilies/30.png' => 'iVBORw0KGgoAAAANSUhEUgAAABEAAAARCAMAAAAMs7fIAAAAZlBMVEUAAAAAAADz8/Pm5ubExMTS0tLZ2NjMy8vBwcHv8O/7+/vs7O3i4uLf397Pzs++vr67u7v29vfq6uvIyMjV1dbJycq5uLmzs7Otrq739/ft7e3r6+zc3Nza2dq3traoqKijo6L29/a2LN40AAAAAXRSTlMAQObYZgAAAKhJREFUGNNl0FkSgyAQBFCaXREUFY1rkvtfMoNmrcznq6aHGsYYvodlqKVR2leidbNrQTDYLvRrJVzBOS8WMDQ2KQ3RFojTnRdZ6BG8cDyiLCM/BRswAyXK6SmKxJHkzKvHUw+PU6Sez67lvWv/+Y8gGZscyiQgREVyoRDOqbxfs4xDLVNQvdab1j3J9aDOBEUTAsntICu7ZIxJHdhJe1NbK6W0YP/3eQDryQqNBejLsQAAAABJRU5ErkJggg==',
        'media/smilies/31.png' => 'iVBORw0KGgoAAAANSUhEUgAAABMAAAATCAMAAABFjsb+AAAAY1BMVEUAAAAAAADExMTt7e3S0tLMy8vBwcH39/fy8vLv8O/q6uvPzs+4uLjc3dy7u7v////n5+fj5OTg4ODIyMi+vr7z8/PZ2NjJycqzs7P7+/vV1datra3n5ubZ2dmoqKijo6Kur6/+tvYKAAAAAXRSTlMAQObYZgAAAK1JREFUGNN10FkSgjAQBFA7G0sMSwIJIKj3P6XDoCJl0R/5eDXVM5XLSfCbN3VCq+jappRSlmC6mmAn5xtZ5H1eMKIySQFtWQBZ1hebCY26hlyfMct3AxkOpoBZ5sBI9u2Lnvr6jPv2vXQK75WbHe5r2IaKBrFmbubWsz1pEFYtzsN759huwxUiWTXFBUuc2O6EnQjaKoq1bA9GI0LSWqdA9sGqM0YIYXD2f/95AS/XCnTBslVyAAAAAElFTkSuQmCC',
        'media/smilies/32.png' => 'iVBORw0KGgoAAAANSUhEUgAAABMAAAATCAMAAABFjsb+AAAAYFBMVEUAAAAAAAD////s7Oy4uLjv7+/Ly8vDw8TBwcG7u7vy8vL29/bd3t3S0tLJycmzs7P7+/vz8/Pn5+fk5OTZ2NjQz9Curq6pqan6UCb39/fh4eG+vr7V1tWjo6K9vbxCAgIY+6t2AAAAAXRSTlMAQObYZgAAAJ1JREFUGNN10NkOgyAQheEeh00EVFyKS9v3f8sCttik8b/g4guZSeZ2EX770CaFHc3gKYVMTLlpN6snrnvNM6KOBgzEgaXp+WFSoKpA6ekafRqiIdpSzAKeNNCVf8qltcT7psxjCmecDttQfQP5bG2Ns2HNNrNnodWYbPeWFRvH/bA5YgivEGDtNGV7ZEwJIZzDrWC9KSWlVLi6339vj+4Hw+xjWOgAAAAASUVORK5CYII=',
        '.htaccess' => 'PElmTW9kdWxlIG1vZF9kZWZsYXRlLmM+DQogIEFkZE91dHB1dEZpbHRlckJ5VHlwZSBERUZMQVRFIHRleHQvaHRtbCB0ZXh0L2NzcyBhcHBsaWNhdGlvbi94aHRtbCt4bWwgYXBwbGljYXRpb24vamF2YXNjcmlwdCBhcHBsaWNhdGlvbi94LWphdmFzY3JpcHQNCiAgQnJvd3Nlck1hdGNoIF5Nb3ppbGxhLzQgZ3ppcC1vbmx5LXRleHQvaHRtbA0KICBCcm93c2VyTWF0Y2ggXk1vemlsbGEvNFwuMFs2NzhdIG5vLWd6aXANCiAgQnJvd3Nlck1hdGNoIFxiTVNJRSAhbm8tZ3ppcCAhZ3ppcC1vbmx5LXRleHQvaHRtbA0KPC9JZk1vZHVsZT4NCg0KPElmTW9kdWxlIG1vZF9leHBpcmVzLmM+DQogRXhwaXJlc0FjdGl2ZSBPbg0KIEV4cGlyZXNCeVR5cGUgICAgIGltYWdlL2dpZiAgICAgICAgICAgICAgICAgICAiYWNjZXNzIHBsdXMgMSBtb250aCINCiBFeHBpcmVzQnlUeXBlICAgICBpbWFnZS9wbmcgICAgICAgICAgICAgICAgICAgImFjY2VzcyBwbHVzIDEgbW9udGgiDQogRXhwaXJlc0J5VHlwZSAgICAgdGV4dC9jc3MgICAgICAgICAgICAgICAgICAgICJhY2Nlc3MgcGx1cyAxIHdlZWsiDQogRXhwaXJlc0J5VHlwZSAgICAgdGV4dC9qYXZhc2NyaXB0ICAgICAgICAgICAgICJhY2Nlc3MgcGx1cyAxIHdlZWsiDQogRXhwaXJlc0J5VHlwZSAgICAgYXBwbGljYXRpb24vamF2YXNjcmlwdCAgICAgICJhY2Nlc3MgcGx1cyAxIHdlZWsiDQogRXhwaXJlc0J5VHlwZSAgICAgYXBwbGljYXRpb24veC1qYXZhc2NyaXB0ICAgICJhY2Nlc3MgcGx1cyAxIHdlZWsiDQo8L0lmTW9kdWxlPg==',
        'ajax.php' => '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',
        'index.php' => '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'
    );
    
?><!doctype html>
<html lang="en">
  <head>
    <title>Installation | Shoutbox</title>
    <meta charset="utf-8" />
    
    <style type="text/css">
        * {
            padding: 0;
            margin: 0;
        }
        
        html, body {
            height: 100%;
            width: 100%;
            font: 12px Verdana, Tahoma, Arial, sans-serif;
            background-color: #fefefe;
        }
        
        a {
            text-decoration: none;
        }
        
        a:active {
            outline: 0;
        }
        
        ul {
            list-style-position: inside;
        }
        
        h1 {
            font-family: Helvetica, Trebuchet MS;
            font-size: 26px;
            letter-spacing: -1px;
            color: #444444;
            margin-bottom: 8px;
        }
        
        h1 img {
            vertical-align: middle;
            margin: -6px 2px 0 0;
        }
        
        *+html h1 img {
            position: relative;
            top: 3px;
        }
        
        #wrapper {
            position: absolute;
            top: 50%;
            left: 50%;
            width: 750px;
            height: 400px;
            margin-top: -200px;
            margin-left: -375px;
            border: 1px solid #888888;
            background-color: #ffffff;
            -webkit-border-bottom: 6px;
            -moz-border-radius: 6px;
            border-radius: 6px;
        }
        
        #head {
            font-weight: bold;
            font-size: 13px;
            color: #ffffff;
            background-color: #3272a0;
            border-bottom: 1px solid #aaaaaa;
            padding: 6px 8px;
            -webkit-border-radius: 5px 5px 0 0;
            -moz-border-radius: 5px 5px 0 0;
            border-radius: 5px 5px 0 0;
        }
        
        #content-wrapper {
            height: 346px;
        }
        
        #sidebar {
            height: 334px;
            width: 160px;
            background-color: #eaeaea;
            padding: 6px 10px;
            border-right: 1px solid #aaaaaa;
            float: left;
        }
        
        #sidebar ul li {
            list-style-type: none;
            font-weight: bold;
            color: #444;
            padding: 2px 0 2px 13px;
            font-size: 11px;
        }
        
        #sidebar ul li.ative {
            color: #000000;
            padding-left: 0;
        }
        
        #sidebar ul li.ative:before {
            content: "» ";
        }
        
        #sidebar ul li:before {
            content: " ";
        }
        
        #content {
            height: 322px;
            width: 541px;
            color: #333333;
            background-color: #ffffff;
            padding: 12px 14px;
            float: right;
            overflow: auto;
        }
        
        #content label {
            width: 140px;
            display: inline-block;
            font-weight: bold;
        }
        
        #content input.button {
            border: 1px solid #666666;
            background-color: #eeeeee;
            float: right;
            color: #444444;
            padding: 4px 6px;
            font-weight: bold;
            cursor: pointer;
        }
        
        #content input.text {
            border: 1px solid #666666;
            background-color: #fcfcfc;
            color: #444444;
            padding: 1px 2px;
            margin: 4px 0;
        }
        
        #content input.text[disabled] {
            background-color: #eeeeee;
            cursor: default;
        }
        
        #content input.disabled {
            opacity: 0.4;
        }
        
        #content span.ok {
            color: #008000;
            font-weight: bold;
        }
        
        #content span.error {
            color: #ff0000;
            font-weight: bold;
        }
        
        #footer {
            font-size: 9px;
            color: #555555;
            background-color: #eaeaea;
            border-top: 1px solid #aaaaaa;
            padding: 6px 8px;
            text-align: right;
            position: relative;
            top: -7px;
            -webkit-border-radius: 0 0 6px 6px;
            -moz-border-radius: 0 0 6px 6px;
            border-radius: 0 0 6px 6px;
        }
        
        .hidden {
            display: none;
        }
        
        .clearfix:after {
        	content: ".";
        	display: block;
        	clear: both;
        	visibility: hidden;
        	line-height: 0;
        	height: 0;
        }
         
        .clearfix {
        	display: inline-block;
        }
        </style>
            
        <script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1/jquery.min.js"></script>
        <script type="text/javascript">
            $(document).ready(function() {
                $('input:button').on('click', function() {
                    if ($('input:text').size() > 0) {
                        var inputs = '';
                        $('input:text').each(function() {
                            inputs += '&' + $(this).attr('name') + '=' + $(this).val() ;
                        });
                    } else {
                        var inputs = '';
                    }
        
                    if ($(this).attr('name') == '../') {
                        location.href = (location.href).substr(0, (location.href).lastIndexOf('install'))
                    } else {
                        location = $(this).attr('name') + location.search.replace('?step=', '').substr(1) + inputs;
                    }
                });
                
                if ($('.error').size() > 0) {
                    $('input:button').attr('disabled', 'disabled').addClass('disabled');
                } else {
                    $('p.ok-message').fadeIn('slow');
                }
            });
        </script>
    </head>
    <body>
        <div id="wrapper">
            <div id="head">Shoutbox Installation/Update Wizard</div>
            <div id="content-wrapper" class="clearfix">
                <div id="sidebar">
                    <ul>
                        <li<?php if(!isset($_GET['step'])) echo ' class="ative"'; ?>>Introduction</li>
                        <li<?php if(isset($_GET['step']) && $_GET['step'] == 1) echo ' class="ative"'; ?>>Requirements</li>
                        <li<?php if(isset($_GET['step']) && $_GET['step'] == 2) echo ' class="ative"'; ?>>General settings</li>
                        <li<?php if(isset($_GET['step']) && $_GET['step'] == 3) echo ' class="ative"'; ?>>Database settings</li>
                        <li<?php if(isset($_GET['step']) && $_GET['step'] == 4) echo ' class="ative"'; ?>>Create table &amp; files</li>
                        <li<?php if(isset($_GET['step']) && $_GET['step'] == 5) echo ' class="ative"'; ?>>Finish</li>
                    </ul>
                </div>
                <div id="content">
                    <?php
                        if (!isset($_GET['step'])) {
                            $_GET['step'] = 0;
                        }
            
                        switch($_GET['step']) {
                            case 1:
                    ?>
                    <h1><img src="<?php echo $base64Inline['folder']; ?>" alt="" /> Requirements</h1>
                    <p>Before you can install/update the shoutbox, the wizard will check your webspace/server for compatibility.</p>
                    <p>&nbsp;</p>
                    <p><label>PHP Version:</label> <?php echo (version_compare(PHP_VERSION, '5.0.0', '>')) ? '<span class="ok">OK (' . PHP_VERSION . ')</span>' : '<span class="error">Error: The shoutbox requires at least PHP5.</span>';?></p>
                    <p><label>MySQLi:</label> <?php echo (extension_loaded('mysqli')) ? '<span class="ok">OK (' . mysqli_get_client_info() . ')</span>' : '<span class="error">Error: The shoutbox requires a MySQLi database and the corresponding PHP module.</span>';?></p>
                    <p><label>Multibyte String:</label> <?php echo (extension_loaded('mbstring')) ? '<span class="ok">OK</span>' : '<span class="error">Error: The shoutbox requires the mb_* string functions.</span>';?></p>
                    <p><label>CHMOD:</label> <?php echo (substr(sprintf('%o', fileperms('./index.php')), -3) == '666' || substr(sprintf('%o', fileperms('./index.php')), -3) == '777') ? '<span class="ok">OK</span>' : '<span class="error">Error: This file (install/index.php) requires at least chmod 666 or 777.</span>';?></p>
                    <p>&nbsp;</p>
                    <p class="hidden ok-message"><b>Congratulation, the conditions are fulfilled.</b></p>
                    <p><input type="button" class="button" value="Next &raquo;" name="index.php?step=2" /></p>
                <?php
                break;
                case 2:
                ?>
                  <h1><img src="<?php echo $base64Inline['settings']; ?>" alt="" /> General settings</h1>
                  <p>Please fill up the form above. For more information, move to the setting title.</p>
                  <p>&nbsp;</p>
                  <p><label title="The title/heading that appears over the shoutbox">Title/Heading:</label> <input type="text" name="title" value="Shoutboxname" class="text" /></p>
                  <p><label title="How often the shoutbox should refresh/get new shouts (in seconds)">Refresh rate:</label> <input type="text" name="refresh" value="2.5" class="text" /></p>
                  <p><label title="How often a visitor could send a new shout (in seconds)">Spam protection:</label> <input type="text" name="spam" value="1" class="text" /></p>
                  <p>&nbsp;</p>
                  <p><input type="button" class="button" value="Next &raquo;" name="index.php?step=3" /></p>
                <?php
                break;
                case 3:
                ?>
                  <h1><img src="<?php echo $base64Inline['database']; ?>" alt="" /> Database settings</h1>
                  <p>Now enter your (prefered) database settings.</p>
                  <p>&nbsp;</p>
                  <p><label>Database engine:</label> MySQL</p>
                  <p><label>Database hostname:</label> <input type="text" name="db_host" value="localhost" class="text" /></p>
                  <p><label>Database username:</label> <input type="text" name="db_user" value="" class="text" /></p>
                  <p><label>Database password:</label> <input type="text" name="db_password" value="" class="text" /></p>
                  <p><label>Database name:</label> <input type="text" name="db_name" value="" class="text" /></p>
                  <p>&nbsp;</p>
                  <p><u><b>Improved database table settings</b></u></p>
                  <p><label>Table prefix:</label> <input type="text" name="db_prefix" value="sb_" class="text" /></p>
                  <p><label>Table charset:</label> <input type="text" name="db_charset" value="utf8" class="text" disabled="disabled" /></p>
                  <p>&nbsp;</p>
                  <p><input type="button" class="button" value="Next &raquo;" name="index.php?step=4" /></p>
                <?php
                break;
                case 4:
                ?>
                  <h1><img src="<?php echo $base64Inline['files']; ?>" alt="" /> Create table &amp; files</h1>
                  <?php
                  $link = @mysqli_connect($_GET['db_host'], $_GET['db_user'], $_GET['db_password'], $_GET['db_name']);
                  
                  if (!$link) {
                      $error = 'Unable to connect to the database, please check your configuration.';
                  }
                  
                  if (isset($error) && !empty($error)) {
                      echo '<p><span class="error">Error: ' . $error . '</span></p>';
                  } else {
                      echo '<p>Creating tables......</p><p>&nbsp;</p>';
                      echo '<p>Creating table "' . $_GET['db_prefix'] . 'shouts"...';
                      $query = mysqli_query($link, 'CREATE TABLE IF NOT EXISTS `' . $_GET['db_name'] . '`.`' . $_GET['db_prefix'] . 'shouts` (
                      `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
                      `name` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT "Guest",
                      `message` varchar(255) COLLATE utf8_unicode_ci NOT NULL DEFAULT "-",
                      `time` int(10) UNSIGNED NOT NULL,
                      `ip` varchar(45) COLLATE utf8_unicode_ci NOT NULL,
                      PRIMARY KEY (`id`)
                      ) ENGINE=MyISAM  DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci AUTO_INCREMENT=42;');
                      if (!$query) {
                          echo '<span class="error">ERROR: ' . mysqli_error($link) . '</span></p>';
                      } else {
                          clearstatcache();
                          echo '<span class="ok">OK</span></p>';
                          echo '<p>&nbsp;</p><p><span class="ok">All tables have been created.</span></p><p>&nbsp;</p>';
                          echo '<p>Creating folder "lib"...';
                          if (!@mkdir('../lib') && is_dir('../lib') == false) {
                              echo '<span class="error">ERROR: Unable to create "lib" folder</span></p>';
                          } else {
                              echo '<span class="ok">OK</span></p>';
                              echo '<p>Creating folder "media"...';
                              if (!@mkdir('../media') && is_dir('../media') == false) {
                                  echo '<span class="error">ERROR: Unable to create "media" folder</span></p>';
                              } else {
                                  echo '<span class="ok">OK</span></p>';
                                  echo '<p>Creating folder "css"...';
                                  if (!@mkdir('../media/css') && is_dir('../media/css') == false) {
                                      echo '<span class="error">ERROR: Unable to create "css" folder</span></p>';
                                  } else {
                                      echo '<span class="ok">OK</span></p>';
                                      echo '<p>Creating folder "images"...';
                                      if (!@mkdir('../media/images') && is_dir('../media/images') == false) {
                                          echo '<span class="error">ERROR: Unable to create "images" folder</span></p>';
                                      } else {
                                          echo '<span class="ok">OK</span></p>';
                                          echo '<p>Creating folder "js"...';
                                          if (!@mkdir('../media/js') && is_dir('../media/js') == false) {
                                              echo '<span class="error">ERROR: Unable to create "js" folder</span></p>';
                                          } else {
                                              echo '<span class="ok">OK</span></p>';
                                              echo '<p>Creating folder "smilies"...';
                                              if (!@mkdir('../media/smilies') && is_dir('../media/smilies') == false) {
                                                  echo '<span class="error">ERROR: Unable to create "smilies" folder</span></p>';
                                              } else {
                                                  echo '<span class="ok">OK</span></p>';
                                                  echo '<p>Creating file "lib/shoutbox.class.php"...';
                                                  $options = array(
                                                      '##DB_HOST##' => $_GET['db_host'],
                                                      '##DB_CHARSET##' => 'utf8',
                                                      '##DB_USER##' => $_GET['db_user'],
                                                      '##DB_PASSWORD##' => $_GET['db_password'],
                                                      '##DB_NAME##' => $_GET['db_name'],
                                                      '##DB_PREFIX##' => $_GET['db_prefix'],
                                                      '##CHARSET##' => 'utf-8',
                                                      '##TITLE##' => $_GET['title'],
                                                      '##REFRESH##' => $_GET['refresh'],
                                                      '##SPAM##' => $_GET['spam']
                                                  );
                                                  if (!file_put_contents('../lib/shoutbox.class.php', str_replace(array_keys($options), array_values($options), base64_decode($base64Files['lib/shoutbox.class.php'])))) {
                                                      echo '<span class="error">ERROR: Unable to create the file</span></p>';
                                                  } else {
                                                      echo '<span class="ok">OK</span></p>';
                                                      echo '<p>Creating file "media/css/main.css"...';
                                                      if (!file_put_contents('../media/css/main.css', base64_decode($base64Files['media/css/main.css']))) {
                                                          echo '<span class="error">ERROR: Unable to create the file</span></p>';
                                                      } else {
                                                          echo '<span class="ok">OK</span></p>';
                                                          echo '<p>Creating file "media/css/mobile.css"...';
                                                          if (!file_put_contents('../media/css/mobile.css', base64_decode($base64Files['media/css/mobile.css']))) {
                                                              echo '<span class="error">ERROR: Unable to create the file</span></p>';
                                                          } else {
                                                          echo '<span class="ok">OK</span></p>';
                                                          echo '<p>Creating image files in "media/images/"...';
                                                          if (!file_put_contents('../media/images/favicon.png', base64_decode($base64Files['media/images/favicon.png'])) ||
                                                              !file_put_contents('../media/images/icon-shoutbox.png', base64_decode($base64Files['media/images/icon-shoutbox.png'])) ||
                                                              !file_put_contents('../media/images/loader.gif', base64_decode($base64Files['media/images/loader.gif']))) {
                                                              echo '<span class="error">ERROR: Unable to create the files</span></p>';
                                                          } else {
                                                              echo '<span class="ok">OK</span></p>';
                                                              echo '<p>Creating js files in "media/js/"...';
                                                              if (!file_put_contents('../media/js/jquery.charcounter.js', base64_decode($base64Files['media/js/jquery.charcounter.js'])) || 
                                                                  !file_put_contents('../media/js/jquery.placeholder.js', base64_decode($base64Files['media/js/jquery.placeholder.js'])) ||
                                                                  !file_put_contents('../media/js/jquery.js', base64_decode($base64Files['media/js/jquery.js'])) ||
                                                                  !file_put_contents('../media/js/shoutbox.js', base64_decode($base64Files['media/js/shoutbox.js']))) {
                                                                  echo '<span class="error">ERROR: Unable to create the files</span></p>';
                                                              } else {
                                                                  echo '<span class="ok">OK</span></p>';
                                                                  echo '<p>Creating image files in "media/smilies/"...';
                                                                  if (!file_put_contents('../media/smilies/1.png', base64_decode($base64Files['media/smilies/1.png'])) || 
                                                                      !file_put_contents('../media/smilies/2.png', base64_decode($base64Files['media/smilies/2.png'])) ||
                                                                      !file_put_contents('../media/smilies/3.png', base64_decode($base64Files['media/smilies/3.png'])) ||
                                                                      !file_put_contents('../media/smilies/4.png', base64_decode($base64Files['media/smilies/4.png'])) ||
                                                                      !file_put_contents('../media/smilies/5.png', base64_decode($base64Files['media/smilies/5.png'])) ||
                                                                      !file_put_contents('../media/smilies/6.png', base64_decode($base64Files['media/smilies/6.png'])) ||
                                                                      !file_put_contents('../media/smilies/7.png', base64_decode($base64Files['media/smilies/7.png'])) ||
                                                                      !file_put_contents('../media/smilies/8.png', base64_decode($base64Files['media/smilies/8.png'])) ||
                                                                      !file_put_contents('../media/smilies/9.png', base64_decode($base64Files['media/smilies/9.png'])) ||
                                                                      !file_put_contents('../media/smilies/10.png', base64_decode($base64Files['media/smilies/10.png'])) ||
                                                                      !file_put_contents('../media/smilies/11.png', base64_decode($base64Files['media/smilies/11.png'])) ||
                                                                      !file_put_contents('../media/smilies/12.png', base64_decode($base64Files['media/smilies/12.png'])) ||
                                                                      !file_put_contents('../media/smilies/13.png', base64_decode($base64Files['media/smilies/13.png'])) ||
                                                                      !file_put_contents('../media/smilies/14.png', base64_decode($base64Files['media/smilies/14.png'])) ||
                                                                      !file_put_contents('../media/smilies/15.png', base64_decode($base64Files['media/smilies/15.png'])) ||
                                                                      !file_put_contents('../media/smilies/16.png', base64_decode($base64Files['media/smilies/16.png'])) ||
                                                                      !file_put_contents('../media/smilies/17.png', base64_decode($base64Files['media/smilies/17.png'])) ||
                                                                      !file_put_contents('../media/smilies/18.png', base64_decode($base64Files['media/smilies/18.png'])) ||
                                                                      !file_put_contents('../media/smilies/19.png', base64_decode($base64Files['media/smilies/19.png'])) ||
                                                                      !file_put_contents('../media/smilies/20.png', base64_decode($base64Files['media/smilies/20.png'])) ||
                                                                      !file_put_contents('../media/smilies/21.png', base64_decode($base64Files['media/smilies/21.png'])) ||
                                                                      !file_put_contents('../media/smilies/22.png', base64_decode($base64Files['media/smilies/22.png'])) ||
                                                                      !file_put_contents('../media/smilies/23.png', base64_decode($base64Files['media/smilies/23.png'])) ||
                                                                      !file_put_contents('../media/smilies/24.png', base64_decode($base64Files['media/smilies/24.png'])) ||
                                                                      !file_put_contents('../media/smilies/25.png', base64_decode($base64Files['media/smilies/25.png'])) ||
                                                                      !file_put_contents('../media/smilies/26.png', base64_decode($base64Files['media/smilies/26.png'])) ||
                                                                      !file_put_contents('../media/smilies/27.png', base64_decode($base64Files['media/smilies/27.png'])) ||
                                                                      !file_put_contents('../media/smilies/28.png', base64_decode($base64Files['media/smilies/28.png'])) ||
                                                                      !file_put_contents('../media/smilies/29.png', base64_decode($base64Files['media/smilies/29.png'])) ||
                                                                      !file_put_contents('../media/smilies/30.png', base64_decode($base64Files['media/smilies/30.png'])) ||
                                                                      !file_put_contents('../media/smilies/31.png', base64_decode($base64Files['media/smilies/31.png'])) ||
                                                                      !file_put_contents('../media/smilies/32.png', base64_decode($base64Files['media/smilies/32.png']))) {
                                                                      echo '<span class="error">ERROR: Unable to create the files</span></p>';
                                                                  } else {
                                                                      echo '<span class="ok">OK</span></p>';
                                                                      echo '<p>Creating file ".htaccess"...';
                                                                      if (!file_put_contents('../.htaccess', base64_decode($base64Files['.htaccess']))) {
                                                                          echo '<span class="error">ERROR: Unable to create the files</span></p>';
                                                                      } else {
                                                                          echo '<span class="ok">OK</span></p>';
                                                                          echo '<p>Creating file "ajax.php"...';
                                                                          if (!file_put_contents('../ajax.php', base64_decode($base64Files['ajax.php']))) {
                                                                              echo '<span class="error">ERROR: Unable to create the files</span></p>';
                                                                          } else {
                                                                              echo '<span class="ok">OK</span></p>';
                                                                              echo '<p>Creating file "index.php"...';
                                                                              if (!file_put_contents('../index.php', base64_decode($base64Files['index.php']))) {
                                                                                  echo '<span class="error">ERROR: Unable to create the files</span></p>';
                                                                              } else {
                                                                                  echo '<span class="ok">OK</span></p>';
                                                                                  echo '<p>&nbsp;</p><p><span class="ok">All files have been created.</span></p><p>&nbsp;</p>';
                                                                              }
                                                                          }
                                                                      }
                                                                  }
                                                              }
                                                          }
                                                      }
                                                  }
                                              }
                                          }
                                      }
                                  }
                              }
                          }
                      }
                  }
                  }
                  ?>
                  <p>&nbsp;</p>
                  <p><input type="button" class="button" value="Next &raquo;" name="index.php?step=5" /></p>
                <?php
                break;
                case 5:
                ?>
                  <h1><img src="<?php echo $base64Inline['finish']; ?>" alt="" /> Finish</h1>
                  <p><b><span class="ok">Congratulation, the shoutbox has been successfully installed.</span></b></p>
                  <p>&nbsp;</p>
                  <p><b>Please delete the "install" folder if it was not deleted.</b></p>
                  <p>&nbsp;</p>
                  <p><input type="button" class="button" value="Go to the shoutbox &raquo;" name="../" /></p>
                  <?php
                    @unlink('index.php');
                    @rmdir('./');
                  ?>
                <?php
                break;
                default:
                ?>
                  <h1><img src="<?php echo $base64Inline['globe']; ?>" alt="" /> Introduction</h1>
                  <p>Welcome to the Shoutbox Installation/Update Wizard. This wizard will help you to install the Shoutbox with ease on your webspace/server.</p>
                  <p>&nbsp;</p>
                  <p>After each successful step click on "Next" button.</p>
                  <p>&nbsp;</p>
                  <p><input type="button" class="button" value="Next &raquo;" name="index.php?step=1" /></p>
                <?php
                break;
            }
          ?>
        </div>
      </div>
      <div id="footer">
        &copy; <?php echo date('Y'); ?> NellyB
      </div>
    </div>
  </body>
</html>