<?php
/**
 * Unreal Studio
 * Project: UnrealLicensing
 * User: jhollsoliver
 * Date: 03/06/15
 * Time: 16:38
 */

/**
 * Configuration Includes
 */

include_once 'config.php';

if(!isset($BaseURL))
{
    header("Location: install/");
}

/**
 * Library Includes
 */
include_once 'libs/RevAlgo.php';
include_once 'libs/Gauntlet.php';
include_once 'libs/Tools.php';

/**
 * Library Object Initialization
 */

$Gauntlet = new Gauntlet();
$RevAlgo = new RevAlgo($RevAlgoCfg['key'], $RevAlgoCfg['sep']);
$Tools = new Tools();
@$DatabaseHandler = new mysqli($Database['host'], $Database['user'], $Database['pass'], $Database['data']);
if($DatabaseHandler->connect_errno > 0)
{
    include 'system/errors/db_conn.php';
    die();
}

$Tools->RegisterClass('DbHandler', $DatabaseHandler);



/**
 * Constants Declaration
 */
define('BASE_URL', $BaseURL);
define('ASSETS_URL', $BaseURL.'/assets');
unset($BaseURL);
define('PRODUCT_NAME', 'PHPMyLicense');
define('PRODUCT_VERSION', '3.1.4');
define('SYSTEMPATH', dirname(__FILE__));
define('PHPMYLICENSE_API', 'http://api.phpmylicense.com/v1');
define('PHPMYLICENSE_UPDATESERVICE', 'http://updates.phpmylicense.com');
$query = $DatabaseHandler->query("SELECT configurations FROM settings");
$data = $query->fetch_array();
$data = json_decode($data['configurations']);
define('PRODUCT_UPDATECHANNEL', $data->updatechannel);


/**
 * Session Declaration
 */

session_start();