<?php
/**
 * Unreal Studio
 * Project: UnrealLicensing
 * User: jhollsoliver
 * Date: 06/06/15
 * Time: 10:31
 */

include_once '../system/autoloader.php';
$sql = "SELECT configurations FROM settings";
$query = $DatabaseHandler->query($sql);
$data = $query->fetch_array();
$configurations = json_decode($data['configurations'], true);

if(isset($_REQUEST['domain']))
{
    $domain = $Gauntlet->filter($_REQUEST['domain']);
    if(isset($_REQUEST['product']))
    {
        $product = $Gauntlet->filter($_REQUEST['product']);
    }else{
        $product = 0;
    }

    if (strpos($domain, "www.") === 0) {
        $URL1 = $domain;
        $URL2 = preg_replace("/www./", "", $domain, 1);
    } else {
        $URL1 = $domain;
        $URL2 = "www." . $domain;
    }
    $now = time();

    $sql = "SELECT trialtime, sandbox FROM products WHERE id = '$product'";
    @$query = $DatabaseHandler->query($sql);
    $productdata = $query->fetch_array();

    if($productdata['sandbox'] == true)
    {
        $json['status'] = 200;
        $json['message'] = 'License is valid by Sandbox.';
        die(json_encode($json));
    }


    //$sql = "SELECT id FROM licenses WHERE expirydate > '$now' AND host = '$URL1' OR '$URL2' AND productid = '$product' AND status = 'ACTIVE'";
    $sql = "SELECT id, status, expirydate, parameters FROM licenses WHERE productid = '$product' AND host IN ('$URL1', '$URL2')";
    @$query = $DatabaseHandler->query($sql);
    if($query)
    {
        if($query->num_rows > 0)
        {
            $licensedata = $query->fetch_array();
            if($licensedata['status'] == 'active')
            {
                if($licensedata['expirydate'] > $now)
                {
                    $json['status'] = 200;
                    $json['message'] = 'License is valid.';
                    if(isset($licensedata['parameters']) && $licensedata['parameters'] <> '')
                    {
                        $parameters = $licensedata['parameters'];
                        parse_str($parameters, $parameters);
                        $json['parameters'] = $parameters;
                    }
                    die(json_encode($json));

                }else{
                    $json['status'] = 301;
                    $json['message'] = 'Your license is expired';
                    die(json_encode($json));
                }
            }else{
                switch($licensedata['status'])
                {
                    case 'inactive':
                        $json['status'] = 301;
                        $json['message'] = 'Your license is inactive. Maybe, you need to activate it.';
                        die(json_encode($json));
                        break;
                    case 'processing':
                        $json['status'] = 301;
                        $json['message'] = 'Your license is in processing status. Wait some time and try again.';
                        die(json_encode($json));
                        break;
                    case 'suspended':
                        $json['status'] = 301;
                        $json['message'] = 'Your license is suspended. Contact the Administrator.';
                        die(json_encode($json));
                        break;
                    default:
                        $json['status'] = 301;
                        $json['message'] = 'Your license is inactive. Maybe, you need to activate it.';
                        die(json_encode($json));
                        break;
                }
            }


        }else{
            if($productdata['trialtime'] > 0)
            {
                //$licensekey = $Tools->create_guid();
                $licensekey = $Tools->GenSerialByMask($configurations['serialmask']);
                $trialtime = $productdata['trialtime'];
                $expirydate = strtotime("+$trialtime days");
                $sql = "INSERT INTO `licenses`(`host`, `licensekey`, `customer_email`, `expirydate`, `productid`, `status`, `issued-by`, `comments`) VALUES ('$URL1','$licensekey','automatic@issuer.php','$expirydate','$product','active','1','Issued by Trial Time Automatic Setup')";
                @$query = $DatabaseHandler->query($sql);
                if($query)
                {
                    $json['status'] = 200;
                    $json['message'] = 'License in Trial.';
                    die(json_encode($json));
                }else{
                    $json['status'] = 500;
                    $json['message'] = 'Error while setup your trial.';
                    die(json_encode($json));
                }
            }else{
                $json['status'] = 301;
                $json['message'] = 'License not Found';
                die(json_encode($json));
            }
        }
    }

}


if(isset($_REQUEST['handler']) && isset($_REQUEST['apikey']))
{
    $handler = $_REQUEST['handler'];
    $key = $_REQUEST['apikey'];

    if($key <> $APIKey)
    {
        $json['status'] = 401;
        $json['message'] = 'Invalid API Key';
        die(json_encode($json));
    }

    if($handler == 'addlicense')
    {
        $domain = $Gauntlet->filter($_REQUEST['host']);
        $expirydate  = $Gauntlet->filter($_REQUEST['expirydate']);
        if(!$Tools->is_timestamp($expirydate))
        {
            $json['status'] = 500;
            $json['message'] = 'Invalid Expiration Date. You need to input a Timestamp';
            die(json_encode($json));
        }
        $status = $_REQUEST['status'];
        $customer_email = $Gauntlet->filter($_REQUEST['customer_email']);
        $productid = $Gauntlet->filter($_REQUEST['productid']);
        $comments = 'Issued by Online API';
        $LicenseKey = strtolower($Tools->create_guid());
        switch($status)
        {
            case 'active':
                $status = 'active';
                break;
            case 'inactive':
                $status = 'inactive';
                break;
            case 'processing':
                $status = 'processing';
                break;
            default:
                $status = 'inactive';
                break;
        }

        $sql = "INSERT INTO `licenses` (`host`, `licensekey`, `customer_email`, `expirydate`, `productid`, `status`, `issued-by`, `comments`) VALUES ('$domain', '$LicenseKey', '$customer_email', '$expirydate', '$productid', '$status', '1', '$comments');";
        $query = $DatabaseHandler->query($sql);
        if($query)
        {
            $json['status'] = 200;
            $json['message'] = 'License Issued';
            die(json_encode($json));
        }else{
            $json['status'] = 500;
            $json['message'] = 'Database Error.';
            die(json_encode($json));
        }
    }else if($handler == 'toggle_licensestatus')
    {

    }
    else{

        $json['status'] = 500;
        $json['message'] = 'Unknown Handler';
        die(json_encode($json));
    }
}else{
    $json['status'] = 500;
    $json['message'] = 'Missing Parameters';
    die(json_encode($json));
}
