/* ! Loopbutton v1.0.0 Copyright 2014 Charlotte Dunois https://github.com/CharlotteDunois/videojs-loopbutton/blob/master/LICENSE.md ! */
videojs.plugin('loopbutton', function(options) {
	var player = this;
	
	_V_.LoopButton = _V_.Button.extend({
		init: function(player, options) {
			_V_.Button.call(this, player, options);
			this.on('click', this.onClick);
		}
    });

    _V_.LoopButton.prototype.onClick = function() {
		if(player.loop == true) {
			player.loop = false;
			this.removeClass('vjs-control-active');
		} else {
			player.loop = true;
			this.addClass('vjs-control-active');
		}
    };
    player.ready(function(){
		var button = new _V_.LoopButton(player,  { el: _V_.Component.prototype.createEl(null, { className	: 'vjs-loop-button vjs-menu-button', role: 'button' }) });
		player.controlBar.addChild(button);
		
		player.on('ended', function() {
			if(player.loop == true) {
				player.play();
			}
		});
	});
});