/**
 * @version 7.1
 */
$(document).ready(function () {
    /* ADMIN SEARCH AUTOCOMPLETE BOX */
    $("[name='admin_quick_nav']").autocomplete({
        source: function (request, response) {

            $.ajax({
                url: paths.quickNavigation,
                dataType: "json",
                data: {
                    input: request.term
                },
                success: function (data) {
                    //map the data into a response that will be understood by the autocomplete widget
                    response($.map(data, function (item) {
                        return {
                            label: item.label,
                            path: item.path
                        }
                    }));
                    $(".ui-helper-hidden-accessible").hide();
                }
            });
        },
        //start looking at 2 characters
        minLength: 2,
        //when you have selected something
        select: function (event, ui) {
            if (ui.item.path != '') {
                window.location.href = ui.item.path;
            }
        },
        //show the drop down
        open: function () {
            $(this).removeClass("ui-corner-all").addClass("ui-corner-top");
        },
        //close the drop down
        close: function () {
            $(this).removeClass("ui-corner-top").addClass("ui-corner-all");
        }
    });

    $("[name='init_category_counters']").on('click', function (e) {
        e.preventDefault();

        var limit = 10;
        var offset = 0;
        var total = 0;
        var button = $(this);
        var buttonValue = button.html();
        button.html('Please wait..').attr('disabled', true);

        $.ajax({
            url: paths.initCategoryCounters,
            dataType: "json",
            async: true,
            success: function (data) {
                var counter = parseInt(data.counter);

                var progress = counter + offset;
                $('#category-counters-progress').html(progress + ' listings counted.');

                button.attr('disabled', false).html(buttonValue);
            }
        });
    });
});

//function initializeCategoryCounters(limit, offset) {
//    $.ajax({
//        url: baseUrl + '/admin/index/initialize-category-counters',
//        dataType: "json",
//        async: true,
//        data: {
//            limit: limit,
//            offset: offset
//        },
//        success: function (data) {
//            var counter = parseInt(data.counter);
//
//            var progress = counter + offset;
//            $('#category-counters-progress').html(progress + ' listings counted.');
//
//            return counter;
//        }
//    });
//}