<?php

/**
 *
 * PHP Pro Bid $Id$ auiV49kK6zeENYcAW76hpWGXO2XUG6c0W4W3EDeN6jo=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.0
 */
/**
 * members module - tools management controller
 */

namespace Members\Controller;

use Members\Controller\Action\AbstractAction,
    Ppb\Service,
    Ppb\Db\Table,
    Cube\Paginator,
    Ppb\Db\Table\Row\Listing as ListingModel,
    Members\Form;

class Tools extends AbstractAction
{

    /**
     *
     * vouchers service
     *
     * @var \Ppb\Service\Vouchers
     */
    protected $_vouchers;

    public function init()
    {
        $this->_vouchers = new Service\Vouchers();
    }

    public function GlobalSettings()
    {
        $form = new Form\Register('global_settings', null, $this->_user);

        if ($this->getRequest()->isPost()) {
            $params = $this->getRequest()->getParams();

            $form->setData($params);

            if ($form->isValid() === true) {
                $this->_user->updateGlobalSettings($params);

                $this->_flashMessenger->setMessage(array(
                    'msg'   => $this->_('The settings have been saved successfully.'),
                    'class' => 'alert-success',
                ));
            }
            else {
                $this->_flashMessenger->setMessage(array(
                    'msg'   => $form->getMessages(),
                    'class' => 'alert-danger',
                ));
            }
        }
        else {
            $form->setData(
                $this->_user->getGlobalSettings());
        }

        return array(
            'controller' => 'Selling',
            'headline'   => $this->_('Global Settings'),
            'form'       => $form,
            'messages'   => $this->_flashMessenger->getMessages()
        );
    }

    public function FeesCalculator()
    {
        $listingFees = false;
        $listingSetupService = null;

        $form = new Form\FeesCalculator();

        $params = $this->getRequest()->getParams();
        $form->setData($params);

        if ($form->isPost(
            $this->getRequest())
        ) {


            if ($form->isValid() === true) {
                $listingsService = new Service\Listings();
                $listingModel = new ListingModel(array(
                    'data'  => $params,
                    'table' => $listingsService->getTable()
                ));

                $listingSetupService = new Service\Fees\ListingSetup(
                    $listingModel, $this->_user);

                $listingFees = $listingSetupService->calculate();
            }
            else {
                $this->_flashMessenger->setMessage(array(
                    'msg'   => $form->getMessages(),
                    'class' => 'alert-danger',
                ));
            }
        }

        return array(
            'controller'          => 'Selling',
            'headline'            => $this->_('Fees Calculator'),
            'form'                => $form,
            'listingFees'         => $listingFees,
            'listingSetupService' => $listingSetupService,
            'messages'            => $this->_flashMessenger->getMessages(),
        );
    }

    public function PostageSetup()
    {
        $form = new Form\PostageSetup();

        if ($form->isPost(
            $this->getRequest())
        ) {
            $params = $this->getRequest()->getParams();

            $form->setData($params);

            if ($form->isValid() === true) {
                $this->_user->updatePostageSettings($params);

                $this->_flashMessenger->setMessage(array(
                    'msg'   => $this->_('The settings have been saved successfully.'),
                    'class' => 'alert-success',
                ));
            }
            else {
                $this->_flashMessenger->setMessage(array(
                    'msg'   => $form->getMessages(),
                    'class' => 'alert-danger',
                ));
            }
        }
        else {
            $form->setData(
                $this->_user->getPostageSettings());
        }

        return array(
            'controller' => 'Selling',
            'headline'   => $this->_('Postage Setup'),
            'form'       => $form,
            'messages'   => $this->_flashMessenger->getMessages()
        );
    }

    public function PrefilledFields()
    {
        $form = new Form\PrefilledFields();

        if ($form->isPost(
            $this->getRequest())
        ) {
            $params = $this->getRequest()->getParams();

            $form->setData($params);

            if ($form->isValid() === true) {
                $this->_user->updatePrefilledFields($params);

                $this->_flashMessenger->setMessage(array(
                    'msg'   => $this->_('The settings have been saved successfully.'),
                    'class' => 'alert-success',
                ));
            }
            else {
                $this->_flashMessenger->setMessage(array(
                    'msg'   => $form->getMessages(),
                    'class' => 'alert-danger',
                ));
            }
        }
        else {
            $form->setData(
                (array)$this->_user->getPrefilledFields());
        }

        return array(
            'controller' => 'Selling',
            'headline'   => $this->_('Selling Prefilled Fields'),
            'form'       => $form,
            'messages'   => $this->_flashMessenger->getMessages(),
        );
    }


    public function BlockUsers()
    {
        return array(
            'controller' => 'Selling',
            'headline'   => $this->_('Block Users'),
        );
    }

    public function WatchedItems()
    {
        $listingsWatchService = new Service\ListingsWatch();

//        if ($this->getRequest()->getParam('option') == 'remove') {
//            $listingsWatchService->delete($this->getRequest()->getParam('id'), $this->_user['id']);
//
//            $this->_flashMessenger->setMessage(array(
//                'msg'   => $this->_('The listing has been removed from your watch list.'),
//                'class' => 'alert-success',
//            ));
//        }

        if ($this->getRequest()->getParam('option') == 'delete') {
            $id = $this->getRequest()->getParam('id');
            $option = $this->getRequest()->getParam('option');

            $messages = array();

            $ids = array_filter(
                array_values((array)$id));

            if (count($ids) > 0) {
                $this->_flashMessenger->setMessage(array(
                    'msg'   => $this->_('The selected listings have been removed from your watch list.'),
                    'class' => 'alert-success',
                ));

                $listingsWatchService->delete($ids, $this->_user['id']);
            }
        }

        $select = $listingsWatchService->getTable()->select()
            ->where('user_id = ?', $this->_user['id']);

        $paginator = new Paginator(
            new Paginator\Adapter\DbTableSelect($select, $listingsWatchService->getTable()));

        $pageNumber = $this->getRequest()->getParam('page');
        $paginator->setPageRange(5)
            ->setItemCountPerPage(20)
            ->setCurrentPageNumber($pageNumber);

        return array(
            'controller' => 'Buying',
            'paginator'  => $paginator,
            'messages'   => $this->_flashMessenger->getMessages(),
        );
    }

    public function FavoriteStores()
    {
        $favoriteStoresService = new Service\FavoriteStores();

        if ($this->getRequest()->getParam('option') == 'remove') {
            $favoriteStoresService->delete($this->getRequest()->getParam('id'), $this->_user['id']);

            $this->_flashMessenger->setMessage(array(
                'msg'   => $this->_('The store has been removed from your favorites list.'),
                'class' => 'alert-success',
            ));
        }

        $select = $favoriteStoresService->getTable()->select()
            ->where('user_id = ?', $this->_user['id']);

        $paginator = new Paginator(
            new Paginator\Adapter\DbTableSelect($select, $favoriteStoresService->getTable()));

        $pageNumber = $this->getRequest()->getParam('page');
        $paginator->setPageRange(5)
            ->setItemCountPerPage(20)
            ->setCurrentPageNumber($pageNumber);

        return array(
            'controller' => 'Buying',
            'paginator'  => $paginator,
            'messages'   => $this->_flashMessenger->getMessages(),
        );
    }

    public function Vouchers()
    {
        $code = $this->getRequest()->getParam('code');

        $inAdmin = $this->_loggedInAdmin();

        $select = $this->_vouchers->getTable()->select()
            ->order(array('created_at DESC'));

        if ($inAdmin) {
            $select->where('user_id is null');
        }
        else {
            $select->where('user_id = ?', $this->_user['id']);
        }

        if ($code !== null) {
            $params = '%' . str_replace(' ', '%', $code) . '%';
            $select->where('code LIKE ?', $params);
        }

        $paginator = new Paginator(
            new Paginator\Adapter\DbTableSelect($select, $this->_vouchers->getTable()));

        $pageNumber = $this->getRequest()->getParam('page');
        $paginator->setPageRange(5)
            ->setItemCountPerPage(10)
            ->setCurrentPageNumber($pageNumber);

        return array(
            'controller' => ($inAdmin) ? 'Tools' : 'Selling',
            'code'       => $code,
            'paginator'  => $paginator,
            'messages'   => $this->_flashMessenger->getMessages(),
        );
    }


    public function AddVoucher()
    {
        $this->_forward('edit-voucher');
    }

    public function EditVoucher()
    {
        $id = $this->getRequest()->getParam('id');

        $inAdmin = $this->_loggedInAdmin();

        if ($id) {
            $select = $this->_vouchers->getTable()->select()
                ->where('id = ?', $id);

            if (!$inAdmin) {
                $select->where('user_id = ?', $this->_user['id']);
            }

            $data = $this->_vouchers->getTable()->fetchRow($select);

            if (count($data) > 0) {
                $data = $data->toArray();
            }
            else {
                $id = null;
                $data = array();
            }
        }

        $userId = null;
        if (!$inAdmin) {
            $userId = $this->_user['id'];
        }

        $form = new \Members\Form\Voucher(null, $userId);

        if ($id) {
            $form->setData($data)
                ->generateEditForm();
        }

        if ($this->getRequest()->isPost()) {
            $params = $this->getRequest()->getParams();
            $form->setData($params);

            if ($form->isValid() === true) {
                $params['user_id'] = ($inAdmin) ? null : $this->_user['id'];

                $this->_vouchers->save($params);

                $this->_flashMessenger->setMessage(array(
                    'msg'   => ($id) ?
                            $this->_('The voucher has been edited successfully') :
                            $this->_('The voucher has been created successfully.'),
                    'class' => 'alert-success',
                ));

                if ($inAdmin) {
                    $this->_helper->redirector()->redirect('vouchers', 'tools', 'admin', array());
                }
                else {
                    $this->_helper->redirector()->redirect('vouchers', null, null, array());
                }
            }
            else {
                $this->_flashMessenger->setMessage(array(
                    'msg'   => $form->getMessages(),
                    'class' => 'alert-danger',
                ));
            }
        }

        return array(
            'controller' => ($inAdmin) ? 'Tools' : 'Selling',
            'headline'   => ($id) ? $this->_('Edit Voucher') : $this->_('Create Voucher'),
            'form'       => $form,
            'messages'   => $this->_flashMessenger->getMessages(),
        );
    }

    public function DeleteVoucher()
    {
        $id = $this->getRequest()->getParam('id');

        $inAdmin = $this->_loggedInAdmin();

        $userId = ($inAdmin) ? null : $this->_user['id'];

        $result = $this->_vouchers->delete($id, $userId);

        $translate = $this->getTranslate();

        if ($result) {
            $this->_flashMessenger->setMessage(array(
                'msg'   => sprintf($translate->_("Voucher ID: #%s has been deleted."), $id),
                'class' => 'alert-success',
            ));
        }
        else {
            $this->_flashMessenger->setMessage(array(
                'msg'   => $this->_('Deletion failed. The voucher could not be found.'),
                'class' => 'alert-danger',
            ));
        }

        if ($inAdmin) {
            $this->_helper->redirector()->redirect('vouchers', 'tools', 'admin', array());
        }
        else {
            $this->_helper->redirector()->redirect('vouchers', null, null, array());
        }
    }

}

