<?php

/**
 *
 * PHP Pro Bid $Id$ +Doz6/DPydu/kGd35ALyJsNd6ahEO4gnCJG6hpwRpI0=
 *
 * @link        http://www.phpprobid.com
 * @copyright   Copyright (c) 2014 Only For Testing BBC No Leech & CodeCube SRL
 * @license     http://www.phpprobid.com/license Commercial License
 *
 * @version     7.0
 */
/**
 * members module - selling controller
 */

namespace Members\Controller;

use Members\Controller\Action\AbstractAction,
    Ppb\Service,
    Cube\Paginator;

class Selling extends AbstractAction
{

    /**
     *
     * listings service
     *
     * @var \Ppb\Service\Listings
     */
    protected $_listings;

    public function init()
    {
        $this->_listings = new Service\Listings();
    }

    public function Browse()
    {
        $filter = $this->getRequest()->getParam('filter', 'open');

        $select = $this->_listings->select(Service\Listings::SELECT_MEMBERS);

        if ($this->getRequest()->isPost()) {
            $id = $this->getRequest()->getParam('id');
            $option = $this->getRequest()->getParam('option');

            $messages = array();

            $ids = array_filter(
                array_values((array)$id));

            $counter = null;

            if (count($ids) > 0) {
                $where = $this->_listings->getTable()->getAdapter()->quoteInto("id IN (?)", $ids);
                $listings = $this->_listings->fetchAll($where, null, null, null, false, true);
                $messages = $listings->changeStatus($option);

                $counter = count($listings);
            }

            if ($counter > 0) {
                $this->_flashMessenger->setMessage(array(
                    'msg'   => sprintf($this->_listings->getStatusMessage($option), $counter),
                    'class' => 'alert-success',
                ));
            }
            else {
                $this->_flashMessenger->setMessage(array(
                    'msg'   => $this->_('No listings have been updated.'),
                    'class' => 'alert-danger',
                ));
            }

            if (count($messages) > 0) {
                $this->_flashMessenger->setMessage(array(
                    'msg'   => $messages,
                    'class' => 'alert-info',
                ));
            }
        }

        $paginator = new Paginator(
            new Paginator\Adapter\DbTableSelect($select, $this->_listings->getTable()));

        $pageNumber = $this->getRequest()->getParam('page');
        $paginator->setPageRange(5)
            ->setItemCountPerPage(10)
            ->setCurrentPageNumber($pageNumber);

        return array(
            'filter'             => $filter,
            'keywords'           => $this->getRequest()->getParam('keywords'),
            'listingId'          => $this->getRequest()->getParam('listing_id'),
            'paginator'          => $paginator,
            'messages'           => $this->_flashMessenger->getMessages(),
            'params'             => $this->getRequest()->getParams(),
            'sellerVerification' => !($this->_user->isVerified('seller')),
        );
    }

}

